/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.client;

import com.deadzoke.ignitehud.api.clock.ClockApi;
import com.deadzoke.ignitehud.api.clock.IClockLine;
import com.deadzoke.ignitehud.api.clock.IClockLineProvider;
import com.deadzoke.ignitehud.api.widget.IWidgetBarProvider;
import com.deadzoke.ignitehud.api.widget.WidgetApi;
import com.deadzoke.ignitehud.api.widget.WidgetAttribute;
import com.deadzoke.ignitehud.api.widget.WidgetBar;
import com.deadzoke.ignitehud.api.widget.WidgetBarExtension;
import com.deadzoke.ignitehud.client.GuiBossBar;
import com.deadzoke.ignitehud.client.GuiItems;
import com.deadzoke.ignitehud.client.GuiPlayerAttributes;
import com.deadzoke.ignitehud.config.Config;
import com.deadzoke.ignitehud.util.ColorUtil;
import com.deadzoke.ignitehud.util.GameUtil;
import com.deadzoke.ignitehud.util.RenderUtil;
import com.deadzoke.ignitehud.util.TextUtil;
import com.deadzoke.ignitehud.util.Texture;
import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.GameType;
import net.neoforged.neoforge.client.extensions.common.IClientMobEffectExtensions;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class GuiOverlay {
    private static final Texture GUI_BASE = new Texture("base", 64);
    private static final Texture GUI_EXPERIENCE = new Texture("experience", 16, 32);
    private static final Texture GUI_BAR_EFFECT_BLINK = new Texture("bars/effect-blink", 128, 16);
    private static final Texture GUI_BAR_EFFECT_GLINT = new Texture("bars/effect-glint", 128);
    private static final Texture GUI_AIR = new Texture("air", 128, 32);
    private static final Texture GUI_MOUNT = new Texture("mount", 128, 64);
    private static final Texture GUI_EVENT = new Texture("event", 256, 128);
    private static final Texture GUI_EFFECTS = new Texture("effects", 64);
    private static final Texture GUI_CLOCK = new Texture("clock", 16);
    private static final Texture GUI_NUMBERS_ROMAN = new Texture("numbers-roman", 24, 60);
    private static final ResourceLocation PET_ICON = RenderUtil.getIconTexture("pet");

    public static void renderHardcoreIcon(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.hardcoreIconEnable.getAsBoolean() || mc.options.hideGui || !GameUtil.shouldDrawSurvivalHUD() || mc.level == null || !mc.level.getLevelData().isHardcore()) {
            return;
        }
        RenderUtil.push("hardcore_icon");
        int posX = 30;
        int posY = 14;
        boolean uvX = false;
        int uvY = 29;
        int uvW = 10;
        int uvH = 10;
        guiGraphics.blit(GUI_BASE.get(), posX, posY, (float)uvX, (float)uvY, uvW, uvH, GuiOverlay.GUI_BASE.width, GuiOverlay.GUI_BASE.height);
        RenderUtil.pop();
    }

    public static void renderExperienceLevel(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.experienceLevelEnable.getAsBoolean() || mc.player == null || mc.options.hideGui || mc.gameMode == null || !mc.gameMode.hasExperience() || !GameUtil.shouldDrawSurvivalHUD()) {
            return;
        }
        RenderUtil.push("experience_level");
        int posX = 35;
        int posY = 38;
        String expLevel = String.valueOf(mc.player.experienceLevel);
        TextUtil.drawOutlinedString(guiGraphics, posX - mc.font.width(expLevel) / 2, posY, expLevel, ColorUtil.hexToDecimal("#C8FF8F"), ColorUtil.hexToDecimal("#000000"));
        RenderUtil.pop();
    }

    public static void renderPlayerFrame(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.playerFrameEnable.getAsBoolean() || mc.options.hideGui) {
            return;
        }
        RenderUtil.push("player_frame");
        int posX = 20;
        int posY = 15;
        int uvW = 29;
        int uvH = 29;
        guiGraphics.blit(GUI_BASE.get(), posX, posY, 0.0f, 0.0f, uvW, uvH, GuiOverlay.GUI_BASE.width, GuiOverlay.GUI_BASE.height);
        RenderUtil.pop();
    }

    public static void renderExperienceBar(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.experienceBarEnable.getAsBoolean() || mc.player == null || mc.options.hideGui || mc.gameMode == null || !mc.gameMode.hasExperience() || !GameUtil.shouldDrawSurvivalHUD()) {
            return;
        }
        RenderUtil.push("experience_bar");
        int posX = 18;
        int posY = 17;
        int uvW = 5;
        int uvH = 25;
        guiGraphics.blit(GUI_EXPERIENCE.get(), posX, posY, 0.0f, 0.0f, uvW, uvH, GuiOverlay.GUI_EXPERIENCE.width, GuiOverlay.GUI_EXPERIENCE.height);
        int progress = (int)Math.ceil(mc.player.experienceProgress * (float)uvH);
        guiGraphics.blit(GUI_EXPERIENCE.get(), posX, posY + uvH - progress, (float)uvW, (float)(uvH - progress), uvW, progress, GuiOverlay.GUI_EXPERIENCE.width, GuiOverlay.GUI_EXPERIENCE.height);
        RenderUtil.pop();
    }

    public static void renderPlayerIcon(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.playerIconEnable.getAsBoolean() || mc.options.hideGui || mc.player == null) {
            return;
        }
        RenderUtil.push("player_icon");
        int posX = 26;
        int posY = 21;
        int size = 17;
        ResourceLocation playerTexture = mc.player.getSkin().texture();
        guiGraphics.blit(playerTexture, posX, posY, (float)size, (float)size, size, size, size * 8, size * 8);
        if (mc.options.isModelPartEnabled(PlayerModelPart.HAT)) {
            guiGraphics.blit(playerTexture, posX, posY, (float)(size * 5), (float)size, size, size, size * 8, size * 8);
        }
        RenderUtil.pop();
    }

    public static void renderPlayerName(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.playerNameEnable.getAsBoolean() || mc.options.hideGui || mc.player == null) {
            return;
        }
        RenderUtil.push("player_name");
        int posX = 56;
        int posY = 16;
        if (!GameUtil.shouldDrawSurvivalHUD()) {
            posY = 26;
        }
        String text = mc.player.getDisplayName() != null ? mc.player.getDisplayName().getString() : "Player";
        guiGraphics.drawString(mc.font, text, posX, posY, ColorUtil.hexToDecimal("#FFFFFF"));
        RenderUtil.pop();
    }

    public static void renderPlayerBars(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.playerBarsEnable.getAsBoolean() || mc.options.hideGui || mc.player == null || !GameUtil.shouldDrawSurvivalHUD()) {
            return;
        }
        RenderUtil.push("player_bars");
        int posX = 54;
        int posY = 27;
        for (IWidgetBarProvider provider : WidgetApi.getBars()) {
            WidgetBar bar = provider.build();
            if (bar == null) continue;
            float barMaxValue = bar.getMaxValue();
            for (WidgetBarExtension extension : bar.getExtensions()) {
                barMaxValue += extension.getValue();
            }
            guiGraphics.blit(bar.getTexture(), posX, posY, 0.0f, 0.0f, 91, 5, 128, 16);
            RenderSystem.enableBlend();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, bar.getFade());
            int baseBarWidth = (int)Math.ceil(89.0f * bar.getValue() / barMaxValue);
            guiGraphics.blit(bar.getTexture(), posX + 1, posY + 1, 1.0f, 6.0f, baseBarWidth, 3, 128, 16);
            int extensionsUvX = baseBarWidth;
            float remainingBit = 0.0f;
            for (WidgetBarExtension extension : bar.getExtensions()) {
                int extensionBarWidthInt;
                float extensionBarWidth = 89.0f * extension.getValue() / barMaxValue;
                if ((remainingBit += extensionBarWidth - (float)(extensionBarWidthInt = (int)Math.floor(extensionBarWidth))) > 1.0f) {
                    ++extensionBarWidthInt;
                    remainingBit -= 1.0f;
                }
                guiGraphics.blit(extension.getTexture(), posX + 1 + extensionsUvX, posY + 1, (float)(1 + extensionsUvX), 6.0f, extensionBarWidthInt, 3, 128, 16);
                extensionsUvX += extensionBarWidthInt;
            }
            if (bar.hasBlink()) {
                RenderUtil.renderAnimation(guiGraphics, GUI_BAR_EFFECT_BLINK.get(), posX, posY, 0, 0, 91, 5, GuiOverlay.GUI_BAR_EFFECT_BLINK.width, GuiOverlay.GUI_BAR_EFFECT_BLINK.height, 0.25, 2);
            }
            if (bar.hasGlint()) {
                RenderUtil.renderAnimation(guiGraphics, GUI_BAR_EFFECT_GLINT.get(), posX, posY, 0, 0, 91, 5, GuiOverlay.GUI_BAR_EFFECT_GLINT.width, GuiOverlay.GUI_BAR_EFFECT_GLINT.height, 1.0, 20);
            }
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.disableBlend();
            posY += 6;
        }
        RenderUtil.pop();
    }

    public static void renderPlayerAttributes(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.playerAttributesEnable.getAsBoolean() || mc.options.hideGui || mc.player == null || !GameUtil.shouldDrawSurvivalHUD()) {
            return;
        }
        int posX = 55;
        int posY = 27 + WidgetApi.getBars().size() * 6 + 1;
        RenderUtil.push("player_attributes");
        for (WidgetAttribute attribute : GuiPlayerAttributes.getAttributes()) {
            if (attribute == null || !attribute.isVisible()) continue;
            RenderSystem.enableBlend();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, attribute.getFade());
            guiGraphics.blit(attribute.getIcon(), posX, posY, 0.0f, 0.0f, 10, 10, 10, 10);
            posX += 10;
            guiGraphics.drawString(mc.font, attribute.getValue(), posX += 2, posY + 1, attribute.getColor());
            posX += mc.font.width(attribute.getValue());
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.disableBlend();
            posX += 5;
        }
        RenderUtil.pop();
    }

    public static void renderAirLevel(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.airLevelEnable.getAsBoolean() || mc.options.hideGui || mc.player == null || !GameUtil.shouldDrawSurvivalHUD()) {
            return;
        }
        RenderUtil.push("air_level");
        int posX = (mc.getWindow().getGuiScaledWidth() - 121) / 2;
        int posY = mc.getWindow().getGuiScaledHeight() - 65;
        float air = mc.player.getAirSupply();
        if (mc.player.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value()) || air < 300.0f) {
            float airProgress = air / 300.0f;
            guiGraphics.blit(GUI_AIR.get(), posX, posY, 0.0f, 0.0f, 121, 5, GuiOverlay.GUI_AIR.width, GuiOverlay.GUI_AIR.height);
            guiGraphics.blit(GUI_AIR.get(), posX + 1, posY + 1, 1.0f, 6.0f, (int)(airProgress * 121.0f), 3, GuiOverlay.GUI_AIR.width, GuiOverlay.GUI_AIR.height);
            if (airProgress > 0.0f) {
                ResourceLocation icon = RenderUtil.getIconTexture("bubble");
                int iconIndex = Math.max((int)(-(air / 2.0f - 3.0f)), 0);
                guiGraphics.blit(icon, (mc.getWindow().getGuiScaledWidth() - 10) / 2, posY - 2, (float)(iconIndex * 10), 0.0f, 10, 10, 30, 10);
            }
        }
        RenderUtil.pop();
    }

    public static void renderVehicleInfo(GuiGraphics guiGraphics) {
        boolean canJump;
        Entity entity;
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.vehicleInfoEnable.getAsBoolean() || mc.options.hideGui || mc.player == null || !((entity = mc.player.getVehicle()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity vehicle = (LivingEntity)entity;
        int posX = 20;
        int linesPosX = posX + 6 + 5;
        int posY = 60;
        int linesPosY = posY + 3;
        int barHeight = 0;
        RenderUtil.push("vehicle_info");
        RenderUtil.renderIcon(guiGraphics, PET_ICON, linesPosX, linesPosY);
        guiGraphics.drawString(mc.font, vehicle.getName(), linesPosX + 10 + 2, linesPosY + 1, ColorUtil.hexToDecimal("#FFFFFF"));
        float healthProgress = Math.min(vehicle.getHealth() / vehicle.getMaxHealth(), 1.0f);
        guiGraphics.blit(GUI_MOUNT.get(), linesPosX, linesPosY + (barHeight += 12), 0.0f, 0.0f, 91, 5, GuiOverlay.GUI_MOUNT.width, GuiOverlay.GUI_MOUNT.height);
        guiGraphics.blit(GUI_MOUNT.get(), linesPosX, linesPosY + barHeight, 0.0f, 5.0f, (int)(91.0f * healthProgress), 5, GuiOverlay.GUI_MOUNT.width, GuiOverlay.GUI_MOUNT.height);
        barHeight += 6;
        boolean bl = canJump = mc.player.jumpableVehicle() != null;
        if (canJump) {
            float jumpProgress = mc.player.getJumpRidingScale();
            guiGraphics.blit(GUI_MOUNT.get(), linesPosX, linesPosY + barHeight, 0.0f, 10.0f, 91, 5, GuiOverlay.GUI_MOUNT.width, GuiOverlay.GUI_MOUNT.height);
            guiGraphics.blit(GUI_MOUNT.get(), linesPosX, linesPosY + barHeight, 0.0f, 15.0f, (int)(91.0f * jumpProgress), 5, GuiOverlay.GUI_MOUNT.width, GuiOverlay.GUI_MOUNT.height);
            barHeight += 5;
        }
        RenderUtil.renderVerticalBar(guiGraphics, GUI_MOUNT, posX, posY, 0, 20, barHeight + 1);
        RenderUtil.pop();
    }

    public static void renderBossBar(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.bossBarsEnable.getAsBoolean() || mc.options.hideGui || mc.player == null || mc.level == null) {
            return;
        }
        RenderUtil.push("boss_bar");
        int uvW = 182;
        int posX = (mc.getWindow().getGuiScaledWidth() - uvW) / 2;
        int posY = 15;
        int spacing = 19;
        ArrayList<BossEvent> nearbyBosses = new ArrayList<BossEvent>(GuiBossBar.getAll().values());
        int _posY = posY;
        for (BossEvent event : nearbyBosses) {
            RenderSystem.enableBlend();
            Component name = event.getName();
            int nameWidth = mc.font.width((FormattedText)name);
            int nameBgWidth = 3 + nameWidth + 3;
            int nameBgPosX = posX + (uvW - nameBgWidth - 8) / 2 - 1;
            int nameBgPosY = _posY + 2;
            guiGraphics.blit(GUI_EVENT.get(), nameBgPosX, nameBgPosY, 0.0f, 0.0f, 4, 6, GuiOverlay.GUI_EVENT.width, GuiOverlay.GUI_EVENT.height);
            guiGraphics.blit(GUI_EVENT.get(), nameBgPosX + 4, nameBgPosY, 8.0f, 0.0f, nameBgWidth, 6, GuiOverlay.GUI_EVENT.width, GuiOverlay.GUI_EVENT.height);
            guiGraphics.blit(GUI_EVENT.get(), nameBgPosX + 4 + nameBgWidth, nameBgPosY, 4.0f, 0.0f, 4, 6, GuiOverlay.GUI_EVENT.width, GuiOverlay.GUI_EVENT.height);
            int barPosY = _posY + 6;
            float healthRatio = event.getProgress();
            int filledWidth = (int)(healthRatio * (float)(uvW - 2));
            int barIndex = switch (event.getColor()) {
                default -> throw new MatchException(null, null);
                case BossEvent.BossBarColor.PINK -> 0;
                case BossEvent.BossBarColor.BLUE -> 1;
                case BossEvent.BossBarColor.RED -> 2;
                case BossEvent.BossBarColor.GREEN -> 3;
                case BossEvent.BossBarColor.YELLOW -> 4;
                case BossEvent.BossBarColor.PURPLE -> 5;
                case BossEvent.BossBarColor.WHITE -> 6;
            };
            guiGraphics.blit(GUI_EVENT.get(), posX, barPosY, 0.0f, 6.0f, uvW, 5, GuiOverlay.GUI_EVENT.width, GuiOverlay.GUI_EVENT.height);
            guiGraphics.blit(GUI_EVENT.get(), posX + 1, barPosY, 1.0f, (float)(11 + barIndex * 5), filledWidth, 5, GuiOverlay.GUI_EVENT.width, GuiOverlay.GUI_EVENT.height);
            int notchesIndex = switch (event.getOverlay().getName()) {
                case "progress" -> 1;
                case "notched_6" -> 0;
                case "notched_10" -> 1;
                case "notched_12" -> 2;
                case "notched_20" -> 3;
                default -> 0;
            };
            guiGraphics.blit(GUI_EVENT.get(), posX, barPosY, 0.0f, (float)(46 + notchesIndex * 5), uvW, 5, GuiOverlay.GUI_EVENT.width, GuiOverlay.GUI_EVENT.height);
            TextUtil.drawOutlinedString(guiGraphics, posX + (uvW - nameWidth) / 2, _posY, name.getString(), ColorUtil.hexToDecimal("#ffffff"), ColorUtil.hexToDecimal("#000000"));
            RenderSystem.disableBlend();
            _posY += spacing;
        }
        RenderUtil.pop();
    }

    public static void renderItemName(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.itemNameEnable.getAsBoolean() || mc.options.hideGui || mc.player == null || mc.gameMode == null || mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        RenderUtil.push("item_name");
        RenderUtil.renderHeldItemName(guiGraphics, guiGraphics.guiWidth() / 2, guiGraphics.guiHeight() - 67);
        RenderUtil.pop();
    }

    public static void renderEquippedItems(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.equippedItemsEnable.getAsBoolean() || mc.options.hideGui || mc.player == null || mc.gameMode == null || mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        RenderUtil.push("item_name");
        LinkedHashSet<EquipmentSlot> equipmentSlots = new LinkedHashSet<EquipmentSlot>();
        equipmentSlots.add(EquipmentSlot.HEAD);
        equipmentSlots.add(EquipmentSlot.CHEST);
        equipmentSlots.add(EquipmentSlot.LEGS);
        equipmentSlots.add(EquipmentSlot.FEET);
        equipmentSlots.add(EquipmentSlot.MAINHAND);
        equipmentSlots.add(EquipmentSlot.OFFHAND);
        GuiItems.addItems(equipmentSlots);
        GuiItems.renderItems(guiGraphics);
        RenderUtil.pop();
    }

    public static void renderEffects(GuiGraphics guiGraphics) {
        EffectRenderingInventoryScreen effectrenderinginventoryscreen;
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.effectsEnable.getAsBoolean() || mc.options.hideGui || mc.player == null || mc.level == null || !GameUtil.shouldDrawSurvivalHUD()) {
            return;
        }
        Collection effects = mc.player.getActiveEffects();
        if (effects.isEmpty()) {
            return;
        }
        Screen screen = mc.screen;
        if (screen instanceof EffectRenderingInventoryScreen && (effectrenderinginventoryscreen = (EffectRenderingInventoryScreen)screen).canSeeEffects()) {
            return;
        }
        RenderUtil.push("effects");
        int baseW = 27;
        int baseH = 17;
        int effectSpacing = 3;
        int rowSpacing = 10;
        int count = 0;
        MobEffectTextureManager mobeffecttexturemanager = mc.getMobEffectTextures();
        RenderSystem.enableBlend();
        for (MobEffectInstance effectInstance : Ordering.natural().reverse().sortedCopy((Iterable)effects)) {
            if (!IClientMobEffectExtensions.of((MobEffectInstance)effectInstance).isVisibleInGui(effectInstance) || !effectInstance.showIcon()) {
                return;
            }
            MobEffect effect = (MobEffect)effectInstance.getEffect().value();
            int effectDuration = effectInstance.getDuration();
            int posX = mc.getWindow().getGuiScaledWidth() - (15 + baseW + (baseW + effectSpacing) * (count % 4));
            int posY = mc.getWindow().getGuiScaledHeight() - 15 - baseH - (baseH + rowSpacing) * (count / 4);
            int effectBackgroundTextureOffset = 0;
            if (effectInstance.isAmbient()) {
                effectBackgroundTextureOffset = 2;
            } else if (!effect.isBeneficial()) {
                effectBackgroundTextureOffset = 1;
            }
            guiGraphics.blit(GUI_EFFECTS.get(), posX, posY, 0.0f, (float)(baseH * effectBackgroundTextureOffset), baseW, baseH, GuiOverlay.GUI_EFFECTS.width, GuiOverlay.GUI_EFFECTS.height);
            float fade = 1.0f;
            if (!effectInstance.isInfiniteDuration() && !effectInstance.isAmbient() && effectInstance.endsWithin(200)) {
                fade = RenderUtil.blinkEffect(effectDuration, (float)effectDuration / 200.0f, 4.0f, 10.0f, 0.25f, 1.0f);
            }
            TextureAtlasSprite textureatlassprite = mobeffecttexturemanager.get(effectInstance.getEffect());
            guiGraphics.blit(posX + 5, posY - 6, 0, 18, 18, textureatlassprite, 1.0f, 1.0f, 1.0f, fade);
            int strength = effectInstance.getAmplifier();
            if (strength > 0 && strength < 10) {
                guiGraphics.blit(GUI_NUMBERS_ROMAN.get(), posX + 16, posY - 1, 12.0f, (float)(6 + 6 * (strength - 1)), 12, 6, GuiOverlay.GUI_NUMBERS_ROMAN.width, GuiOverlay.GUI_NUMBERS_ROMAN.height);
            }
            String effectDurationTime = MobEffectUtil.formatDuration((MobEffectInstance)effectInstance, (float)1.0f, (float)mc.level.tickRateManager().tickrate()).getString();
            String effectDurationOutput = effectDuration < 71980 ? effectDurationTime : "-:-";
            int effectDurationPosX = effectInstance.isInfiniteDuration() || effectDuration >= 71980 ? 15 : 14;
            TextUtil.drawOutlinedString(guiGraphics, posX - mc.font.width(effectDurationOutput) / 2 + effectDurationPosX, posY + 11, effectDurationOutput, effect.getColor(), 0);
            ++count;
        }
        RenderUtil.pop();
    }

    public static void renderClock(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.clockEnable.getAsBoolean() || mc.options.hideGui) {
            return;
        }
        Collection<IClockLineProvider> clockLines = ClockApi.getClockLines();
        if (clockLines.isEmpty()) {
            return;
        }
        RenderUtil.push("clock");
        int posX = mc.getWindow().getGuiScaledWidth() - 20;
        int posY = 20;
        int rowHeight = 8;
        int rowSpacing = 4;
        int index = 0;
        for (IClockLineProvider clockLineProvider : clockLines) {
            IClockLine clockLine = clockLineProvider.build();
            if (clockLine == null) continue;
            clockLine.render(guiGraphics, posX - 10, posY + (rowHeight + rowSpacing) * index);
            ++index;
        }
        int elementHeight = rowHeight * index + rowSpacing * (index - 1);
        guiGraphics.blit(GUI_CLOCK.get(), posX - 6, posY - 4, 0.0f, 0.0f, 6, 3, GuiOverlay.GUI_CLOCK.width, GuiOverlay.GUI_CLOCK.height);
        guiGraphics.blit(GUI_CLOCK.get(), posX - 6, posY - 1, 6, elementHeight + 1, 0.0f, 3.0f, 6, 3, GuiOverlay.GUI_CLOCK.width, GuiOverlay.GUI_CLOCK.height);
        guiGraphics.blit(GUI_CLOCK.get(), posX - 6, posY + elementHeight, 0.0f, 6.0f, 6, 3, GuiOverlay.GUI_CLOCK.width, GuiOverlay.GUI_CLOCK.height);
        RenderUtil.pop();
    }
}

