/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.client;

import com.deadzoke.ignitehud.api.widget.WidgetAttribute;
import com.deadzoke.ignitehud.config.Config;
import com.deadzoke.ignitehud.util.ColorUtil;
import com.deadzoke.ignitehud.util.RenderUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class GuiPlayerAttributes {
    private static final ResourceLocation FOOD_ICON = RenderUtil.getIconTexture("food");
    private static final ResourceLocation FOOD_HUNGER_ICON = RenderUtil.getIconTexture("food_hunger");
    private static final ResourceLocation SATURATION_ICON = RenderUtil.getIconTexture("saturation");
    private static final ResourceLocation SATURATION_HUNGER_ICON = RenderUtil.getIconTexture("saturation_hunger");
    private static final ResourceLocation ARMOR_ICON = RenderUtil.getIconTexture("armor");
    private static final ResourceLocation ARMOR_TOUGHNESS_ICON = RenderUtil.getIconTexture("armor_toughness");
    private static final Map<String, WidgetAttribute> ATTRIBUTES = new LinkedHashMap<String, WidgetAttribute>();

    public static void init() {
        Minecraft mc = Minecraft.getInstance();
        GuiPlayerAttributes.register(new WidgetAttribute.Builder("food").withIcon(() -> {
            if (mc.player.hasEffect(MobEffects.HUNGER)) {
                return FOOD_HUNGER_ICON;
            }
            return FOOD_ICON;
        }).withValue(() -> String.valueOf(mc.player.getFoodData().getFoodLevel())).withColor(() -> {
            if (mc.player.hasEffect(MobEffects.HUNGER)) {
                return ColorUtil.hexToDecimal("#d2e3b5");
            }
            return ColorUtil.hexToDecimal("#e5c4ac");
        }).withFade(() -> {
            float foodLevel = mc.player.getFoodData().getFoodLevel();
            float fade = 1.0f;
            if (foodLevel <= 3.0f) {
                fade = (Mth.cos((float)((float)mc.gui.getGuiTicks() / Math.max(foodLevel, 0.8f))) + 1.4f) / 2.0f;
            }
            return Float.valueOf(fade);
        }).withVisibility(() -> Config.CONFIG.playerAttributeFoodEnable.getAsBoolean()).build());
        GuiPlayerAttributes.register(new WidgetAttribute.Builder("saturation").withIcon(() -> {
            if (mc.player.hasEffect(MobEffects.HUNGER)) {
                return SATURATION_HUNGER_ICON;
            }
            return SATURATION_ICON;
        }).withValue(() -> String.valueOf((int)mc.player.getFoodData().getSaturationLevel())).withColor(() -> {
            if (mc.player.hasEffect(MobEffects.HUNGER)) {
                return ColorUtil.hexToDecimal("#e5e699");
            }
            return ColorUtil.hexToDecimal("#f0d556");
        }).withVisibility(() -> Config.CONFIG.playerAttributeSaturationEnable.getAsBoolean()).build());
        GuiPlayerAttributes.register(new WidgetAttribute.Builder("armor").withIcon(ARMOR_ICON).withValue(() -> String.valueOf(mc.player.getArmorValue())).withColor(ColorUtil.hexToDecimal("#d1d3e3")).withVisibility(() -> {
            int armorLevel = mc.player.getArmorValue();
            return Config.CONFIG.playerAttributeArmorEnable.getAsBoolean() && armorLevel > 0;
        }).build());
        GuiPlayerAttributes.register(new WidgetAttribute.Builder("armor_toughness").withIcon(ARMOR_TOUGHNESS_ICON).withValue(() -> String.valueOf((int)mc.player.getAttributeValue(Attributes.ARMOR_TOUGHNESS))).withColor(ColorUtil.hexToDecimal("#9ff8e5")).withVisibility(() -> {
            int toughnessLevel = (int)mc.player.getAttributeValue(Attributes.ARMOR_TOUGHNESS);
            return Config.CONFIG.playerAttributeToughnessEnable.getAsBoolean() && toughnessLevel > 0;
        }).build());
    }

    public static void register(WidgetAttribute attribute) {
        ATTRIBUTES.put(attribute.getId(), attribute);
    }

    public static void register(int position, WidgetAttribute attribute) {
        ArrayList<Map.Entry<String, WidgetAttribute>> entries = new ArrayList<Map.Entry<String, WidgetAttribute>>(ATTRIBUTES.entrySet());
        entries.add(position, new AbstractMap.SimpleEntry<String, WidgetAttribute>(attribute.getId(), attribute));
        ATTRIBUTES.clear();
        for (Map.Entry entry : entries) {
            ATTRIBUTES.put((String)entry.getKey(), (WidgetAttribute)entry.getValue());
        }
    }

    public static List<WidgetAttribute> getAttributes() {
        return new ArrayList<WidgetAttribute>(ATTRIBUTES.values());
    }

    public static WidgetAttribute getAttribute(String id) {
        return ATTRIBUTES.get(id);
    }
}

