/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.client;

import com.deadzoke.ignitehud.api.widget.WidgetApi;
import com.deadzoke.ignitehud.api.widget.WidgetBar;
import com.deadzoke.ignitehud.api.widget.WidgetBarExtension;
import com.deadzoke.ignitehud.config.Config;
import com.deadzoke.ignitehud.util.GameUtil;
import com.deadzoke.ignitehud.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;

public class GuiPlayerBars {
    private static final ResourceLocation HEALTH_TEXTURE = RenderUtil.getBarTexture("health");
    private static final ResourceLocation ABSORPTION_TEXTURE = RenderUtil.getBarTexture("health_absorption");
    private static final ResourceLocation WITHER_TEXTURE = RenderUtil.getBarTexture("health_wither");
    private static final ResourceLocation FROZEN_TEXTURE = RenderUtil.getBarTexture("health_frozen");
    private static final ResourceLocation POISON_TEXTURE = RenderUtil.getBarTexture("health_poison");
    public static final WidgetBar HEALTH_BAR = new WidgetBar(HEALTH_TEXTURE);
    public static final WidgetBarExtension ABSORPTION_EXTENSION = new WidgetBarExtension("absorption", ABSORPTION_TEXTURE);

    public static void init() {
        HEALTH_BAR.addExtension(ABSORPTION_EXTENSION);
        WidgetApi.addBar("health", GuiPlayerBars::addHealth);
    }

    private static WidgetBar addHealth() {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.playerBarHealthEnable.getAsBoolean() || mc.player == null) {
            return null;
        }
        float health = mc.player.getHealth();
        HEALTH_BAR.setValue(health);
        float maxHealth = mc.player.getMaxHealth();
        HEALTH_BAR.setMaxValue(maxHealth);
        if (mc.player.hasEffect(MobEffects.WITHER)) {
            HEALTH_BAR.setTexture(WITHER_TEXTURE);
        } else if (mc.player.isFullyFrozen()) {
            HEALTH_BAR.setTexture(FROZEN_TEXTURE);
        } else if (mc.player.hasEffect(MobEffects.POISON)) {
            HEALTH_BAR.setTexture(POISON_TEXTURE);
        } else {
            HEALTH_BAR.setTexture(HEALTH_TEXTURE);
        }
        float fade = 1.0f;
        if (health / maxHealth <= 0.2f) {
            fade = (Mth.cos((float)((float)mc.gui.getGuiTicks() / 3.0f)) + 1.4f) / 2.0f;
        }
        HEALTH_BAR.setFade(fade);
        HEALTH_BAR.setHasBlink(GameUtil.isHealing(health));
        HEALTH_BAR.setHasGlint(mc.player.hasEffect(MobEffects.REGENERATION));
        ABSORPTION_EXTENSION.setValue(mc.player.getAbsorptionAmount());
        return HEALTH_BAR;
    }
}

