/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.integrations;

import com.deadzoke.ignitehud.api.overlay.OverlayApi;
import com.deadzoke.ignitehud.api.widget.WidgetApi;
import com.deadzoke.ignitehud.api.widget.WidgetBar;
import com.deadzoke.ignitehud.config.Config;
import com.deadzoke.ignitehud.util.RenderUtil;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;

public class IronsSpellbooksIntegration {
    private static final ResourceLocation MANA_BAR_TEXTURE = RenderUtil.getBarTexture("mana");
    public static final WidgetBar MANA_BAR = new WidgetBar(MANA_BAR_TEXTURE);

    public static void init() {
        OverlayApi.addOverlaysToOverride(new String[]{"irons_spellbooks:mana_overlay"});
        WidgetApi.addBar("mana", IronsSpellbooksIntegration::addManaBar);
    }

    private static WidgetBar addManaBar() {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.clockManaBarEnable.getAsBoolean() || mc.player == null) {
            return null;
        }
        float value = ClientMagicData.getPlayerMana();
        MANA_BAR.setValue(value);
        float maxValue = (float)mc.player.getAttributeValue((Holder)AttributeRegistry.MAX_MANA);
        MANA_BAR.setMaxValue(maxValue);
        return MANA_BAR;
    }
}

