/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.integrations;

import com.deadzoke.ignitehud.api.overlay.OverlayApi;
import com.deadzoke.ignitehud.api.widget.WidgetApi;
import com.deadzoke.ignitehud.api.widget.WidgetAttribute;
import com.deadzoke.ignitehud.util.ColorUtil;
import com.deadzoke.ignitehud.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureEnum;
import sfiomn.legendarysurvivaloverhaul.api.thirst.ThirstUtil;
import sfiomn.legendarysurvivaloverhaul.common.attachments.temperature.TemperatureAttachment;
import sfiomn.legendarysurvivaloverhaul.common.attachments.thirst.ThirstAttachment;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;

public class LegendarySurvivalOverhaulIntegration {
    private static final ResourceLocation FOOD_FROZEN_ICON = RenderUtil.getIconTexture("food_frozen");
    private static final ResourceLocation FOOD_FROZEN_HUNGER_ICON = RenderUtil.getIconTexture("food_frozen_hunger");
    private static final ResourceLocation THIRST_ICON = RenderUtil.getIconTexture("thirst");
    private static final ResourceLocation THIRST_THIRSTY_ICON = RenderUtil.getIconTexture("thirst_thirsty");
    private static final ResourceLocation THIRST_FIERY_ICON = RenderUtil.getIconTexture("thirst_fiery");
    private static final ResourceLocation THIRST_FIERY_THIRSTY_ICON = RenderUtil.getIconTexture("thirst_fiery_thirsty");

    public static void init() {
        OverlayApi.addOverlaysToOverride(new String[]{"legendarysurvivaloverhaul:cold_hunger", "legendarysurvivaloverhaul:thirst"});
        LegendarySurvivalOverhaulIntegration.modifyHungerAttribute();
        WidgetApi.addAttribute(LegendarySurvivalOverhaulIntegration.addThirstAttribute());
    }

    private static void modifyHungerAttribute() {
        Minecraft mc = Minecraft.getInstance();
        WidgetAttribute foodAttribute = WidgetApi.getAttribute("food");
        if (foodAttribute == null) {
            return;
        }
        foodAttribute.addIconProvider(() -> {
            if (mc.player != null && mc.player.hasEffect((Holder)MobEffectRegistry.COLD_HUNGER)) {
                if (mc.player.hasEffect(MobEffects.HUNGER)) {
                    return FOOD_FROZEN_HUNGER_ICON;
                }
                return FOOD_FROZEN_ICON;
            }
            return null;
        });
        foodAttribute.addColorProvider(() -> {
            if (mc.player != null && mc.player.hasEffect((Holder)MobEffectRegistry.COLD_HUNGER)) {
                return ColorUtil.hexToDecimal("#a3cfff");
            }
            return null;
        });
    }

    private static WidgetAttribute addThirstAttribute() {
        Minecraft mc = Minecraft.getInstance();
        return new WidgetAttribute.Builder("legendarysurvivaloverhaul:thirst").withColor(() -> {
            if (mc.player == null) {
                return null;
            }
            boolean isThirsty = mc.player.hasEffect((Holder)MobEffectRegistry.THIRST);
            TemperatureAttachment temperatureAttachment = AttachmentUtil.getTempAttachment((Player)mc.player);
            if (temperatureAttachment.getTemperatureEnum() == TemperatureEnum.HEAT_STROKE) {
                if (isThirsty) {
                    return ColorUtil.hexToDecimal("#a3ff3f");
                }
                return ColorUtil.hexToDecimal("#ffaa3f");
            }
            if (isThirsty) {
                return ColorUtil.hexToDecimal("#a1fe4d");
            }
            return ColorUtil.hexToDecimal("#68efff");
        }).withIcon(() -> {
            if (mc.player == null) {
                return null;
            }
            boolean isThirsty = mc.player.hasEffect((Holder)MobEffectRegistry.THIRST);
            TemperatureAttachment temperatureAttachment = AttachmentUtil.getTempAttachment((Player)mc.player);
            if (temperatureAttachment.getTemperatureEnum() == TemperatureEnum.HEAT_STROKE) {
                if (isThirsty) {
                    return THIRST_FIERY_THIRSTY_ICON;
                }
                return THIRST_FIERY_ICON;
            }
            if (isThirsty) {
                return THIRST_THIRSTY_ICON;
            }
            return THIRST_ICON;
        }).withValue(() -> {
            if (mc.player == null) {
                return null;
            }
            ThirstAttachment thirstAttachment = AttachmentUtil.getThirstAttachment((Player)mc.player);
            return String.valueOf(thirstAttachment.getHydrationLevel());
        }).withVisibility(() -> Config.Baked.thirstEnabled && Config.Baked.showHydrationBar && mc.player != null && ThirstUtil.isThirstActive((Player)mc.player)).build();
    }
}

