/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.integrations;

import com.deadzoke.ignitehud.api.clock.ClockApi;
import com.deadzoke.ignitehud.api.clock.IClockLine;
import com.deadzoke.ignitehud.config.Config;
import com.deadzoke.ignitehud.util.ColorUtil;
import com.deadzoke.ignitehud.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class SereneSeasonsIntegration {
    private static final ResourceLocation SPRING_ICON = RenderUtil.getIconTexture("season_spring");
    private static final ResourceLocation SUMMER_ICON = RenderUtil.getIconTexture("season_summer");
    private static final ResourceLocation AUTUMN_ICON = RenderUtil.getIconTexture("season_autumn");
    private static final ResourceLocation WINTER_ICON = RenderUtil.getIconTexture("season_winter");

    public static void init() {
        ClockApi.addClockLine("sereneseasons:season", SereneSeasonsIntegration::addSeason);
    }

    public static IClockLine addSeason() {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.clockSeasonEnable.getAsBoolean() || mc.level == null) {
            return null;
        }
        return (guiGraphics, posX, posY) -> {
            ISeasonState seasonState = SeasonHelper.getSeasonState((Level)mc.level);
            Season.SubSeason subSeason = seasonState.getSubSeason();
            String seasonName = Component.translatable((String)("desc.sereneseasons." + subSeason.getSerializedName())).getString();
            int seasonNameWidth = mc.font.width(seasonName);
            guiGraphics.drawString(mc.font, seasonName, posX - seasonNameWidth, posY, ColorUtil.hexToDecimal("#FFFFFF"));
            Season season = seasonState.getSeason();
            ResourceLocation icon = null;
            switch (season) {
                case SPRING: {
                    icon = SPRING_ICON;
                    break;
                }
                case SUMMER: {
                    icon = SUMMER_ICON;
                    break;
                }
                case AUTUMN: {
                    icon = AUTUMN_ICON;
                    break;
                }
                case WINTER: {
                    icon = WINTER_ICON;
                }
            }
            if (icon != null) {
                RenderUtil.renderIcon(guiGraphics, icon, posX - seasonNameWidth - 2 - 10, posY - 1);
            }
        };
    }
}

