/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.client.gui;

import cy.jdkdigital.trophymanager.TrophyManagerConfig;
import cy.jdkdigital.trophymanager.common.blockentity.TrophyBlockEntity;
import cy.jdkdigital.trophymanager.compat.CobblemonCompat;
import cy.jdkdigital.trophymanager.network.PacketUpdateTrophy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;

public class TrophyScreen
extends Screen {
    private static final int WIDTH = 150;
    private static final int HEIGHT = 150;
    private static final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"trophymanager", (String)"textures/gui/trophy.png");
    private final TrophyBlockEntity trophy;

    protected TrophyScreen(BlockPos pos) {
        super((Component)Component.translatable((String)"gui.trophy.screen"));
        ClientLevel level = Minecraft.getInstance().level;
        this.trophy = (TrophyBlockEntity)level.getBlockEntity(pos);
    }

    protected void init() {
        int relX = (this.width - 150) / 2;
        int relY = (this.height - 150) / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"-"), button -> this.adjustScale(-1.0f)).pos(relX + 10, relY + 10).size(20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"+"), button -> this.adjustScale(1.0f)).pos(relX + 120, relY + 10).size(20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"-"), button -> this.adjustOffsetY(-1.0)).pos(relX + 10, relY + 35).size(20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"+"), button -> this.adjustOffsetY(1.0)).pos(relX + 120, relY + 35).size(20, 20).build());
        if (ModList.get().isLoaded("cobblemon") && CobblemonCompat.isPokemonTrophy(this.trophy)) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), button -> CobblemonCompat.changePose(this.trophy, -1)).pos(relX + 10, relY + 60).size(20, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), button -> CobblemonCompat.changePose(this.trophy, 1)).pos(relX + 120, relY + 60).size(20, 20).build());
            relY += 25;
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), button -> TrophyScreen.close()).pos(relX + 10, relY + 60).size(65, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.apply"), button -> TrophyScreen.save(this)).pos(relX + 76, relY + 60).size(65, 20).build());
    }

    protected void renderMenuBackground(GuiGraphics guiGraphics) {
        int relX = (this.width - 150) / 2;
        int relY = (this.height - 150) / 2;
        guiGraphics.blit(GUI, relX, relY, 0, 0, 150, 150);
        guiGraphics.drawCenteredString(this.font, "" + this.trophy.scale, relX + 75, relY + 15, 0xE0E0E0);
        guiGraphics.drawCenteredString(this.font, "" + this.trophy.offsetY, relX + 75, relY + 40, 0xE0E0E0);
        if (ModList.get().isLoaded("cobblemon") && CobblemonCompat.isPokemonTrophy(this.trophy)) {
            guiGraphics.drawCenteredString(this.font, CobblemonCompat.getPose(this.trophy), relX + 75, relY + 65, 0xE0E0E0);
        }
        super.renderMenuBackground(guiGraphics);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void adjustScale(float d) {
        if (Screen.hasShiftDown()) {
            d *= 10.0f;
        }
        this.trophy.scale = (float)Math.round(this.trophy.scale * 10.0f + d) / 10.0f;
        if ((double)this.trophy.scale > (Double)TrophyManagerConfig.GENERAL.maxSize.get()) {
            this.trophy.scale = ((Double)TrophyManagerConfig.GENERAL.maxSize.get()).floatValue();
        }
        if ((double)this.trophy.scale < (Double)TrophyManagerConfig.GENERAL.maxSize.get() * -1.0) {
            this.trophy.scale = ((Double)TrophyManagerConfig.GENERAL.maxSize.get()).floatValue() * -1.0f;
        }
    }

    private void adjustOffsetY(double d) {
        if (Screen.hasShiftDown()) {
            d *= 10.0;
        }
        this.trophy.offsetY = (double)Math.round(this.trophy.offsetY * 10.0 + d) / 10.0;
        if (this.trophy.offsetY > (Double)TrophyManagerConfig.GENERAL.maxYOffset.get()) {
            this.trophy.offsetY = (Double)TrophyManagerConfig.GENERAL.maxYOffset.get();
        }
        if (this.trophy.offsetY < (Double)TrophyManagerConfig.GENERAL.maxYOffset.get() * -1.0) {
            this.trophy.offsetY = (Double)TrophyManagerConfig.GENERAL.maxYOffset.get() * -1.0;
        }
    }

    public static void open(BlockPos pos) {
        Minecraft.getInstance().setScreen((Screen)new TrophyScreen(pos));
    }

    public static void save(TrophyScreen screen) {
        CompoundTag tag = new CompoundTag();
        tag.putDouble("OffsetY", screen.trophy.offsetY);
        tag.putFloat("Scale", screen.trophy.scale);
        if (ModList.get().isLoaded("cobblemon") && CobblemonCompat.isPokemonTrophy(screen.trophy)) {
            tag.putString("PoseType", screen.trophy.entity.getString("PoseType"));
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new PacketUpdateTrophy(screen.trophy.getBlockPos(), tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        TrophyScreen.close();
    }

    public static void close() {
        Minecraft.getInstance().setScreen(null);
    }
}

