/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import cy.jdkdigital.trophymanager.TrophyManagerConfig;
import cy.jdkdigital.trophymanager.common.blockentity.TrophyBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class TrophyBlockEntityRenderer
implements BlockEntityRenderer<TrophyBlockEntity> {
    private PlayerInfo playerInfo;
    PlayerModel<Player> playerModelRegular;
    PlayerModel<Player> playerModelSlim;

    public TrophyBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.playerModelRegular = new PlayerModel(context.bakeLayer(ModelLayers.PLAYER), false);
        this.playerModelSlim = new PlayerModel(context.bakeLayer(ModelLayers.PLAYER_SLIM), true);
    }

    public void render(@Nonnull TrophyBlockEntity trophyTileEntity, float v, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (trophyTileEntity.trophyType != null && Minecraft.getInstance().level != null) {
            Entity entity;
            trophyTileEntity.setLevel((Level)Minecraft.getInstance().level);
            if (trophyTileEntity.isOnHead) {
                poseStack.translate(0.0f, 0.4f, 0.0f);
            }
            if (trophyTileEntity.trophyType.equals("item") && trophyTileEntity.item != null) {
                this.renderItem(trophyTileEntity, poseStack, buffer, combinedLightIn, combinedOverlayIn);
            } else if (trophyTileEntity.trophyType.equals("entity") && (entity = trophyTileEntity.getCachedEntity()) != null) {
                this.renderEntity(trophyTileEntity, poseStack, buffer, combinedLightIn);
            }
        }
        this.renderBase(trophyTileEntity, poseStack, buffer, combinedLightIn, combinedOverlayIn);
    }

    private void renderBase(TrophyBlockEntity trophyTileEntity, PoseStack poseStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Block baseBlock;
        Block block = baseBlock = trophyTileEntity.isOnHead ? Blocks.AIR : trophyTileEntity.getBaseBlock();
        if (baseBlock != null) {
            Minecraft.getInstance().getBlockRenderer().renderSingleBlock(baseBlock.defaultBlockState(), poseStack, buffer, combinedLightIn, combinedOverlayIn);
        }
    }

    private void renderItem(TrophyBlockEntity trophyBlockEntity, PoseStack poseStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        double tick = 0.0;
        if (((Boolean)TrophyManagerConfig.GENERAL.rotateItemTrophies.get()).booleanValue() && !(trophyBlockEntity.item.getItem() instanceof BlockItem)) {
            tick = (double)System.currentTimeMillis() / 800.0;
        } else if (trophyBlockEntity.getLevel() != null) {
            Direction facing = (Direction)trophyBlockEntity.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
            if (facing == Direction.NORTH) {
                tick = 6.0;
            } else if (facing == Direction.SOUTH) {
                tick = 0.0;
            } else if (facing == Direction.EAST) {
                tick = 3.0;
            } else if (facing == Direction.WEST) {
                tick = 9.0;
            }
        }
        poseStack.pushPose();
        poseStack.translate(0.5, trophyBlockEntity.offsetY + 0.5 + Math.sin(tick / 25.0) / 15.0, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees((float)(tick * 30.0 % 360.0)));
        poseStack.scale(trophyBlockEntity.scale, trophyBlockEntity.scale, trophyBlockEntity.scale);
        if (trophyBlockEntity.item.getItem() instanceof BlockItem) {
            poseStack.translate(0.0f, -0.25f, 0.0f);
            poseStack.scale(3.0f, 3.0f, 3.0f);
        }
        Minecraft.getInstance().getItemRenderer().renderStatic(trophyBlockEntity.item, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, poseStack, buffer, trophyBlockEntity.getLevel(), 0);
        poseStack.popPose();
    }

    private void renderEntity(TrophyBlockEntity trophyTileEntity, PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLightIn) {
        float angle = 0.0f;
        if (trophyTileEntity.getLevel() != null) {
            Direction facing = (Direction)trophyTileEntity.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
            if (facing == Direction.NORTH) {
                angle = 180.0f;
            } else if (facing == Direction.SOUTH) {
                angle = 0.0f;
            } else if (facing == Direction.EAST) {
                angle = 90.0f;
            } else if (facing == Direction.WEST) {
                angle = 270.0f;
            }
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5, trophyTileEntity.offsetY, 0.5);
        matrixStack.mulPose(Axis.YP.rotationDegrees(angle));
        matrixStack.mulPose(Axis.XP.rotationDegrees(trophyTileEntity.rotX));
        matrixStack.scale(trophyTileEntity.scale, trophyTileEntity.scale, trophyTileEntity.scale);
        if (trophyTileEntity.entity.getString("entityType").equals("minecraft:ender_dragon")) {
            matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
        EntityRenderDispatcher entityRendererManager = Minecraft.getInstance().getEntityRenderDispatcher();
        entityRendererManager.setRenderShadow(false);
        Entity cachedEntity = trophyTileEntity.getCachedEntity();
        if (cachedEntity != null) {
            entityRendererManager.render(cachedEntity, 0.0, 0.0, 0.0, 1.0f, 1.0f, matrixStack, buffer, combinedLightIn);
            TrophyBlockEntityRenderer.renderPassengers(cachedEntity, entityRendererManager, matrixStack, buffer, combinedLightIn);
        }
        matrixStack.popPose();
    }

    private static void renderPassengers(Entity entity, EntityRenderDispatcher entityRendererManager, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn) {
        if (entity.isVehicle()) {
            for (Entity rider : entity.getPassengers()) {
                entity.positionRider(rider);
                entityRendererManager.render(rider, rider.getX(), rider.getY(), rider.getZ(), (float)Minecraft.getInstance().getFrameTimeNs(), 1.0f, matrixStack, buffer, combinedLightIn);
                TrophyBlockEntityRenderer.renderPassengers(rider, entityRendererManager, matrixStack, buffer, combinedLightIn);
            }
        }
    }

    public boolean shouldRenderOffScreen(TrophyBlockEntity pBlockEntity) {
        return true;
    }

    public int getViewDistance() {
        return 256;
    }

    public AABB getRenderBoundingBox(TrophyBlockEntity blockEntity) {
        return AABB.INFINITE;
    }
}

