/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.common.item;

import cy.jdkdigital.trophymanager.client.render.item.TrophyItemStackRenderer;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class TrophyItem
extends BlockItem {
    public TrophyItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Nonnull
    public Component getName(ItemStack stack) {
        if (stack.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).getUnsafe();
            return Component.translatable((String)tag.getString("Name"));
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        if (pStack.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag tag = ((CustomData)pStack.get(DataComponents.CUSTOM_DATA)).getUnsafe();
            pTooltipComponents.add((Component)Component.translatable((String)"trophymanager.tooltip.trophy.scale", (Object[])new Object[]{Float.valueOf(tag.getCompound("TrophyData").getFloat("scale"))}));
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){
            final BlockEntityWithoutLevelRenderer myRenderer = new TrophyItemStackRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.myRenderer;
            }
        });
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        return armorType == EquipmentSlot.HEAD;
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }
}

