/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.compat;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeatures;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import cy.jdkdigital.trophymanager.common.blockentity.TrophyBlockEntity;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class CobblemonCompat {
    public static Entity create(Level level, CompoundTag tag) {
        ListTag features = tag.getCompound("Pokemon").getList("Features", 10);
        Object extra = "";
        if (!features.isEmpty()) {
            for (Tag t : features) {
                CompoundTag feature = (CompoundTag)t;
                String featureName = feature.getString("cobblemon:feature_id");
                SpeciesFeature speciesFeature = SpeciesFeatures.getFeature((String)featureName).invoke(feature);
                if (!(speciesFeature instanceof FlagSpeciesFeature)) continue;
                extra = (String)extra + featureName + "=" + (feature.getBoolean(featureName) ? "true " : "false ");
            }
            extra = (String)extra + "form=" + tag.getCompound("Pokemon").getString("FormId");
        }
        PokemonProperties properties = PokemonProperties.Companion.parse("species=\"" + tag.getCompound("Pokemon").getString("Species") + "\" " + (String)extra + " level=5");
        PokemonEntity entity = properties.createEntity(level);
        entity.getEntityData().set(PokemonEntity.Companion.getPOSE_TYPE(), (Object)PoseType.valueOf((String)tag.getString("PoseType")));
        return entity;
    }

    public static void changePose(TrophyBlockEntity trophy, int i) {
        if (trophy.entity.contains("PoseType")) {
            int currentPoseIndex = CobblemonCompat.poses().indexOf(PoseType.valueOf((String)trophy.entity.getString("PoseType")));
            int nextPoseIndex = currentPoseIndex == 0 && i < 0 ? CobblemonCompat.poses().size() - 1 : (currentPoseIndex == CobblemonCompat.poses().size() - 1 ? 0 : currentPoseIndex + i);
            trophy.entity.putString("PoseType", CobblemonCompat.poses().get(nextPoseIndex).name());
        }
    }

    public static boolean isPokemonTrophy(TrophyBlockEntity trophy) {
        return trophy.trophyType.equals("entity") && trophy.entity.getString("entityType").contains("cobblemon:");
    }

    private static List<PoseType> poses() {
        return List.of(PoseType.SLEEP, PoseType.SWIM, PoseType.FLOAT, PoseType.FLY, PoseType.HOVER, PoseType.WALK, PoseType.STAND);
    }

    public static String getPose(TrophyBlockEntity trophy) {
        return trophy.entity.contains("PoseType") ? trophy.entity.getString("PoseType") : "NO POSE";
    }
}

