/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.network;

import com.mojang.serialization.Codec;
import cy.jdkdigital.trophymanager.TrophyManagerConfig;
import cy.jdkdigital.trophymanager.common.blockentity.TrophyBlockEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketUpdateTrophy(BlockPos pos, CompoundTag tag) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketUpdateTrophy> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"trophymanager", (String)"update_trophy"));
    public static final StreamCodec<ByteBuf, PacketUpdateTrophy> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec((Codec)BlockPos.CODEC), PacketUpdateTrophy::pos, (StreamCodec)ByteBufCodecs.fromCodec((Codec)CompoundTag.CODEC), PacketUpdateTrophy::tag, PacketUpdateTrophy::new);

    public static void clientHandle(PacketUpdateTrophy data, IPayloadContext context) {
    }

    public static void serverHandle(PacketUpdateTrophy data, IPayloadContext context) {
        BlockEntity blockEntity = context.player().level().getBlockEntity(data.pos());
        if (blockEntity instanceof TrophyBlockEntity) {
            TrophyBlockEntity trophyBlockEntity = (TrophyBlockEntity)blockEntity;
            trophyBlockEntity.offsetY = Math.min(data.tag().getDouble("OffsetY"), (Double)TrophyManagerConfig.GENERAL.maxYOffset.get());
            trophyBlockEntity.scale = (float)Math.min((double)data.tag().getFloat("Scale"), (Double)TrophyManagerConfig.GENERAL.maxSize.get());
            trophyBlockEntity.setChanged();
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

