/*
 * Decompiled with CFR 0.152.
 */
package com.pryzmm.splitself.client.lang;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public final class LangToastMessages {
    private static final Gson GSON = new Gson();
    private static final class_2960 FILE = class_2960.method_60655((String)"splitself", (String)"lang_overlay_mgs.json");
    private static Map<String, Lines> map = Collections.emptyMap();
    private static Map<String, String> aliases = Collections.emptyMap();
    private static Lines def = new Lines("Translations Available", "Split Self has support for translations");
    private static Lines fail = new Lines("Recommendation", "We encourage you to play Split Self on your native language");
    private static boolean loaded = false;

    private LangToastMessages() {
    }

    private static String norm(String s) {
        return s.toLowerCase(Locale.ROOT).replace('-', '_');
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static synchronized void reload(class_3300 rm) {
        loaded = false;
        map = new HashMap<String, Lines>();
        aliases = new HashMap<String, String>();
        try {
            Optional res = rm.method_14486(FILE);
            if (res.isEmpty()) {
                System.out.println("[LangToast] JSON not found at assets/splitself/lang_overlay_mgs.json -> using defaults");
                loaded = true;
                return;
            }
            try (InputStreamReader in = new InputStreamReader(((class_3298)res.get()).method_14482(), StandardCharsets.UTF_8);){
                JsonObject o;
                JsonObject root = (JsonObject)GSON.fromJson((Reader)in, JsonObject.class);
                if (root.has("default")) {
                    o = root.getAsJsonObject("default");
                    def = new Lines(o.get("title").getAsString(), o.get("body").getAsString());
                }
                if (root.has("fail")) {
                    o = root.getAsJsonObject("fail");
                    fail = new Lines(o.get("title").getAsString(), o.get("body").getAsString());
                }
                if (root.has("aliases")) {
                    o = root.getAsJsonObject("aliases");
                    for (Map.Entry e : o.entrySet()) {
                        aliases.put(LangToastMessages.norm((String)e.getKey()), LangToastMessages.norm(((JsonElement)e.getValue()).getAsString()));
                    }
                }
                for (Map.Entry e : root.entrySet()) {
                    String k = (String)e.getKey();
                    if ("default".equals(k) || "aliases".equals(k) || "fail".equals(k)) continue;
                    JsonObject o2 = ((JsonElement)e.getValue()).getAsJsonObject();
                    String key = LangToastMessages.norm(k);
                    map.put(key, new Lines(o2.get("title").getAsString(), o2.get("body").getAsString()));
                }
                loaded = true;
            }
        }
        catch (Exception ex) {
            System.out.println("[LangToast] reload failed: " + ex.getMessage());
            loaded = true;
        }
    }

    public static Lines failLines() {
        return fail;
    }

    public static Lines resolve(@Nullable Locale os, String suggestedCode) {
        String base;
        String code = LangToastMessages.norm(suggestedCode);
        Lines out = map.get(code);
        if (out != null) {
            return out;
        }
        String ali = aliases.get(code);
        if (ali != null && (out = map.get(ali)) != null) {
            return out;
        }
        int i = code.indexOf(95);
        if (i > 0 && (out = map.get(base = code.substring(0, i))) != null) {
            return out;
        }
        if (os != null) {
            String baseOs;
            String osTag = LangToastMessages.norm(os.toLanguageTag());
            out = map.get(osTag);
            if (out != null) {
                return out;
            }
            int j = osTag.indexOf(95);
            if (j > 0 && (out = map.get(baseOs = osTag.substring(0, j))) != null) {
                return out;
            }
        }
        return def;
    }

    private static Lines lineOrDefault(String code) {
        if (code == null || code.isBlank()) {
            return def;
        }
        String c = LangToastMessages.norm(code);
        Lines l = map.get(c);
        if (l != null) {
            return l;
        }
        String ali = aliases.get(c);
        if (ali != null && (l = map.get(ali)) != null) {
            return l;
        }
        int i = c.indexOf(95);
        if (i > 0) {
            String base = c.substring(0, i);
            l = map.get(base);
            if (l != null) {
                return l;
            }
            for (Map.Entry<String, Lines> e : map.entrySet()) {
                if (!e.getKey().startsWith(base + "_")) continue;
                return e.getValue();
            }
        }
        return def;
    }

    public record Lines(String title, String body) {
        class_2561 titleText() {
            return class_2561.method_43470((String)this.title);
        }

        class_2561 bodyText(String prettyLang) {
            return class_2561.method_43470((String)this.body.replace("{language}", prettyLang));
        }
    }
}

