/*
 * Decompiled with CFR 0.152.
 */
package com.pryzmm.splitself.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.pryzmm.splitself.SplitSelf;
import com.pryzmm.splitself.events.EventManager;
import com.pryzmm.splitself.screen.WarningScreen;
import com.pryzmm.splitself.world.DataTracker;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class SplitSelfCommands {
    private static final SuggestionProvider<class_2168> MAIN_SUGGESTIONS = (context, builder) -> {
        String[] suggestions;
        for (String suggestion : suggestions = new String[]{"information", "debugFullscreen", "debugToggleEvents", "debugSleepStage", "runEvent"}) {
            if (!suggestion.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
            builder.suggest(suggestion);
        }
        return builder.buildFuture();
    };
    private static final SuggestionProvider<class_2168> EVENT_SUGGESTIONS = (context, builder) -> {
        if ("random".startsWith(builder.getRemaining().toLowerCase())) {
            builder.suggest("random");
        }
        for (EventManager.Events event : EventManager.Events.values()) {
            String eventName = event.name().toLowerCase();
            if (!eventName.startsWith(builder.getRemaining().toLowerCase())) continue;
            builder.suggest(eventName);
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        class_310 client = class_310.method_1551();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"splitself").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("<" + ((class_2168)context.getSource()).method_9214() + "> " + SplitSelf.translate("command.splitself.empty_command", new Object[0]).getString())), false);
            return 1;
        })).then(class_2170.method_9247((String)"information").executes(context -> {
            client.execute(() -> client.method_1507((class_437)new WarningScreen()));
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debugFullscreen").requires(source -> source.method_9259(2))).executes(context -> {
            if (((Boolean)client.field_1690.method_42447().method_41753()).booleanValue()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"In fullscreen"), false);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"NOT in fullscreen"), false);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debugToggleEvents").requires(source -> source.method_9259(2))).executes(context -> {
            DataTracker tracker = DataTracker.getServerState((MinecraftServer)client.method_1576());
            tracker.setPlayerReadWarning(client.field_1724.method_5667(), !tracker.getPlayerReadWarning(client.field_1724.method_5667()));
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)SplitSelf.translate("command.splitself.debug_toggle_warning", tracker.getPlayerReadWarning(client.field_1724.method_5667())).getString()), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"debugSleepStage").requires(source -> source.method_9259(2))).executes(context -> {
            DataTracker tracker = DataTracker.getServerState((MinecraftServer)client.method_1576());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(tracker.getPlayerSleepStage(client.field_1724.method_5667()))), false);
            return 1;
        })).then(class_2170.method_9244((String)"stage", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int stage = IntegerArgumentType.getInteger((CommandContext)context, (String)"stage");
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            DataTracker tracker = DataTracker.getServerState(world.method_8503());
            tracker.setPlayerSleepStage(player.method_5667(), stage);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(tracker.getPlayerSleepStage(client.field_1724.method_5667()))), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"runEvent").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"event", (ArgumentType)StringArgumentType.word()).suggests(EVENT_SUGGESTIONS).executes(context -> {
            String eventArg = StringArgumentType.getString((CommandContext)context, (String)"event").toLowerCase();
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (eventArg.equalsIgnoreCase("random")) {
                EventManager.triggerRandomEvent(world, (class_1657)player, null, true);
            } else {
                try {
                    EventManager.Events event = EventManager.Events.valueOf(eventArg.toUpperCase());
                    EventManager.triggerRandomEvent(world, (class_1657)player, event, true);
                }
                catch (IllegalArgumentException e) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("<" + ((class_2168)context.getSource()).method_9214() + "> " + SplitSelf.translate("command.splitself.invalid_value", new Object[0]).getString())), false);
                }
            }
            return 1;
        }))));
    }
}

