/*
 * Decompiled with CFR 0.152.
 */
package com.pryzmm.splitself.config;

import com.pryzmm.splitself.SplitSelf;
import com.pryzmm.splitself.config.DefaultConfig;
import com.pryzmm.splitself.config.DoubleTextButtonWidget;
import com.pryzmm.splitself.config.ScrollingConfigScreen;
import com.pryzmm.splitself.config.SingleTextButtonWidget;
import com.pryzmm.splitself.events.EventManager;
import com.pryzmm.splitself.file.JsonReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7842;

public class CustomConfigScreen
extends class_437 {
    public static final class_2960 CONFIG_IMAGE = class_2960.method_60655((String)"splitself", (String)"textures/gui/title/config_title.png");
    private static JsonReader configReader;
    public static class_437 Parent;
    public static String arrayID;
    public static InputType ScrollInputType;
    public static double ScrollMinimum;
    public static double ScrollMaximum;
    class_342 textFieldWidget;
    class_7842 textFieldHeaderWidget;
    class_4185 submitButtonWidget;

    public CustomConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)""));
        Parent = parent;
        if (configReader == null) {
            configReader = new JsonReader("splitself.json5");
        }
    }

    protected void method_25426() {
        this.createDoneButton();
        this.createConfigButtons();
    }

    public void createDoneButton() {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), button -> {
            assert (this.field_22787 != null);
            CustomConfigScreen.applyConfig();
            this.field_22787.method_1507(Parent);
        }).method_46433(this.field_22789 - 155, this.field_22790 - 25).method_46437(150, 20).method_46431());
    }

    public static void applyConfig() {
        configReader.saveConfig();
        EventManager.EVENTS_ENABLED = JsonReader.getBoolean("eventsEnabled", DefaultConfig.eventsEnabled);
        EventManager.TICK_INTERVAL = JsonReader.getInt("eventTickInterval", DefaultConfig.eventTickInterval);
        EventManager.EVENT_CHANCE = JsonReader.getDouble("eventChance", DefaultConfig.eventChance);
        EventManager.START_AFTER = JsonReader.getDouble("startEventsAfter", DefaultConfig.startEventsAfter);
        EventManager.GUARANTEED_EVENT = JsonReader.getDouble("guaranteedEvent", DefaultConfig.guaranteedEvent);
    }

    public void createConfigButtons() {
        if (SplitSelf.ShriekInstalled) {
            this.createBooleanConfigButton(this.field_22789 / 2 - 153, 65, "eventsEnabled", DefaultConfig.eventsEnabled, "config.splitself.events_enabled");
            this.createVoskConfigButton(this.field_22789 / 2 + 3, 65, "https://alphacephei.com/vosk/models", "config.splitself.vosk_model");
        } else {
            this.createBooleanConfigButton(this.field_22789 / 2 - 75, 65, "eventsEnabled", DefaultConfig.eventsEnabled, "config.splitself.events_enabled");
        }
        this.createIntConfigButton(this.field_22789 / 2 - 230, 105, "eventTickInterval", DefaultConfig.eventTickInterval, 1, 1000, "config.splitself.event_tick_interval");
        this.createDoubleConfigButton(this.field_22789 / 2 - 75, 105, "eventChance", DefaultConfig.eventChance, 0.01, 1.0, "config.splitself.event_chance");
        this.createIntConfigButton(this.field_22789 / 2 + 80, 105, "eventCooldown", DefaultConfig.eventCooldown, 100, 10000, "config.splitself.event_cooldown");
        this.createIntConfigButton(this.field_22789 / 2 - 230, 130, "guaranteedEvent", DefaultConfig.guaranteedEvent, 0, 24000, "config.splitself.guaranteed_event");
        this.createIntConfigButton(this.field_22789 / 2 - 75, 130, "startEventsAfter", DefaultConfig.startEventsAfter, 50, 20000, "config.splitself.start_events_after");
        this.createIntConfigButton(this.field_22789 / 2 + 80, 130, "repeatEventsAfter", DefaultConfig.repeatEventsAfter, 0, 10, "config.splitself.event_until_repeat");
        this.createMenuConfigButton(this.field_22789 / 2 - 230, 180, "config.splitself.group.event_weights", 0.0, 200.0, "eventWeights", InputType.INT);
        this.createMenuConfigButton(this.field_22789 / 2 - 75, 180, "config.splitself.group.event_stages", 0.0, 3.0, "eventStages", InputType.INT);
        this.createMenuConfigButton(this.field_22789 / 2 + 80, 180, "config.splitself.group.one_time_events", 0.0, 0.0, "oneTimeEvents", InputType.BOOLEAN);
    }

    public void createIntConfigButton(int x, int y, String configKey, int defaultValue, int minimum, int maximum, String translationKey) {
        this.method_37063((class_364)new DoubleTextButtonWidget(x, y, 150, 20, SplitSelf.translate(translationKey, new Object[0]), () -> String.valueOf(JsonReader.getInt(configKey, defaultValue)), () -> 0xFFFF00, translationKey + ".description", button -> this.createNumericValueWidget(5, this.field_22790 - 25, minimum, maximum, configKey, InputType.INT)));
    }

    public void createDoubleConfigButton(int x, int y, String configKey, double defaultValue, double minimum, double maximum, String translationKey) {
        this.method_37063((class_364)new DoubleTextButtonWidget(x, y, 150, 20, SplitSelf.translate(translationKey, new Object[0]), () -> String.valueOf(JsonReader.getDouble(configKey, defaultValue)), () -> 0xFFFF00, translationKey + ".description", button -> this.createNumericValueWidget(5, this.field_22790 - 25, minimum, maximum, configKey, InputType.DOUBLE)));
    }

    public void createBooleanConfigButton(int x, int y, String configKey, boolean defaultValue, String translationKey) {
        this.method_37063((class_364)new DoubleTextButtonWidget(x, y, 150, 20, SplitSelf.translate(translationKey, new Object[0]), () -> JsonReader.getBoolean(configKey, defaultValue) ? "True" : "False", () -> JsonReader.getBoolean(configKey, defaultValue) ? 65280 : 0xFF0000, translationKey + ".description", button -> {
            boolean newValue = !JsonReader.getBoolean(configKey, defaultValue);
            configReader.setBoolean(configKey, newValue);
            configReader.saveConfig();
        }));
    }

    public void createVoskConfigButton(int x, int y, String link, String translationKey) {
        this.method_37063((class_364)new SingleTextButtonWidget(x, y, 150, 20, SplitSelf.translate(translationKey, new Object[0]), SplitSelf.translate(translationKey + ".description", JsonReader.getString("voskModel")).getString(), button -> {
            class_156.method_668().method_670(link);
            this.createVoskValueWidget(5, this.field_22790 - 25);
        }));
    }

    public void createMenuConfigButton(int x, int y, String translationKey, double minimum, double maximum, String menuID, InputType inputType) {
        this.method_37063((class_364)new SingleTextButtonWidget(x, y, 150, 20, SplitSelf.translate(translationKey, new Object[0]), SplitSelf.translate(translationKey + ".description", new Object[0]).getString(), button -> {
            assert (this.field_22787 != null);
            arrayID = menuID;
            ScrollInputType = inputType;
            ScrollMinimum = minimum;
            ScrollMaximum = maximum;
            this.field_22787.method_1507((class_437)new ScrollingConfigScreen(this));
        }));
    }

    public void createNumericValueWidget(int x, int y, double minimum, double maximum, String configKey, InputType inputType) {
        if (this.textFieldWidget != null) {
            this.method_37066((class_364)this.textFieldWidget);
            this.method_37066((class_364)this.textFieldHeaderWidget);
            this.method_37066((class_364)this.submitButtonWidget);
        }
        this.textFieldWidget = (class_342)this.method_37063((class_364)new class_342(this.field_22793, x, y, 100, 20, (class_2561)class_2561.method_43473()));
        if (inputType == InputType.INT) {
            int textWidth = this.field_22793.method_27525((class_5348)SplitSelf.translate("config.splitself.numeric_value", (int)minimum, (int)maximum));
            this.textFieldHeaderWidget = (class_7842)this.method_37063((class_364)new class_7842(x, y - 15, textWidth, 20, SplitSelf.translate("config.splitself.numeric_value", (int)minimum, (int)maximum), this.field_22793));
        } else if (inputType == InputType.DOUBLE) {
            int textWidth = this.field_22793.method_27525((class_5348)SplitSelf.translate("config.splitself.numeric_value", minimum, maximum));
            this.textFieldHeaderWidget = (class_7842)this.method_37063((class_364)new class_7842(x, y - 15, textWidth, 20, SplitSelf.translate("config.splitself.numeric_value", minimum, maximum), this.field_22793));
        }
        this.submitButtonWidget = (class_4185)this.method_37063((class_364)new SingleTextButtonWidget(x + 100, y, 50, 20, (class_2561)class_2561.method_43470((String)"Submit"), null, button -> this.submitNumericPrompt(this.textFieldWidget, minimum, maximum, inputType, configKey)));
    }

    public void createVoskValueWidget(int x, int y) {
        if (this.textFieldWidget != null) {
            this.method_37066((class_364)this.textFieldWidget);
            this.method_37066((class_364)this.textFieldHeaderWidget);
            this.method_37066((class_364)this.submitButtonWidget);
        }
        this.textFieldWidget = (class_342)this.method_37063((class_364)new class_342(this.field_22793, x, y, 100, 20, (class_2561)class_2561.method_43473()));
        int textWidth = this.field_22793.method_27525((class_5348)SplitSelf.translate("config.splitself.string_value", new Object[0]));
        this.textFieldHeaderWidget = (class_7842)this.method_37063((class_364)new class_7842(x, y - 15, textWidth, 20, SplitSelf.translate("config.splitself.string_value", new Object[0]), this.field_22793));
        this.submitButtonWidget = (class_4185)this.method_37063((class_364)new SingleTextButtonWidget(x + 100, y, 50, 20, (class_2561)class_2561.method_43470((String)"Submit"), null, button -> this.submitVoskPrompt(this.textFieldWidget)));
    }

    private void submitNumericPrompt(class_342 textFieldWidget, double minimum, double maximum, InputType inputType, String configValue) {
        block6: {
            try {
                if (textFieldWidget.method_1882().isEmpty()) {
                    throw new NumberFormatException("Input value between " + minimum + " and " + maximum + "!");
                }
                if (inputType == InputType.INT) {
                    int newValue = Integer.parseInt(textFieldWidget.method_1882());
                    if ((double)newValue >= minimum && (double)newValue <= maximum) {
                        this.textFieldHeaderWidget.method_46438(0xFFFFFF);
                        configReader.setInt(configValue, newValue);
                        configReader.saveConfig();
                        break block6;
                    }
                    throw new NumberFormatException("Invalid value! (Not Within Bounds!)");
                }
                if (inputType != InputType.DOUBLE) break block6;
                double newValue = Double.parseDouble(textFieldWidget.method_1882());
                if (newValue >= minimum && newValue <= maximum) {
                    this.textFieldHeaderWidget.method_46438(0xFFFFFF);
                    configReader.setDouble(configValue, newValue);
                    configReader.saveConfig();
                    break block6;
                }
                throw new NumberFormatException("Invalid value! (Not Within Bounds!)");
            }
            catch (NumberFormatException e) {
                this.textFieldHeaderWidget.method_46438(0xFF0000);
            }
        }
    }

    private void submitVoskPrompt(class_342 textFieldWidget) {
        try {
            if (textFieldWidget.method_1882().isEmpty()) {
                throw new NumberFormatException("Input a value!");
            }
            if (!textFieldWidget.method_1882().startsWith("vosk-model-")) {
                throw new NumberFormatException("Input a model starting with `vosk-model-`!");
            }
            this.textFieldHeaderWidget.method_46438(0xFFFFFF);
            configReader.setString("voskModel", textFieldWidget.method_1882().replace(" ", "").replace(".zip", ""));
            configReader.saveConfig();
            class_368 restartToast = new class_368(){

                public class_368.class_369 method_1986(class_332 context, class_374 manager, long startTime) {
                    String message = class_2561.method_43471((String)"mco.error.invalid.session.message").getString();
                    int maxWidth = 180;
                    List<String> lines = this.wrapText(message, maxWidth);
                    int width = 200;
                    Objects.requireNonNull(((CustomConfigScreen)CustomConfigScreen.this).field_22787.field_1772);
                    int lineHeight = 9 + 2;
                    int height = Math.max(32, lines.size() * lineHeight + 12);
                    context.method_25294(0, 0, width, height, -2013265920);
                    context.method_49601(0, 0, width, height, -7829368);
                    int startY = (height - lines.size() * lineHeight) / 2;
                    for (int i = 0; i < lines.size(); ++i) {
                        String line = lines.get(i);
                        int textX = (width - ((CustomConfigScreen)CustomConfigScreen.this).field_22787.field_1772.method_1727(line)) / 2;
                        int textY = startY + i * lineHeight;
                        context.method_51433(((CustomConfigScreen)CustomConfigScreen.this).field_22787.field_1772, line, textX, textY, 0xFFFFFF, false);
                    }
                    return startTime >= 5000L ? class_368.class_369.field_2209 : class_368.class_369.field_2210;
                }

                private List<String> wrapText(String text, int maxWidth) {
                    ArrayList<String> lines = new ArrayList<String>();
                    String[] words = text.split(" ");
                    StringBuilder currentLine = new StringBuilder();
                    for (String word : words) {
                        String testLine;
                        String string = testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
                        if (((CustomConfigScreen)CustomConfigScreen.this).field_22787.field_1772.method_1727(testLine) <= maxWidth) {
                            currentLine = new StringBuilder(testLine);
                            continue;
                        }
                        if (!currentLine.isEmpty()) {
                            lines.add(currentLine.toString());
                            currentLine = new StringBuilder(word);
                            continue;
                        }
                        lines.add(word);
                    }
                    if (!currentLine.isEmpty()) {
                        lines.add(currentLine.toString());
                    }
                    if (lines.isEmpty()) {
                        lines.add("");
                    }
                    return lines;
                }

                public int method_29049() {
                    return 200;
                }

                public int method_29050() {
                    String message = class_2561.method_43471((String)"mco.error.invalid.session.message").getString();
                    List<String> lines = this.wrapText(message, 180);
                    Objects.requireNonNull(((CustomConfigScreen)CustomConfigScreen.this).field_22787.field_1772);
                    int lineHeight = 9 + 2;
                    return Math.max(32, lines.size() * lineHeight + 12);
                }
            };
            this.field_22787.method_1566().method_1999(restartToast);
        }
        catch (NumberFormatException e) {
            this.textFieldHeaderWidget.method_46438(0xFF0000);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        assert (this.field_22787 != null);
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_25290(CONFIG_IMAGE, this.field_22789 / 2 - 64, -35, 0.0f, 0.0f, 128, 128, 128, 128);
    }

    public boolean method_25422() {
        assert (this.field_22787 != null);
        CustomConfigScreen.applyConfig();
        this.field_22787.method_1507(Parent);
        return false;
    }

    public static enum InputType {
        INT,
        DOUBLE,
        BOOLEAN;

    }
}

