/*
 * Decompiled with CFR 0.152.
 */
package com.pryzmm.splitself.config;

import com.pryzmm.splitself.SplitSelf;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import org.apache.http.util.TextUtils;

public class DoubleTextButtonWidget
extends class_4185 {
    private final Supplier<String> rightTextSupplier;
    private final Supplier<Integer> rightTextColorSupplier;
    private int scrollOffset = 0;
    private long lastScrollTime = 0L;
    private static final int SCROLL_DELAY = 100;
    private static final int SCROLL_SPEED = 1;
    private static final int PAUSE_DURATION = 2000;

    public DoubleTextButtonWidget(int x, int y, int width, int height, class_2561 leftText, Supplier<String> rightTextSupplier, Supplier<Integer> rightTextColorSupplier, String tooltipTranslatableKey, class_4185.class_4241 onPress) {
        super(x, y, width, height, leftText, onPress, field_40754);
        this.rightTextSupplier = rightTextSupplier;
        this.rightTextColorSupplier = rightTextColorSupplier;
        if (!TextUtils.isEmpty((CharSequence)tooltipTranslatableKey)) {
            this.method_47400(class_7919.method_47407((class_2561)class_2561.method_30163((String)(leftText.getString() + "\n" + SplitSelf.translate(tooltipTranslatableKey, new Object[0]).getString()))));
        }
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_27534(class_310.method_1551().field_1772, (class_2561)class_2561.method_43473(), this.method_46426() + this.field_22758 / 2, this.method_46427() + (this.field_22759 - 8) / 2, 0);
        if (this.method_49606()) {
            context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -2130706433);
        } else {
            context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0x40000000);
        }
        context.method_49601(this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, this.method_25370() ? -1 : -8355712);
        String rightText = this.rightTextSupplier.get();
        int rightTextWidth = class_310.method_1551().field_1772.method_1727(rightText);
        int availableLeftTextWidth = this.field_22758 - rightTextWidth - 12;
        int leftTextX = this.method_46426() + 4;
        int textY = this.method_46427() + (this.field_22759 - 8) / 2;
        String leftText = this.method_25369().getString();
        int leftTextWidth = class_310.method_1551().field_1772.method_1727(leftText);
        if (leftTextWidth > availableLeftTextWidth) {
            this.updateScrollOffset(leftTextWidth, availableLeftTextWidth);
            context.method_44379(this.method_46426() + 4, this.method_46427(), this.method_46426() + 4 + availableLeftTextWidth, this.method_46427() + this.field_22759);
            context.method_25303(class_310.method_1551().field_1772, leftText, leftTextX - this.scrollOffset, textY, 0xFFFFFF);
            context.method_44380();
        } else {
            this.scrollOffset = 0;
            context.method_25303(class_310.method_1551().field_1772, leftText, leftTextX, textY, 0xFFFFFF);
        }
        int rightTextColor = this.rightTextColorSupplier.get();
        int rightTextX = this.method_46426() + this.field_22758 - rightTextWidth - 4;
        context.method_25303(class_310.method_1551().field_1772, rightText, rightTextX, textY, rightTextColor);
    }

    private void updateScrollOffset(int textWidth, int availableWidth) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastScrollTime < 100L) {
            return;
        }
        this.lastScrollTime = currentTime;
        int maxScroll = textWidth - availableWidth;
        long totalCycleTime = maxScroll * 2 * 100 / 1 + 4000;
        long cyclePosition = currentTime % totalCycleTime;
        if (cyclePosition < 2000L) {
            this.scrollOffset = 0;
        } else if (cyclePosition < (long)(2000 + maxScroll * 100 / 1)) {
            long scrollTime = cyclePosition - 2000L;
            this.scrollOffset = (int)(scrollTime * 1L / 100L);
            this.scrollOffset = class_3532.method_15340((int)this.scrollOffset, (int)0, (int)maxScroll);
        } else if (cyclePosition < (long)(4000 + maxScroll * 100 / 1)) {
            this.scrollOffset = maxScroll;
        } else {
            long scrollTime = cyclePosition - (long)(4000 + maxScroll * 100 / 1);
            this.scrollOffset = maxScroll - (int)(scrollTime * 1L / 100L);
            this.scrollOffset = class_3532.method_15340((int)this.scrollOffset, (int)0, (int)maxScroll);
        }
    }
}

