/*
 * Decompiled with CFR 0.152.
 */
package com.pryzmm.splitself.config;

import com.pryzmm.splitself.SplitSelf;
import com.pryzmm.splitself.config.CustomConfigScreen;
import com.pryzmm.splitself.config.ElementList;
import com.pryzmm.splitself.config.SingleTextButtonWidget;
import com.pryzmm.splitself.file.JsonReader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7842;

public class ScrollingConfigScreen
extends class_437 {
    public static final class_2960 CONFIG_IMAGE = class_2960.method_60655((String)"splitself", (String)"textures/gui/title/config_title.png");
    private static JsonReader jsonReader;
    private final class_437 parent;
    private ElementList elementList;
    class_342 textFieldWidget;
    class_7842 textFieldHeaderWidget;
    class_4185 submitButtonWidget;

    public ScrollingConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)""));
        this.parent = parent;
        if (jsonReader == null) {
            jsonReader = new JsonReader("splitself.json5");
        }
    }

    protected void method_25426() {
        this.createDoneButton();
        this.createElementListWidget();
        this.populateConfigOptions(CustomConfigScreen.arrayID, CustomConfigScreen.ScrollInputType);
    }

    public void createElementListWidget() {
        this.elementList = (ElementList)this.method_37063((class_364)new ElementList(this.field_22787, 0, 60, this.field_22789, this.field_22790 - 110));
        this.elementList.method_25322();
    }

    private void populateConfigOptions(String arrayID, CustomConfigScreen.InputType inputType) {
        for (String configKey : JsonReader.getKeysFromObject(arrayID)) {
            this.elementList.addEntry(new ElementList.DoubleButtonEntry(configKey, arrayID, inputType, button -> {
                if (inputType == CustomConfigScreen.InputType.INT || inputType == CustomConfigScreen.InputType.DOUBLE) {
                    this.createNumericValueWidget(5, this.field_22790 - 25, CustomConfigScreen.ScrollMinimum, CustomConfigScreen.ScrollMaximum, configKey, inputType);
                } else if (inputType == CustomConfigScreen.InputType.BOOLEAN) {
                    boolean newValue = JsonReader.getBooleanFromArray(arrayID, configKey) == false;
                    jsonReader.setBooleanInObject(arrayID, configKey, newValue);
                    jsonReader.saveConfig();
                }
            }));
        }
    }

    public void createDoneButton() {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), button -> {
            assert (this.field_22787 != null);
            CustomConfigScreen.applyConfig();
            this.field_22787.method_1507(this.parent);
        }).method_46433(this.field_22789 - 155, this.field_22790 - 25).method_46437(150, 20).method_46431());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        assert (this.field_22787 != null);
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_25290(CONFIG_IMAGE, this.field_22789 / 2 - 64, -35, 0.0f, 0.0f, 128, 128, 128, 128);
    }

    public boolean method_25422() {
        assert (this.field_22787 != null);
        CustomConfigScreen.applyConfig();
        this.field_22787.method_1507((class_437)new CustomConfigScreen(CustomConfigScreen.Parent));
        return false;
    }

    public void createNumericValueWidget(int x, int y, double minimum, double maximum, String configKey, CustomConfigScreen.InputType inputType) {
        if (this.textFieldWidget != null) {
            this.method_37066((class_364)this.textFieldWidget);
            this.method_37066((class_364)this.textFieldHeaderWidget);
            this.method_37066((class_364)this.submitButtonWidget);
        }
        this.textFieldWidget = (class_342)this.method_37063((class_364)new class_342(this.field_22793, x, y, 100, 20, (class_2561)class_2561.method_43473()));
        if (inputType == CustomConfigScreen.InputType.INT) {
            int textWidth = this.field_22793.method_27525((class_5348)SplitSelf.translate("config.splitself.numeric_value", (int)minimum, (int)maximum));
            this.textFieldHeaderWidget = (class_7842)this.method_37063((class_364)new class_7842(x, y - 15, textWidth, 20, SplitSelf.translate("config.splitself.numeric_value", (int)minimum, (int)maximum), this.field_22793));
        } else if (inputType == CustomConfigScreen.InputType.DOUBLE) {
            int textWidth = this.field_22793.method_27525((class_5348)SplitSelf.translate("config.splitself.numeric_value", minimum, maximum));
            this.textFieldHeaderWidget = (class_7842)this.method_37063((class_364)new class_7842(x, y - 15, textWidth, 20, SplitSelf.translate("config.splitself.numeric_value", minimum, maximum), this.field_22793));
        }
        this.submitButtonWidget = (class_4185)this.method_37063((class_364)new SingleTextButtonWidget(x + 100, y, 50, 20, (class_2561)class_2561.method_43470((String)"Submit"), null, button -> this.submitPrompt(this.textFieldWidget, minimum, maximum, inputType, configKey)));
    }

    private void submitPrompt(class_342 textFieldWidget, double minimum, double maximum, CustomConfigScreen.InputType inputType, String configValue) {
        block6: {
            try {
                if (textFieldWidget.method_1882().isEmpty()) {
                    throw new NumberFormatException("Input value between " + minimum + " and " + maximum + "!");
                }
                if (inputType == CustomConfigScreen.InputType.INT) {
                    int newValue = Integer.parseInt(textFieldWidget.method_1882());
                    if ((double)newValue >= minimum && (double)newValue <= maximum) {
                        this.textFieldHeaderWidget.method_46438(0xFFFFFF);
                        jsonReader.setIntInObject(CustomConfigScreen.arrayID, configValue, newValue);
                        jsonReader.saveConfig();
                        break block6;
                    }
                    throw new NumberFormatException("Invalid value! (Not Within Bounds!)");
                }
                if (inputType != CustomConfigScreen.InputType.DOUBLE) break block6;
                double newValue = Double.parseDouble(textFieldWidget.method_1882());
                if (newValue >= minimum && newValue <= maximum) {
                    this.textFieldHeaderWidget.method_46438(0xFFFFFF);
                    jsonReader.setDoubleInObject(CustomConfigScreen.arrayID, configValue, newValue);
                    jsonReader.saveConfig();
                    break block6;
                }
                throw new NumberFormatException("Invalid value! (Not Within Bounds!)");
            }
            catch (NumberFormatException e) {
                this.textFieldHeaderWidget.method_46438(0xFF0000);
            }
        }
    }
}

