/*
 * Decompiled with CFR 0.152.
 */
package com.pryzmm.splitself.events;

public class SkyColor {
    private static Integer currentSkyColor = null;
    private static Integer currentFogColor = null;

    public static void changeFogColor(String hex) {
        try {
            if (hex.startsWith("#")) {
                hex = hex.substring(1);
            }
            currentFogColor = Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid hex color: " + hex);
        }
    }

    public static void changeSkyColor(String hex) {
        try {
            if (hex.startsWith("#")) {
                hex = hex.substring(1);
            }
            currentSkyColor = Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid hex color: " + hex);
        }
    }

    public static float[] getSkyRGBComponents() {
        if (currentSkyColor == null) {
            return null;
        }
        int r = currentSkyColor >> 16 & 0xFF;
        int g = currentSkyColor >> 8 & 0xFF;
        int b = currentSkyColor & 0xFF;
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }

    public static float[] getFogRGBComponents() {
        if (currentFogColor == null) {
            return null;
        }
        int r = currentFogColor >> 16 & 0xFF;
        int g = currentFogColor >> 8 & 0xFF;
        int b = currentFogColor & 0xFF;
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }
}

