/*
 * Decompiled with CFR 0.152.
 */
package com.pryzmm.splitself.events;

import com.pryzmm.splitself.events.EventManager;
import com.pryzmm.splitself.world.DataTracker;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class SleepTracker {
    private static final Map<UUID, SleepData> sleepingPlayers = new HashMap<UUID, SleepData>();
    private static DataTracker tracker;

    public static void startSleep(class_3222 player) {
        class_3218 world = player.method_51469();
        sleepingPlayers.put(player.method_5667(), new SleepData(world.method_8510(), world.method_8532()));
    }

    public static void updateSleep(class_3222 player) {
        SleepData data = sleepingPlayers.get(player.method_5667());
        if (data == null) {
            return;
        }
        tracker = DataTracker.getServerState(player.method_5682());
        class_3218 world = player.method_51469();
        long currentGameTime = world.method_8510();
        long sleepDuration = currentGameTime - data.sleepStartTime;
        if (sleepDuration == 100L) {
            double num = Math.random();
            if (tracker.getPlayerSleepStage(player.method_5667()) == 0) {
                tracker.setPlayerSleepStage(player.method_5667(), tracker.getPlayerSleepStage(player.method_5667()) + 1);
                EventManager.runSleepEvent(player, 0);
            } else if (tracker.getPlayerSleepStage(player.method_5667()) == 1 && Math.floor(num * 4.0 + 1.0) == 1.0) {
                tracker.setPlayerSleepStage(player.method_5667(), tracker.getPlayerSleepStage(player.method_5667()) + 1);
                EventManager.runSleepEvent(player, 1);
            } else if (tracker.getPlayerSleepStage(player.method_5667()) == 2 && Math.floor(num * 6.0 + 1.0) == 1.0) {
                tracker.setPlayerSleepStage(player.method_5667(), tracker.getPlayerSleepStage(player.method_5667()) + 1);
                EventManager.runSleepEvent(player, 2);
            } else if (Math.floor(num * 6.0 + 1.0) == 1.0) {
                EventManager.runSleepEvent(player, 3);
            }
        }
    }

    public static class SleepData {
        public final long sleepStartTime;
        public final long sleepStartWorldTime;

        public SleepData(long gameTime, long worldTime) {
            this.sleepStartTime = gameTime;
            this.sleepStartWorldTime = worldTime;
        }
    }
}

