/*
 * Decompiled with CFR 0.152.
 */
package com.pryzmm.splitself.events;

import com.pryzmm.splitself.SplitSelf;
import com.pryzmm.splitself.entity.client.TheForgottenSpawner;
import com.pryzmm.splitself.world.IntegrityProcessor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3485;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3793;
import net.minecraft.class_5218;
import net.minecraft.class_5425;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class StructureManager {
    public static void saveStructure(class_3218 world, class_2338 startPos, class_2338 endPos, String fileName) {
        try {
            Path structuresPath = StructureManager.getStructuresDirectory(world);
            Files.createDirectories(structuresPath, new FileAttribute[0]);
            class_2338 size = endPos.method_10059((class_2382)startPos).method_10069(1, 1, 1);
            class_3499 template = new class_3499();
            template.method_15174((class_1937)world, startPos, (class_2382)size, true, null);
            class_2487 nbt = template.method_15175(new class_2487());
            Path filePath = structuresPath.resolve(fileName + ".nbt");
            try (FileOutputStream fos = new FileOutputStream(filePath.toFile());){
                class_2507.method_10634((class_2487)nbt, (OutputStream)fos);
            }
        }
        catch (Exception e) {
            SplitSelf.LOGGER.error("Error saving structure {}: {}", (Object)fileName, (Object)e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<class_3499> loadStructure(class_3218 world, String fileName) {
        Optional<class_3499> optional;
        Path structuresPath = StructureManager.getStructuresDirectory(world);
        Path filePath = structuresPath.resolve(fileName + ".nbt");
        if (!Files.exists(filePath, new LinkOption[0])) return StructureManager.loadStructureFromResource(world, fileName);
        FileInputStream fis = new FileInputStream(filePath.toFile());
        try {
            class_2487 nbt = class_2507.method_10629((InputStream)fis, (class_2505)class_2505.method_53898());
            class_3499 template = new class_3499();
            template.method_15183((class_7871)world.method_30349().method_46762(class_7924.field_41254), nbt);
            optional = Optional.of(template);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                SplitSelf.LOGGER.error("Error loading structure {}: {}", (Object)fileName, (Object)e.getMessage());
                return Optional.empty();
            }
        }
        fis.close();
        return optional;
    }

    private static Optional<class_3499> loadStructureFromResource(class_3218 world, String fileName) {
        try {
            String resourcePath = "/data/splitself/structures/" + fileName + ".nbt";
            InputStream inputStream = StructureManager.class.getResourceAsStream(resourcePath);
            if (inputStream == null) {
                return Optional.empty();
            }
            class_2487 nbtCompound = class_2507.method_10629((InputStream)inputStream, (class_2505)class_2505.method_53898());
            inputStream.close();
            class_3499 template = new class_3499();
            template.method_15183((class_7871)world.method_30349().method_46762(class_7924.field_41254), nbtCompound);
            return Optional.of(template);
        }
        catch (Exception e) {
            SplitSelf.LOGGER.error("Error loading structure from resource {}: {}", (Object)fileName, (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public static boolean placeStructure(class_3218 world, class_2338 pos, String fileName, class_2470 rotation, class_2415 mirror, Float Integrity, boolean ignoreEntities) {
        Optional<class_3499> templateOpt = StructureManager.loadStructure(world, fileName);
        if (templateOpt.isEmpty()) {
            SplitSelf.LOGGER.warn("Could not load structure: {}", (Object)fileName);
            return false;
        }
        try {
            StructureManager.placeTemplate(world, pos, templateOpt.get(), rotation, mirror, Integrity, ignoreEntities);
            return true;
        }
        catch (Exception e) {
            SplitSelf.LOGGER.error("Error placing structure {}: {}", (Object)fileName, (Object)e.getMessage());
            return false;
        }
    }

    public static void placeStructureRandomRotation(class_3218 world, class_2338 pos, String structureName, Integer MinimumRange, Integer MaximumRange, boolean DisableRotation, Float Integrity, boolean ignoreEntities) {
        try {
            Random random = new Random();
            double distance = (double)MinimumRange.intValue() + random.nextDouble() * (double)(MaximumRange - MinimumRange);
            double angle = random.nextDouble() * 2.0 * Math.PI;
            double spawnX = (double)pos.method_10263() + Math.cos(angle) * distance;
            double spawnY = (double)pos.method_10264() + Math.cos(angle) * distance;
            double spawnZ = (double)pos.method_10260() + Math.sin(angle) * distance;
            class_2338 spawnPos = new class_2338((int)spawnX, (int)spawnY, (int)spawnZ);
            class_2470 rotation = !DisableRotation ? class_2470.values()[world.method_8409().method_43048(4)] : class_2470.field_11467;
            class_3485 templateManager = world.method_14183();
            class_2960 structureId = class_2960.method_60655((String)"splitself", (String)structureName);
            Optional template = templateManager.method_15094(structureId);
            if (template.isPresent()) {
                StructureManager.placeTemplate(world, spawnPos, (class_3499)template.get(), rotation, class_2415.field_11302, Integrity, ignoreEntities);
                return;
            }
            StructureManager.placeStructure(world, spawnPos, structureName, rotation, class_2415.field_11302, Integrity, ignoreEntities);
        }
        catch (Exception e) {
            SplitSelf.LOGGER.info("Error placing structure with rotation: {}", (Object)String.valueOf(e));
        }
    }

    public static class_2338 placeStructureRandomRotation(class_3218 world, class_1657 Player, String structureName, Integer MinimumRange, Integer MaximumRange, Integer YOffset, boolean DisableRotation, Float Integrity, boolean ignoreEntities) {
        try {
            class_2960 structureId;
            Random random = new Random();
            double distance = (double)MinimumRange.intValue() + random.nextDouble() * (double)(MaximumRange - MinimumRange);
            double angle = random.nextDouble() * 2.0 * Math.PI;
            class_243 playerPos = Player.method_19538();
            double spawnX = playerPos.field_1352 + Math.cos(angle) * distance;
            double spawnZ = playerPos.field_1350 + Math.sin(angle) * distance;
            class_2338 spawnPos = new class_2338((int)spawnX, 0, (int)spawnZ);
            int surfaceY = Player.method_37908().method_8624(class_2902.class_2903.field_13203, spawnPos.method_10263(), spawnPos.method_10260()) + YOffset;
            class_2338 finalSpawnPos = new class_2338((int)spawnX, surfaceY, (int)spawnZ);
            if (structureName.equals("house")) {
                int arrayLength;
                class_2338[] newPositions;
                try {
                    newPositions = new class_2338[TheForgottenSpawner.spawnPositions.length + 1];
                    arrayLength = TheForgottenSpawner.spawnPositions.length;
                    System.arraycopy(TheForgottenSpawner.spawnPositions, 0, newPositions, 0, arrayLength);
                }
                catch (Exception e) {
                    newPositions = new class_2338[1];
                    arrayLength = 0;
                }
                newPositions[arrayLength] = finalSpawnPos;
                TheForgottenSpawner.spawnPositions = newPositions;
            }
            class_2470 rotation = !DisableRotation ? class_2470.values()[world.method_8409().method_43048(4)] : class_2470.field_11467;
            class_3485 templateManager = world.method_14183();
            Optional template = templateManager.method_15094(structureId = class_2960.method_60655((String)"splitself", (String)structureName));
            if (template.isPresent()) {
                StructureManager.placeTemplate(world, finalSpawnPos, (class_3499)template.get(), rotation, class_2415.field_11302, Integrity, ignoreEntities);
                return finalSpawnPos;
            }
            if (StructureManager.placeStructure(world, finalSpawnPos, structureName, rotation, class_2415.field_11302, Integrity, ignoreEntities)) {
                return finalSpawnPos;
            }
        }
        catch (Exception e) {
            SplitSelf.LOGGER.info("Error placing structure: {}", (Object)String.valueOf(e));
        }
        return null;
    }

    private static void placeTemplate(class_3218 world, class_2338 pos, class_3499 template, class_2470 rotation, class_2415 mirror, Float Integrity, boolean ignoreEntities) {
        class_3492 placementData = new class_3492().method_15123(rotation).method_15125(mirror).method_15133(ignoreEntities).method_16184((class_3491)class_3793.field_16721);
        if (Integrity != null && Integrity.floatValue() < 1.0f) {
            placementData.method_16184((class_3491)new IntegrityProcessor(Integrity.floatValue()));
        }
        template.method_15172((class_5425)world, pos, pos, placementData, world.method_8409(), 2);
    }

    private static Path getStructuresDirectory(class_3218 world) {
        Path worldDir = world.method_8503().method_27050(class_5218.field_24188);
        return worldDir.resolve("generated/minecraft/structures");
    }
}

