/*
 * Decompiled with CFR 0.152.
 */
package com.pryzmm.splitself.file;

import com.pryzmm.splitself.SplitSelf;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;

public class BackgroundManager {
    private static String userBackground = null;
    private static String modBackground = null;

    private static void setWallpaperFromFile(String filePath) {
        try {
            String powershellCommand = "$image = '" + filePath.replace("\\", "\\\\") + "'\n$desktop = [Environment]::GetFolderPath('Desktop')\nAdd-Type -AssemblyName System.Drawing\n$bmpPath = \"$env:TEMP\\wallpaper.bmp\"\n$img = [System.Drawing.Image]::FromFile($image)\n$img.Save($bmpPath, [System.Drawing.Imaging.ImageFormat]::Bmp)\n$img.Dispose()\nAdd-Type @\"\nusing System;\nusing System.Runtime.InteropServices;\npublic class Wallpaper {\n    [DllImport(\"user32.dll\", CharSet = CharSet.Auto)]\n    public static extern int SystemParametersInfo(int uAction, int uParam, string lpvParam, int fuWinIni);\n}\n\"@\n[Wallpaper]::SystemParametersInfo(20, 0, $bmpPath, 3)";
            File ps1 = new File(System.getProperty("java.io.tmpdir"), "restore_wallpaper.ps1");
            Files.writeString(ps1.toPath(), (CharSequence)powershellCommand, new OpenOption[0]);
            ProcessBuilder pb = new ProcessBuilder("powershell", "-ExecutionPolicy", "Bypass", "-WindowStyle", "Hidden", "-File", ps1.getAbsolutePath());
            pb.redirectErrorStream(true);
            Process process = pb.start();
            process.waitFor();
        }
        catch (Exception e) {
            SplitSelf.LOGGER.error("Failed to set wallpaper from file, " + filePath + " because, " + e.getMessage());
        }
    }

    public static String getUserBackground() {
        return userBackground;
    }

    public static String getModBackground() {
        return modBackground;
    }

    public static void restoreUserBackground() {
        if (!System.getProperty("os.name").toLowerCase().startsWith("win")) {
            SplitSelf.LOGGER.info("Restoring user background is not implemented for non-Windows OS'");
            return;
        }
        if (userBackground == null) {
            return;
        }
        try {
            String currentWallpaper = BackgroundManager.getCurrentBackground();
            if (currentWallpaper != null && currentWallpaper.equals(modBackground)) {
                BackgroundManager.setWallpaperFromFile(userBackground);
                SplitSelf.LOGGER.info("Restored original wallpaper: " + userBackground);
            } else {
                SplitSelf.LOGGER.info("User changed wallpaper during play \u2014 skipping restore.");
            }
        }
        catch (Exception e) {
            SplitSelf.LOGGER.error("Failed to restore original wallpaper", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCurrentBackground() {
        if (!System.getProperty("os.name").toLowerCase().startsWith("win")) {
            SplitSelf.LOGGER.info("Cannot get current background because this is not a Windows OS.");
            return null;
        }
        try {
            String powershellCommand = "Get-ItemPropertyValue -Path \"Registry::HKEY_CURRENT_USER\\Control Panel\\Desktop\" -Name Wallpaper";
            File ps1 = new File(System.getProperty("java.io.tmpdir"), "get_wallpaper.ps1");
            Files.writeString(ps1.toPath(), (CharSequence)powershellCommand, new OpenOption[0]);
            ProcessBuilder pb = new ProcessBuilder("powershell", "-ExecutionPolicy", "Bypass", "-WindowStyle", "Hidden", "-File", ps1.getAbsolutePath());
            pb.redirectErrorStream(true);
            Process process = pb.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String output = reader.readLine();
                process.waitFor();
                if (output == null) return null;
                if (output.isBlank()) return null;
                File f = new File(output = output.trim());
                if (!f.exists() || f.isDirectory()) {
                    String string = null;
                    return string;
                }
                String string = output;
                return string;
            }
        }
        catch (Exception e) {
            SplitSelf.LOGGER.error("Failed to get current background, " + e.getMessage());
        }
        return null;
    }

    public static void setBackground(String resourcePath, String outputName) {
        if (!System.getProperty("os.name").toLowerCase().startsWith("win")) {
            SplitSelf.LOGGER.info("[WaitForMeProcedure] Not executing payload since the OS is not Windows.");
            return;
        }
        if (userBackground == null) {
            String tempUserBackground = BackgroundManager.getCurrentBackground();
            if (tempUserBackground == null) {
                SplitSelf.LOGGER.info("[WaitForMeProcedure] Not executing payload since we couldn't find the user background to save.");
                return;
            }
            userBackground = tempUserBackground;
        }
        try {
            String line;
            File image = BackgroundManager.exportResource(resourcePath, outputName);
            String psScript = "$image = '" + image.getAbsolutePath().replace("\\", "\\\\") + "'\n$desktop = [Environment]::GetFolderPath('Desktop')\nAdd-Type -AssemblyName System.Drawing\n$bmpPath = \"$env:TEMP\\wallpaper.bmp\"\n$img = [System.Drawing.Image]::FromFile($image)\n$img.Save($bmpPath, [System.Drawing.Imaging.ImageFormat]::Bmp)\n$img.Dispose()\nAdd-Type @\"\nusing System;\nusing System.Runtime.InteropServices;\npublic class Wallpaper {\n    [DllImport(\"user32.dll\", CharSet = CharSet.Auto)]\n    public static extern int SystemParametersInfo(int uAction, int uParam, string lpvParam, int fuWinIni);\n}\n\"@\n[Wallpaper]::SystemParametersInfo(20, 0, $bmpPath, 3)";
            File ps1 = new File(System.getProperty("java.io.tmpdir"), "payload.ps1");
            Files.writeString(ps1.toPath(), (CharSequence)psScript, new OpenOption[0]);
            SplitSelf.LOGGER.info("[WaitForMeProcedure] PowerShell script saved to: " + ps1.getAbsolutePath());
            File batFile = new File(System.getProperty("java.io.tmpdir"), "launch_payload.bat");
            String batCommand = "powershell -ExecutionPolicy Bypass -WindowStyle Hidden -File \"" + ps1.getAbsolutePath() + "\"\n";
            Files.writeString(batFile.toPath(), (CharSequence)batCommand, new OpenOption[0]);
            SplitSelf.LOGGER.info("[WaitForMeProcedure] Batch file created: " + batFile.getAbsolutePath());
            Process process = new ProcessBuilder("cmd.exe", "/c", batFile.getAbsolutePath()).redirectErrorStream(true).start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                SplitSelf.LOGGER.info("[BAT OUTPUT] " + line);
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                SplitSelf.LOGGER.error("Batch file execution failed with exit code: " + exitCode);
            } else {
                SplitSelf.LOGGER.info("Batch file executed successfully.");
                modBackground = BackgroundManager.getCurrentBackground();
            }
        }
        catch (Exception e) {
            SplitSelf.LOGGER.error("[WaitForMeProcedure] Error executing payload.");
        }
    }

    public static File exportResource(String resourcePath, String outputName) throws IOException {
        InputStream stream = BackgroundManager.class.getResourceAsStream(resourcePath);
        if (stream == null) {
            throw new FileNotFoundException("Resource not found: " + resourcePath);
        }
        File tempFile = new File(System.getProperty("java.io.tmpdir"), outputName);
        Files.copy(stream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        SplitSelf.LOGGER.info("[WaitForMeProcedure] Exported resource: " + tempFile.getAbsolutePath());
        return tempFile;
    }
}

