/*
 * Decompiled with CFR 0.152.
 */
package com.pryzmm.splitself.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class BrowserHistoryReader {
    public List<HistoryEntry> getRecentHistory(int limit) {
        ArrayList<HistoryEntry> history = new ArrayList<HistoryEntry>();
        history.addAll(this.readChromeHistory(limit, "last_visit_time"));
        history.addAll(this.readBraveHistory(limit, "last_visit_time"));
        history.addAll(this.readFirefoxHistory(limit, "last_visit_date"));
        history.addAll(this.readOperaGXHistory(limit, "last_visit_time"));
        history.sort((a, b) -> Long.compare(b.visitTime, a.visitTime));
        return history.subList(0, Math.min(limit, history.size()));
    }

    public List<HistoryEntry> getMostVisited(int limit) {
        int i;
        ArrayList<HistoryEntry> history = new ArrayList<HistoryEntry>();
        List<HistoryEntry> chromeEntries = this.readChromeHistory(100, "visit_count");
        List<HistoryEntry> braveEntries = this.readBraveHistory(100, "visit_count");
        List<HistoryEntry> firefoxEntries = this.readFirefoxHistory(100, "visit_count");
        List<HistoryEntry> operaEntries = this.readOperaGXHistory(100, "visit_count");
        history.addAll(chromeEntries);
        history.addAll(braveEntries);
        history.addAll(firefoxEntries);
        history.addAll(operaEntries);
        if (!history.isEmpty()) {
            for (i = 0; i < Math.min(5, history.size()); ++i) {
                HistoryEntry historyEntry = (HistoryEntry)history.get(i);
            }
        }
        history.sort((a, b) -> Integer.compare(b.visitCount, a.visitCount));
        System.out.println("Debug - Top entries after sorting:");
        for (i = 0; i < Math.min(5, history.size()); ++i) {
            HistoryEntry entry = (HistoryEntry)history.get(i);
            System.out.println("  " + entry.browser + ": " + entry.title + " (visits: " + entry.visitCount + ")");
        }
        return history.subList(0, Math.min(limit, history.size()));
    }

    private List<HistoryEntry> readChromeHistory(int limit, String sort) {
        String historyPath = this.getChromeHistoryPath();
        System.out.println("Debug - Chrome history path: " + historyPath);
        return new ArrayList<HistoryEntry>(this.readChromiumBasedHistory(historyPath, limit, "Chrome", sort));
    }

    private List<HistoryEntry> readBraveHistory(int limit, String sort) {
        String historyPath = this.getBraveHistoryPath();
        System.out.println("Debug - Brave history path: " + historyPath);
        return new ArrayList<HistoryEntry>(this.readChromiumBasedHistory(historyPath, limit, "Brave", sort));
    }

    private List<HistoryEntry> readOperaGXHistory(int limit, String sort) {
        String historyPath = this.getOperaGXHistoryPath();
        System.out.println("Debug - Opera GX history path: " + historyPath);
        return new ArrayList<HistoryEntry>(this.readChromiumBasedHistory(historyPath, limit, "OperaGX", sort));
    }

    private List<HistoryEntry> readFirefoxHistory(int limit, String sort) {
        ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        String historyPath = this.getFirefoxHistoryPath();
        System.out.println("Debug - Firefox history path: " + historyPath);
        if (historyPath == null) {
            System.out.println("Debug - Firefox history path is null");
            return entries;
        }
        File historyFile = new File(historyPath);
        if (!historyFile.exists()) {
            System.out.println("Firefox history file not found at: " + historyPath);
            return entries;
        }
        String tempPath = this.copyToTempFile(historyPath, "Firefox");
        String connectionUrl = "jdbc:sqlite:" + (tempPath != null ? tempPath : historyPath);
        try {
            Connection conn = DriverManager.getConnection(connectionUrl);
            String query = "SELECT url, title, visit_count, last_visit_date FROM moz_places WHERE last_visit_date IS NOT NULL AND visit_count > 0 ORDER BY " + sort + " DESC LIMIT ?";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setInt(1, limit);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String title = rs.getString("title");
                title = this.replaceTitle(title);
                long firefoxTime = rs.getLong("last_visit_date");
                long compatibleTime = firefoxTime + 11644473600000000L;
                if (title == null || title.trim().isEmpty() || title.contains("GX Corner") || title.contains("New Tab") || title.equals("Home")) continue;
                entries.add(new HistoryEntry(rs.getString("url"), title, compatibleTime, rs.getInt("visit_count"), "Firefox"));
            }
            conn.close();
            if (tempPath != null) {
                new File(tempPath).delete();
            }
        }
        catch (SQLException e) {
            System.err.println("Error reading Firefox history: " + e.getMessage());
        }
        return entries;
    }

    private List<HistoryEntry> readChromiumBasedHistory(String historyPath, int limit, String browserName, String sort) {
        ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        File historyFile = new File(historyPath);
        if (!historyFile.exists()) {
            System.out.println(browserName + " history file not found at: " + historyPath);
            return entries;
        }
        String tempPath = this.copyToTempFile(historyPath, browserName);
        String connectionUrl = "jdbc:sqlite:" + (tempPath != null ? tempPath : historyPath);
        try {
            Connection conn = DriverManager.getConnection(connectionUrl);
            String query = "SELECT url, title, visit_count, last_visit_time FROM urls WHERE last_visit_time > 0 AND visit_count > 0 ORDER BY " + sort + " DESC LIMIT ?";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setInt(1, limit);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String title = rs.getString("title");
                title = this.replaceTitle(title);
                entries.add(new HistoryEntry(rs.getString("url"), title, rs.getLong("last_visit_time"), rs.getInt("visit_count"), browserName));
            }
            conn.close();
            if (tempPath != null) {
                new File(tempPath).delete();
            }
        }
        catch (SQLException e) {
            System.err.println("Error reading " + browserName + " history: " + e.getMessage());
        }
        return entries;
    }

    private String copyToTempFile(String originalPath, String browserName) {
        try {
            File originalFile = new File(originalPath);
            if (!originalFile.exists()) {
                return null;
            }
            File tempFile = File.createTempFile(browserName.toLowerCase() + "_history_", ".sqlite");
            tempFile.deleteOnExit();
            Files.copy(originalFile.toPath(), tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            System.out.println("Created temporary copy of " + browserName + " history for safe reading.");
            return tempFile.getAbsolutePath();
        }
        catch (IOException e) {
            System.err.println("Could not copy " + browserName + " history file: " + e.getMessage());
            System.err.println("Will attempt to read original file directly.");
            return null;
        }
        catch (Exception e) {
            System.err.println("Unexpected error copying " + browserName + " history: " + e.getMessage());
            return null;
        }
    }

    private String getChromeHistoryPath() {
        String os = System.getProperty("os.name").toLowerCase();
        String userHome = System.getProperty("user.home");
        if (os.contains("win")) {
            return userHome + "/AppData/Local/Google/Chrome/User Data/Default/History";
        }
        if (os.contains("mac")) {
            return userHome + "/Library/Application Support/Google/Chrome/Default/History";
        }
        return userHome + "/.config/google-chrome/Default/History";
    }

    private String getBraveHistoryPath() {
        String os = System.getProperty("os.name").toLowerCase();
        String userHome = System.getProperty("user.home");
        if (os.contains("win")) {
            return userHome + "/AppData/Local/BraveSoftware/Brave-Browser/User Data/Default/History";
        }
        if (os.contains("mac")) {
            return userHome + "/Library/Application Support/BraveSoftware/Brave-Browser/Default/History";
        }
        return userHome + "/.config/BraveSoftware/Brave-Browser/Default/History";
    }

    private String getOperaGXHistoryPath() {
        String os = System.getProperty("os.name").toLowerCase();
        String userHome = System.getProperty("user.home");
        if (os.contains("win")) {
            return userHome + "/AppData/Roaming/Opera Software/Opera GX Stable/History";
        }
        if (os.contains("mac")) {
            return userHome + "/Library/Application Support/com.operasoftware.OperaGX/History";
        }
        return userHome + "/.config/opera-gx/History";
    }

    private String getFirefoxHistoryPath() {
        File[] profiles;
        String os = System.getProperty("os.name").toLowerCase();
        String userHome = System.getProperty("user.home");
        Object profilesPath = "";
        profilesPath = os.contains("win") ? userHome + "/AppData/Roaming/Mozilla/Firefox/Profiles" : (os.contains("mac") ? userHome + "/Library/Application Support/Firefox/Profiles" : userHome + "/.mozilla/firefox");
        File profilesDir = new File((String)profilesPath);
        if (profilesDir.exists() && profilesDir.isDirectory() && (profiles = profilesDir.listFiles()) != null) {
            for (File profile : profiles) {
                File placesFile;
                if (!profile.isDirectory() || !profile.getName().contains("default") && !profile.getName().contains("release") || !(placesFile = new File(profile, "places.sqlite")).exists()) continue;
                return placesFile.getAbsolutePath();
            }
        }
        return null;
    }

    public static List<HistoryEntry> getHistory() {
        BrowserHistoryReader reader = new BrowserHistoryReader();
        return reader.getRecentHistory(10);
    }

    public static List<HistoryEntry> getMostVisited() {
        BrowserHistoryReader reader = new BrowserHistoryReader();
        return reader.getMostVisited(10);
    }

    private String replaceTitle(String title) {
        title = title.toLowerCase().contains("inbox (") ? "Email" : title;
        title = title.toLowerCase().contains("amazon") ? "Amazon" : title;
        title = title.toLowerCase().contains("youtube") ? "YouTube" : title;
        title = title.toLowerCase().contains("split self") ? "this Minecraft mod on Modrinth" : title;
        title = title.toLowerCase().contains("split-self") ? "this Minecraft mod on Github" : title;
        return title;
    }

    public static class HistoryEntry {
        public String url;
        public String title;
        public long visitTime;
        public int visitCount;
        public String browser;

        public HistoryEntry(String url, String title, long visitTime, int visitCount, String browser) {
            this.url = url;
            this.title = title;
            this.visitTime = visitTime;
            this.visitCount = visitCount;
            this.browser = browser;
        }

        public String toString() {
            return String.format("%s/split/%s/split/%s/split/%d", this.title, this.url, this.browser, this.visitCount);
        }
    }
}

