/*
 * Decompiled with CFR 0.152.
 */
package com.pryzmm.splitself.file;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public final class CountryLocator {
    private static volatile String LAST_ERROR = null;
    private static volatile String LAST_ENDPOINT = null;
    private static volatile String LAST_RESPONSE = null;

    private CountryLocator() {
    }

    public static CompletableFuture<Optional<String>> getCountryCodeAsync() {
        return CompletableFuture.supplyAsync(() -> {
            CountryLocator.resetDiag();
            try {
                String cc = CountryLocator.fetchOnce("http://ip-api.com/line/?fields=countryCode");
                if (cc == null || cc.isBlank()) {
                    cc = CountryLocator.fetchOnce("https://ipinfo.io/country");
                }
                if (cc != null && !(cc = cc.trim()).isEmpty() && cc.length() <= 3) {
                    return Optional.of(cc.toUpperCase(Locale.ROOT));
                }
            }
            catch (Exception e) {
                LAST_ERROR = e.getClass().getSimpleName() + ": " + e.getMessage();
            }
            return Optional.empty();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fetchOnce(String url) {
        LAST_ENDPOINT = url;
        HttpURLConnection conn = null;
        BufferedReader br = null;
        try {
            String line;
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.setRequestMethod("GET");
            conn.setDoInput(true);
            int code = conn.getResponseCode();
            if (code != 200) {
                LAST_ERROR = "HTTP " + code;
                String string = null;
                return string;
            }
            br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            LAST_RESPONSE = line = br.readLine();
            String string = line;
            return string;
        }
        catch (Exception e) {
            LAST_ERROR = e.getClass().getSimpleName() + ": " + e.getMessage();
            String string = null;
            return string;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static void resetDiag() {
        LAST_ERROR = null;
        LAST_ENDPOINT = null;
        LAST_RESPONSE = null;
    }

    public static Optional<String> lastError() {
        return Optional.ofNullable(LAST_ERROR);
    }

    public static Optional<String> lastEndpoint() {
        return Optional.ofNullable(LAST_ENDPOINT);
    }

    public static Optional<String> lastResponse() {
        return Optional.ofNullable(LAST_RESPONSE);
    }
}

