/*
 * Decompiled with CFR 0.152.
 */
package com.pryzmm.splitself.file;

import com.pryzmm.splitself.SplitSelf;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.swing.filechooser.FileSystemView;
import net.minecraft.class_2960;

public class DesktopFileUtil {
    public static void createFileOnDesktop(String fileName, String content) {
        File desktop = FileSystemView.getFileSystemView().getHomeDirectory();
        File file = new File(desktop, fileName);
        try {
            boolean created;
            if (!file.exists() && !(created = file.createNewFile())) {
                SplitSelf.LOGGER.error("File already exists or failed to create: " + file.getAbsolutePath());
            }
            try (FileWriter writer = new FileWriter(file, false);){
                writer.write(content);
                SplitSelf.LOGGER.info("File written successfully: " + file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            SplitSelf.LOGGER.error("Failed to create or write to file: " + file.getAbsolutePath());
        }
    }

    public String getTextFromResourceFile(String path) {
        try {
            class_2960 resourceId = class_2960.method_60655((String)"splitself", (String)path);
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("data/" + resourceId.method_12836() + "/" + resourceId.method_12832());
            if (inputStream == null) {
                SplitSelf.LOGGER.error("Resource not found: {}", (Object)resourceId);
                return null;
            }
            StringBuilder content = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    content.append(line).append("\n");
                }
            }
            return content.toString();
        }
        catch (IOException e) {
            SplitSelf.LOGGER.error("Error reading resource", (Throwable)e);
            return null;
        }
    }
}

