/*
 * Decompiled with CFR 0.152.
 */
package com.pryzmm.splitself.file;

import com.pryzmm.splitself.SplitSelf;
import com.pryzmm.splitself.entity.custom.TheOtherEntity;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_4184;
import net.minecraft.class_5498;
import net.minecraft.class_6367;
import net.minecraft.class_757;
import net.minecraft.class_761;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class EntityScreenshotCapture {
    private final class_310 client = class_310.method_1551();
    private class_761 worldRenderer;
    private Method renderWorldMethod;
    private boolean isIrisPresent = false;
    private Object irisApi = null;

    public EntityScreenshotCapture() {
        this.checkForIris();
        this.initializeReflection();
    }

    private void checkForIris() {
        try {
            Class.forName("net.irisshaders.iris.Iris");
            this.isIrisPresent = true;
            SplitSelf.LOGGER.info("IRIS shader mod detected - using compatibility mode");
            this.tryInitializeIrisApi();
        }
        catch (ClassNotFoundException e) {
            this.isIrisPresent = false;
            SplitSelf.LOGGER.info("IRIS not detected - using standard rendering");
        }
    }

    private void tryInitializeIrisApi() {
        try {
            Class<?> irisApiClass = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            Method getInstanceMethod = irisApiClass.getMethod("getInstance", new Class[0]);
            this.irisApi = getInstanceMethod.invoke(null, new Object[0]);
            SplitSelf.LOGGER.info("IRIS API initialized successfully");
        }
        catch (Exception e) {
            SplitSelf.LOGGER.warn("Could not initialize IRIS API: " + e.getMessage());
        }
    }

    private void initializeReflection() {
        try {
            Method[] methods;
            this.worldRenderer = this.client.field_1769;
            if (this.worldRenderer == null) {
                Field worldRendererField = class_310.class.getDeclaredField("worldRenderer");
                worldRendererField.setAccessible(true);
                this.worldRenderer = (class_761)worldRendererField.get(this.client);
            }
            Class<?> worldRendererClass = this.worldRenderer.getClass();
            for (Method method : methods = worldRendererClass.getDeclaredMethods()) {
                String methodName = method.getName();
                Class<?>[] paramTypes = method.getParameterTypes();
                if (!methodName.equals("render") || paramTypes.length != 7 || !paramTypes[0].getSimpleName().equals("RenderTickCounter") || paramTypes[1] != Boolean.TYPE || !paramTypes[2].getSimpleName().equals("Camera") || !paramTypes[3].getSimpleName().equals("GameRenderer") || !paramTypes[4].getSimpleName().equals("LightmapTextureManager") || !paramTypes[5].getSimpleName().equals("Matrix4f") || !paramTypes[6].getSimpleName().equals("Matrix4f")) continue;
                method.setAccessible(true);
                this.renderWorldMethod = method;
                SplitSelf.LOGGER.info("Found correct WorldRenderer.render method with 7 parameters");
                break;
            }
            if (this.renderWorldMethod != null) {
                SplitSelf.LOGGER.info("WorldRenderer reflection initialized successfully");
            } else {
                SplitSelf.LOGGER.warn("Could not find correct WorldRenderer.render method");
            }
        }
        catch (Exception e) {
            SplitSelf.LOGGER.error("Failed to initialize WorldRenderer reflection", (Throwable)e);
        }
    }

    public void captureFromEntity(class_1297 entity, int width, int height, Consumer<File> callback) {
        if (this.client.field_1687 == null || this.client.field_1724 == null || entity == null) {
            callback.accept(null);
            return;
        }
        this.client.execute(() -> {
            if (this.isIrisPresent) {
                this.captureWithIrisCompatibility(entity, width, height, callback);
            } else {
                this.captureStandard(entity, width, height, callback);
            }
        });
    }

    private void captureWithIrisCompatibility(class_1297 entity, int width, int height, Consumer<File> callback) {
        SplitSelf.LOGGER.info("Using IRIS-compatible capture method");
        try {
            Method isShaderPackInUseMethod;
            Boolean shadersActive;
            if (this.irisApi != null && (shadersActive = (Boolean)(isShaderPackInUseMethod = this.irisApi.getClass().getMethod("isShaderPackInUse", new Class[0])).invoke(this.irisApi, new Object[0])).booleanValue()) {
                Method disableShaderPackMethod = this.irisApi.getClass().getMethod("reload", new Class[0]);
                SplitSelf.LOGGER.info("Attempting to temporarily work around IRIS shaders");
            }
        }
        catch (Exception e) {
            SplitSelf.LOGGER.debug("Could not manage IRIS shaders: " + e.getMessage());
        }
        try {
            this.captureUsingMainFramebuffer(entity, width, height, callback);
        }
        catch (Exception e) {
            SplitSelf.LOGGER.warn("Main framebuffer approach failed: " + e.getMessage());
            this.captureWithMinimalRendering(entity, width, height, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureUsingMainFramebuffer(class_1297 entity, int width, int height, Consumer<File> callback) {
        class_276 originalFramebuffer = this.client.method_1522();
        class_5498 originalPerspective = this.client.field_1690.method_31044();
        class_1297 originalCameraEntity = this.client.method_1560();
        int[] viewport = new int[4];
        GL11.glGetIntegerv((int)2978, (int[])viewport);
        try {
            this.client.field_1690.method_31043(class_5498.field_26665);
            this.client.method_1504(entity);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            class_4184 camera = this.client.field_1773.method_19418();
            float tickDelta = this.client.method_60646().method_60637(false);
            camera.method_19321((class_1922)this.client.field_1687, entity, false, false, tickDelta);
            originalFramebuffer.method_1234(width, height, class_310.field_1703);
            originalFramebuffer.method_1235(true);
            GL11.glViewport((int)0, (int)0, (int)width, (int)height);
            GL11.glClearColor((float)0.5f, (float)0.8f, (float)1.0f, (float)1.0f);
            GL11.glClear((int)16640);
            class_757 gameRenderer = this.client.field_1773;
            gameRenderer.method_3188(this.client.method_60646());
            GL11.glFlush();
            originalFramebuffer.method_1240();
            this.saveScreenshot(originalFramebuffer, entity, callback);
        }
        catch (Exception e) {
            SplitSelf.LOGGER.error("Main framebuffer capture failed", (Throwable)e);
            callback.accept(null);
        }
        finally {
            try {
                this.client.method_1504(originalCameraEntity);
                this.client.field_1690.method_31043(originalPerspective);
                originalFramebuffer.method_1234(this.client.method_22683().method_4489(), this.client.method_22683().method_4506(), class_310.field_1703);
                originalFramebuffer.method_1235(true);
                GL11.glViewport((int)viewport[0], (int)viewport[1], (int)viewport[2], (int)viewport[3]);
            }
            catch (Exception e) {
                SplitSelf.LOGGER.error("Cleanup failed", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureWithMinimalRendering(class_1297 entity, int width, int height, Consumer<File> callback) {
        SplitSelf.LOGGER.info("Using minimal rendering approach for IRIS compatibility");
        class_6367 customFramebuffer = null;
        class_5498 originalPerspective = this.client.field_1690.method_31044();
        class_1297 originalCameraEntity = this.client.method_1560();
        try {
            customFramebuffer = new class_6367(width, height, true, class_310.field_1703);
            customFramebuffer.method_1236(0.5f, 0.8f, 1.0f, 1.0f);
            customFramebuffer.method_1235(true);
            GL11.glViewport((int)0, (int)0, (int)width, (int)height);
            GL11.glClear((int)16640);
            this.client.field_1690.method_31043(class_5498.field_26665);
            this.client.method_1504(entity);
            this.renderBasicEntityView(entity, width, height);
            GL11.glFlush();
            customFramebuffer.method_1240();
            this.client.method_1522().method_1235(true);
            GL11.glViewport((int)0, (int)0, (int)this.client.method_22683().method_4489(), (int)this.client.method_22683().method_4506());
            this.saveScreenshot((class_276)customFramebuffer, entity, callback);
        }
        catch (Exception e) {
            SplitSelf.LOGGER.error("Minimal rendering capture failed", (Throwable)e);
            callback.accept(null);
        }
        finally {
            try {
                this.client.method_1504(originalCameraEntity);
                this.client.field_1690.method_31043(originalPerspective);
                if (customFramebuffer != null) {
                    customFramebuffer.method_1238();
                }
            }
            catch (Exception e) {
                SplitSelf.LOGGER.error("Minimal rendering cleanup failed", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureStandard(class_1297 entity, int width, int height, Consumer<File> callback) {
        class_276 originalFramebuffer = this.client.method_1522();
        class_5498 originalPerspective = this.client.field_1690.method_31044();
        class_1297 originalCameraEntity = this.client.method_1560();
        class_6367 customFramebuffer = null;
        try {
            customFramebuffer = new class_6367(width, height, true, class_310.field_1703);
            customFramebuffer.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
            this.client.field_1690.method_31043(class_5498.field_26665);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            customFramebuffer.method_1235(true);
            GL11.glViewport((int)0, (int)0, (int)width, (int)height);
            GL11.glClearColor((float)0.5f, (float)0.8f, (float)1.0f, (float)1.0f);
            GL11.glClear((int)16640);
            boolean renderingSuccessful = false;
            try {
                this.client.method_1504(entity);
                class_4184 camera = this.client.field_1773.method_19418();
                float tickDelta = this.client.method_60646().method_60637(false);
                camera.method_19321((class_1922)this.client.field_1687, entity, false, false, tickDelta);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                class_757 gameRenderer = this.client.field_1773;
                Matrix4f projectionMatrix = gameRenderer.method_22973((double)tickDelta);
                gameRenderer.method_22709(projectionMatrix);
                gameRenderer.method_3188(this.client.method_60646());
                renderingSuccessful = true;
            }
            catch (Exception e) {
                SplitSelf.LOGGER.warn("Standard gameRenderer approach failed: " + e.getMessage());
            }
            finally {
                this.client.method_1504(originalCameraEntity);
            }
            if (!renderingSuccessful) {
                this.renderSimpleWorld(entity.method_19538());
            }
            GL11.glFlush();
            customFramebuffer.method_1240();
            this.client.method_1504(originalCameraEntity);
            this.client.field_1690.method_31043(originalPerspective);
            originalFramebuffer.method_1235(true);
            GL11.glViewport((int)0, (int)0, (int)this.client.method_22683().method_4489(), (int)this.client.method_22683().method_4506());
            this.saveScreenshot((class_276)customFramebuffer, entity, callback);
        }
        catch (Exception e) {
            SplitSelf.LOGGER.error("Standard capture failed", (Throwable)e);
            callback.accept(null);
        }
        finally {
            try {
                this.client.method_1504(originalCameraEntity);
                this.client.field_1690.method_31043(originalPerspective);
                if (originalFramebuffer != null) {
                    originalFramebuffer.method_1235(true);
                    GL11.glViewport((int)0, (int)0, (int)this.client.method_22683().method_4489(), (int)this.client.method_22683().method_4506());
                }
                if (customFramebuffer != null) {
                    customFramebuffer.method_1238();
                }
            }
            catch (Exception e) {
                SplitSelf.LOGGER.error("Standard cleanup failed", (Throwable)e);
            }
        }
    }

    private void renderBasicEntityView(class_1297 entity, int width, int height) {
        class_243 entityPos = entity.method_19538();
        float entityYaw = entity.method_36454();
        float entityPitch = entity.method_36455();
        float eyeHeight = entity.method_5751();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        float fov = 70.0f;
        float aspectRatio = (float)width / (float)height;
        float near = 0.1f;
        float far = 256.0f;
        double fH = Math.tan(Math.toRadians((double)fov / 2.0)) * (double)near;
        double fW = fH * (double)aspectRatio;
        GL11.glFrustum((double)(-fW), (double)fW, (double)(-fH), (double)fH, (double)near, (double)far);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glRotatef((float)entityPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(entityYaw + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)((float)(-entityPos.field_1352)), (float)((float)(-(entityPos.field_1351 + (double)eyeHeight))), (float)((float)(-entityPos.field_1350)));
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2884);
        this.renderSimpleWorld(entityPos);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
    }

    private void renderSimpleWorld(class_243 entityPos) {
        try {
            GL11.glDisable((int)2884);
            GL11.glColor3f((float)0.5f, (float)0.8f, (float)1.0f);
            GL11.glBegin((int)7);
            GL11.glVertex3f((float)-1000.0f, (float)100.0f, (float)-1000.0f);
            GL11.glVertex3f((float)1000.0f, (float)100.0f, (float)-1000.0f);
            GL11.glVertex3f((float)1000.0f, (float)100.0f, (float)1000.0f);
            GL11.glVertex3f((float)-1000.0f, (float)100.0f, (float)1000.0f);
            GL11.glEnd();
            GL11.glEnable((int)2884);
            GL11.glColor3f((float)0.2f, (float)0.7f, (float)0.2f);
            GL11.glBegin((int)7);
            for (int x = -50; x < 50; x += 5) {
                for (int z = -50; z < 50; z += 5) {
                    float y = 64.0f;
                    GL11.glVertex3f((float)x, (float)y, (float)z);
                    GL11.glVertex3f((float)(x + 5), (float)y, (float)z);
                    GL11.glVertex3f((float)(x + 5), (float)y, (float)(z + 5));
                    GL11.glVertex3f((float)x, (float)y, (float)(z + 5));
                }
            }
            GL11.glEnd();
            GL11.glColor3f((float)0.6f, (float)0.4f, (float)0.2f);
            GL11.glBegin((int)7);
            for (int i = 0; i < 3; ++i) {
                float x = (float)(entityPos.field_1352 + (double)((i - 1) * 5));
                float z = (float)(entityPos.field_1350 + 10.0);
                float y = 65.0f;
                GL11.glVertex3f((float)x, (float)(y + 1.0f), (float)z);
                GL11.glVertex3f((float)(x + 1.0f), (float)(y + 1.0f), (float)z);
                GL11.glVertex3f((float)(x + 1.0f), (float)(y + 1.0f), (float)(z + 1.0f));
                GL11.glVertex3f((float)x, (float)(y + 1.0f), (float)(z + 1.0f));
            }
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        catch (Exception e) {
            SplitSelf.LOGGER.debug("Simple world rendering issues: " + e.getMessage());
        }
    }

    private void saveScreenshot(class_276 framebuffer, class_1297 entity, Consumer<File> callback) {
        try {
            String filename = "hello_" + entity.method_5845().substring(0, 8) + "_" + System.currentTimeMillis() + ".png";
            File screenshotsDir = new File(this.client.field_1697, "screenshots");
            if (!screenshotsDir.exists()) {
                screenshotsDir.mkdirs();
            }
            class_318.method_22690((File)this.client.field_1697, (String)filename, (class_276)framebuffer, text -> {
                File screenshotFile = new File(screenshotsDir, filename);
                if (screenshotFile.exists()) {
                    SplitSelf.LOGGER.info("Screenshot saved: " + screenshotFile.getAbsolutePath());
                    callback.accept(screenshotFile);
                } else {
                    File[] files = screenshotsDir.listFiles((dir, name) -> name.startsWith("hello_") && name.endsWith(".png"));
                    if (files != null && files.length > 0) {
                        File mostRecent = files[0];
                        for (File file : files) {
                            if (file.lastModified() <= mostRecent.lastModified()) continue;
                            mostRecent = file;
                        }
                        SplitSelf.LOGGER.info("Found recent screenshot: " + mostRecent.getAbsolutePath());
                        callback.accept(mostRecent);
                    } else {
                        SplitSelf.LOGGER.warn("No screenshot files found");
                        callback.accept(null);
                    }
                }
            });
        }
        catch (Exception e) {
            SplitSelf.LOGGER.error("Failed to save screenshot: " + e.getMessage());
            callback.accept(null);
        }
    }

    public void capture(Consumer<File> fileCallback) {
        if (this.client.field_1687 == null || this.client.field_1724 == null) {
            return;
        }
        TheOtherEntity nearestEntity = this.client.field_1687.method_8390(TheOtherEntity.class, this.client.field_1724.method_5829().method_1014(100.0), class_1309::method_5805).stream().min((e1, e2) -> Double.compare(this.client.field_1724.method_5858((class_1297)e1), this.client.field_1724.method_5858((class_1297)e2))).orElse(null);
        if (nearestEntity != null) {
            int width = this.client.method_22683().method_4489();
            int height = this.client.method_22683().method_4506();
            class_243 entityPos = nearestEntity.method_19538();
            float entityYaw = nearestEntity.method_36454();
            float entityPitch = nearestEntity.method_36455();
            SplitSelf.LOGGER.info(String.format("Capturing from TheOtherEntity at %.2f, %.2f, %.2f (yaw: %.1f, pitch: %.1f)", entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, Float.valueOf(entityYaw), Float.valueOf(entityPitch)));
            this.captureFromEntity((class_1297)nearestEntity, width, height, file -> {
                if (file != null && this.client.field_1724 != null) {
                    fileCallback.accept((File)file);
                }
            });
        } else if (this.client.field_1724 != null) {
            SplitSelf.LOGGER.info("No TheOtherEntity found nearby (within 100 blocks)");
        }
    }
}

