/*
 * Decompiled with CFR 0.152.
 */
package com.pryzmm.splitself.file;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pryzmm.splitself.config.DefaultConfig;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;

public class JsonReader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path configPath;
    private static JsonObject jsonObject;

    public JsonReader(String fileName) {
        this.configPath = FabricLoader.getInstance().getConfigDir().resolve(fileName);
        this.loadOrCreateConfig();
    }

    private void loadOrCreateConfig() {
        if (Files.exists(this.configPath, new LinkOption[0])) {
            try (FileReader reader = new FileReader(this.configPath.toFile());){
                JsonElement element = JsonParser.parseReader((Reader)reader);
                if (element.isJsonObject()) {
                    jsonObject = element.getAsJsonObject();
                    this.fillMissingDefaults();
                    this.removeNonDefaultKeys();
                } else {
                    this.createDefaultConfig();
                }
            }
            catch (Exception e) {
                System.err.println("Error reading config file, creating new one: " + e.getMessage());
                this.createDefaultConfig();
            }
        } else {
            this.createDefaultConfig();
        }
    }

    public static Set<String> getKeysFromObject(String objectKey) {
        if (jsonObject.has(objectKey) && jsonObject.get(objectKey).isJsonObject()) {
            return jsonObject.getAsJsonObject(objectKey).keySet();
        }
        return new HashSet<String>();
    }

    private void createDefaultConfig() {
        jsonObject = new JsonObject();
        this.copyDefaultsToJson();
        this.saveConfig();
    }

    private void fillMissingDefaults() {
        Field[] fields;
        boolean hasChanges = false;
        for (Field field : fields = DefaultConfig.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                String fieldName = field.getName();
                Object defaultValue = field.get(null);
                if (!jsonObject.has(fieldName)) {
                    this.addValueToJson(fieldName, defaultValue);
                    hasChanges = true;
                    continue;
                }
                if (!(defaultValue instanceof Map)) continue;
                Map defaultMap = (Map)defaultValue;
                JsonObject existingMapJson = jsonObject.getAsJsonObject(fieldName);
                for (Map.Entry entry : defaultMap.entrySet()) {
                    if (existingMapJson.has((String)entry.getKey())) continue;
                    this.addValueToJson(existingMapJson, (String)entry.getKey(), entry.getValue());
                    hasChanges = true;
                }
            }
            catch (IllegalAccessException e) {
                System.err.println("Could not access field: " + field.getName());
            }
        }
        if (hasChanges) {
            this.saveConfig();
        }
    }

    private void removeNonDefaultKeys() {
        Field[] fields;
        boolean hasChanges = false;
        HashSet<String> validKeys = new HashSet<String>();
        for (Field field : fields = DefaultConfig.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            validKeys.add(field.getName());
        }
        HashSet<String> keysToRemove = new HashSet<String>();
        for (String key : jsonObject.keySet()) {
            if (validKeys.contains(key)) continue;
            keysToRemove.add(key);
            hasChanges = true;
        }
        for (String key : keysToRemove) {
            jsonObject.remove(key);
            System.out.println("Removed invalid config key: " + key);
        }
        for (Field field : fields) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                String fieldName = field.getName();
                Object defaultValue = field.get(null);
                if (!(defaultValue instanceof Map) || !jsonObject.has(fieldName) || !jsonObject.get(fieldName).isJsonObject()) continue;
                Map defaultMap = (Map)defaultValue;
                JsonObject configMapJson = jsonObject.getAsJsonObject(fieldName);
                HashSet<String> invalidMapKeys = new HashSet<String>();
                for (String configKey : configMapJson.keySet()) {
                    if (defaultMap.containsKey(configKey)) continue;
                    invalidMapKeys.add(configKey);
                    hasChanges = true;
                }
                for (String invalidKey : invalidMapKeys) {
                    configMapJson.remove(invalidKey);
                    System.out.println("Removed invalid key '" + invalidKey + "' from " + fieldName);
                }
            }
            catch (IllegalAccessException e) {
                System.err.println("Could not access field: " + field.getName());
            }
        }
        if (hasChanges) {
            this.saveConfig();
            System.out.println("Config cleaned up - removed non-default keys");
        }
    }

    private void copyDefaultsToJson() {
        Field[] fields;
        for (Field field : fields = DefaultConfig.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                String fieldName = field.getName();
                Object value = field.get(null);
                this.addValueToJson(fieldName, value);
            }
            catch (IllegalAccessException e) {
                System.err.println("Could not access field: " + field.getName());
            }
        }
    }

    private void addValueToJson(String key, Object value) {
        this.addValueToJson(jsonObject, key, value);
    }

    private void addValueToJson(JsonObject target, String key, Object value) {
        if (value == null) {
            target.add(key, (JsonElement)JsonNull.INSTANCE);
        } else if (value instanceof String) {
            target.addProperty(key, (String)value);
        } else if (value instanceof Number) {
            target.addProperty(key, (Number)value);
        } else if (value instanceof Boolean) {
            target.addProperty(key, (Boolean)value);
        } else if (value instanceof Map) {
            JsonObject mapObject = new JsonObject();
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                this.addValueToJson(mapObject, (String)entry.getKey(), entry.getValue());
            }
            target.add(key, (JsonElement)mapObject);
        } else {
            target.add(key, GSON.toJsonTree(value));
        }
    }

    public void saveConfig() {
        try {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(this.configPath.toFile());){
                GSON.toJson((JsonElement)jsonObject, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Error saving config file: " + e.getMessage());
        }
    }

    public static String getString(String key) {
        return JsonReader.getString(key, "");
    }

    public static String getString(String key, String defaultValue) {
        if (jsonObject.has(key) && !jsonObject.get(key).isJsonNull()) {
            return jsonObject.get(key).getAsString();
        }
        return defaultValue;
    }

    public static int getInt(String key, int defaultValue) {
        if (jsonObject.has(key) && !jsonObject.get(key).isJsonNull()) {
            return jsonObject.get(key).getAsInt();
        }
        return defaultValue;
    }

    public static double getDouble(String key, double defaultValue) {
        if (jsonObject.has(key) && !jsonObject.get(key).isJsonNull()) {
            return jsonObject.get(key).getAsDouble();
        }
        return defaultValue;
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        if (jsonObject.has(key) && !jsonObject.get(key).isJsonNull()) {
            return jsonObject.get(key).getAsBoolean();
        }
        return defaultValue;
    }

    public <T> Map<String, T> getMap(String key, Class<T> valueType) {
        if (jsonObject.has(key) && jsonObject.get(key).isJsonObject()) {
            JsonObject mapObject = jsonObject.getAsJsonObject(key);
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry entry : mapObject.entrySet()) {
                JsonElement element = (JsonElement)entry.getValue();
                Object value = null;
                if (valueType == String.class && element.isJsonPrimitive()) {
                    value = element.getAsString();
                } else if (valueType == Integer.class && element.isJsonPrimitive()) {
                    value = element.getAsInt();
                } else if (valueType == Boolean.class && element.isJsonPrimitive()) {
                    value = element.getAsBoolean();
                } else if (valueType == Double.class && element.isJsonPrimitive()) {
                    value = element.getAsDouble();
                }
                if (value == null) continue;
                result.put((String)entry.getKey(), value);
            }
            return result;
        }
        return new HashMap();
    }

    public static Object getValueFromArray(String arrayID, String configKey) {
        JsonObject array;
        if (jsonObject.has(arrayID) && jsonObject.get(arrayID).isJsonObject() && (array = jsonObject.getAsJsonObject(arrayID)).has(configKey)) {
            return array.get(configKey);
        }
        return 0;
    }

    public static Boolean getBooleanFromArray(String arrayID, String configKey) {
        JsonObject array;
        if (jsonObject.has(arrayID) && jsonObject.get(arrayID).isJsonObject() && (array = jsonObject.getAsJsonObject(arrayID)).has(configKey)) {
            return array.get(configKey).getAsBoolean();
        }
        return false;
    }

    public void setInt(String key, int value) {
        jsonObject.addProperty(key, (Number)value);
    }

    public void setDouble(String key, double value) {
        jsonObject.addProperty(key, (Number)value);
    }

    public void setString(String key, String value) {
        jsonObject.addProperty(key, value);
    }

    public void setBoolean(String key, boolean value) {
        jsonObject.addProperty(key, Boolean.valueOf(value));
    }

    public void setIntInObject(String arrayKey, String configKey, int value) {
        JsonObject object = this.getOrCreateObject(arrayKey);
        object.addProperty(configKey, (Number)value);
    }

    public void setDoubleInObject(String arrayKey, String configKey, double value) {
        JsonObject object = this.getOrCreateObject(arrayKey);
        object.addProperty(configKey, (Number)value);
    }

    public void setBooleanInObject(String arrayKey, String configKey, boolean value) {
        JsonObject object = this.getOrCreateObject(arrayKey);
        object.addProperty(configKey, Boolean.valueOf(value));
    }

    private JsonObject getOrCreateObject(String key) {
        if (!jsonObject.has(key) || !jsonObject.get(key).isJsonObject()) {
            jsonObject.add(key, (JsonElement)new JsonObject());
        }
        return jsonObject.getAsJsonObject(key);
    }
}

