/*
 * Decompiled with CFR 0.152.
 */
package com.pryzmm.splitself.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.pryzmm.splitself.SplitSelf;
import com.pryzmm.splitself.world.DataTracker;
import java.text.DateFormat;
import java.util.Date;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_9779;

public class EmergencyOverlayRenderer {
    public static boolean overlayVisible = false;
    private static String currentCity = "";
    private static boolean callbackRegistered = false;
    private static long startTime = 0L;
    private static final double SCROLL_SPEED = 150.0;
    public static long lastShakeUpdate = 0L;
    static int shakeX;
    static int shakeY;
    static DataTracker tracker;
    public static final class_2960 OVERLAY_IMAGE;

    public static void toggleOverlay(class_1657 player, String city) {
        overlayVisible = !overlayVisible;
        currentCity = city;
        if (overlayVisible) {
            startTime = System.currentTimeMillis();
        }
        tracker = DataTracker.getServerState(player.method_5682());
        if (!callbackRegistered) {
            HudRenderCallback.EVENT.register(EmergencyOverlayRenderer::renderHud);
            callbackRegistered = true;
        }
    }

    private static void renderHud(class_332 drawContext, class_9779 tickCounter) {
        if (overlayVisible) {
            EmergencyOverlayRenderer.renderTopLayerOverlay(drawContext, currentCity);
        }
    }

    public static void renderTopLayerOverlay(class_332 drawContext, String city) {
        class_310 client = class_310.method_1551();
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, 1000.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.polygonOffset((float)-1.0f, (float)-1.0f);
        RenderSystem.enablePolygonOffset();
        drawContext.method_25294(0, 0, screenWidth, screenHeight, -16777216);
        EmergencyOverlayRenderer.renderOverlayContent(drawContext, screenWidth, screenHeight, city);
        RenderSystem.disablePolygonOffset();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        matrices.method_22909();
    }

    public static void renderOverlayContent(class_332 drawContext, int screenWidth, int screenHeight, String city) {
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        EmergencyOverlayRenderer.renderImageOverlay(drawContext, screenWidth, screenHeight);
        String overlayText = SplitSelf.translate("events.splitself.emergency.notice", new Object[0]).getString();
        int titleY = screenHeight / 3;
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_22905(2.0f, 2.0f, 1.0f);
        int titleWidth = textRenderer.method_1727(overlayText);
        int titleX = (screenWidth - titleWidth * 2) / 4;
        int scaledTitleY = titleY / 2;
        drawContext.method_25303(textRenderer, overlayText, titleX, scaledTitleY, 0xFFFFFF);
        matrices.method_22909();
        if (!tracker.getPlayerPII(client.field_1724.method_5667())) {
            city = SplitSelf.translate("events.splitself.redacted_name", new Object[0]).getString();
        }
        String smallerText = SplitSelf.translate("events.splitself.emergency.message", city, DateFormat.getTimeInstance().format(new Date(System.currentTimeMillis())), city).getString();
        int smallerTextY = titleY + 100;
        int smallerTextWidth = textRenderer.method_1727(smallerText);
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - startTime;
        double scrollOffset = (double)elapsedTime / 1000.0 * 150.0;
        int scrollX = (int)((double)screenWidth - scrollOffset);
        if (scrollX + smallerTextWidth < 0) {
            startTime = currentTime;
        }
        drawContext.method_25303(textRenderer, smallerText, scrollX, smallerTextY, 0xFFFFFF);
    }

    public static void renderImageOverlay(class_332 drawContext, int screenWidth, int screenHeight) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)((float)(Math.random() / 10.0 + 0.9)), (float)((float)(Math.random() / 10.0 + 0.9)), (float)((float)(Math.random() / 10.0 + 0.9)), (float)1.0f);
        long currentTime2 = System.currentTimeMillis();
        if (currentTime2 - lastShakeUpdate >= 10L) {
            shakeX = -((int)(Math.random() * 50.0));
            shakeY = -((int)(Math.random() * 50.0));
            lastShakeUpdate = currentTime2;
        }
        drawContext.method_25290(OVERLAY_IMAGE, shakeX, shakeY, 0.0f, 0.0f, screenWidth + 50, screenHeight + 50, screenWidth, screenHeight);
        RenderSystem.disableBlend();
    }

    static {
        OVERLAY_IMAGE = class_2960.method_60655((String)"splitself", (String)"textures/screen/overlay.png");
    }
}

