/*
 * Decompiled with CFR 0.152.
 */
package com.pryzmm.splitself.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class FrozenOverlayRenderer {
    public static boolean overlayVisible = false;
    private static final Map<String, class_2960> loadedTextures = new HashMap<String, class_2960>();

    public static void toggleOverlay(File image) {
        overlayVisible = !overlayVisible;
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            if (overlayVisible) {
                FrozenOverlayRenderer.renderTopLayerOverlay(drawContext, image);
            }
        });
    }

    public static void renderTopLayerOverlay(class_332 drawContext, File image) {
        class_310 client = class_310.method_1551();
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, 1000.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.polygonOffset((float)-1.0f, (float)-1.0f);
        RenderSystem.enablePolygonOffset();
        drawContext.method_25294(0, 0, screenWidth, screenHeight, Integer.MIN_VALUE);
        FrozenOverlayRenderer.renderOverlayContent(drawContext, screenWidth, screenHeight, image);
        RenderSystem.disablePolygonOffset();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        matrices.method_22909();
    }

    public static void renderOverlayContent(class_332 drawContext, int imageWidth, int imageHeight, File image) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)((float)(Math.random() / 5.0)), (float)((float)(Math.random() / 5.0)), (float)1.0f);
        class_2960 textureId = FrozenOverlayRenderer.getOrLoadTexture(image);
        if (textureId != null) {
            drawContext.method_25290(textureId, 0, 0, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public static class_2960 getOrLoadTexture(File file) {
        String filePath = file.getAbsolutePath();
        if (loadedTextures.containsKey(filePath)) {
            return loadedTextures.get(filePath);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            class_1011 nativeImage = class_1011.method_4309((InputStream)fileInputStream);
            fileInputStream.close();
            class_1043 texture = new class_1043(nativeImage);
            String filename = file.getName();
            String nameWithoutExtension = filename.replaceAll("\\.[^.]*$", "");
            Object cleanName = nameWithoutExtension.toLowerCase().replaceAll("[^a-z0-9._-]", "_");
            if (!((String)cleanName).matches("^[a-z0-9_].*")) {
                cleanName = "dynamic_" + (String)cleanName;
            }
            String uniqueName = "dynamic/" + (String)cleanName + "_" + System.currentTimeMillis();
            class_2960 textureId = class_2960.method_60655((String)"splitself", (String)uniqueName);
            class_310.method_1551().method_1531().method_4616(textureId, (class_1044)texture);
            loadedTextures.put(filePath, textureId);
            return textureId;
        }
        catch (IOException e) {
            System.err.println("Failed to load texture from file: " + file.getAbsolutePath());
            e.printStackTrace();
            return null;
        }
    }
}

