/*
 * Decompiled with CFR 0.152.
 */
package com.pryzmm.splitself.world;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class DataTracker
extends class_18 {
    private Set<UUID> joinedPlayers = new HashSet<UUID>();
    private Map<UUID, Boolean> playerPII = new HashMap<UUID, Boolean>();
    private Map<UUID, Boolean> playerReadWarning = new HashMap<UUID, Boolean>();
    private Map<UUID, Integer> playerSleepStage = new HashMap<UUID, Integer>();

    public DataTracker() {
    }

    public DataTracker(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2499 playerList = nbt.method_10554("JoinedPlayers", 8);
        for (int i = 0; i < playerList.size(); ++i) {
            String uuidString = playerList.method_10608(i);
            try {
                this.joinedPlayers.add(UUID.fromString(uuidString));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        class_2487 piiData = nbt.method_10562("PIIData");
        for (Object key : piiData.method_10541()) {
            try {
                this.playerPII.put(UUID.fromString((String)key), piiData.method_10577((String)key));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        class_2487 SleepStageData = nbt.method_10562("SleepStageData");
        for (String key : SleepStageData.method_10541()) {
            try {
                this.playerSleepStage.put(UUID.fromString(key), SleepStageData.method_10550(key));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        class_2487 warningData = nbt.method_10562("ReadWarningData");
        for (String key : warningData.method_10541()) {
            try {
                this.playerReadWarning.put(UUID.fromString(key), warningData.method_10577(key));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2499 playerList = new class_2499();
        for (UUID uUID : this.joinedPlayers) {
            playerList.add((Object)class_2519.method_23256((String)uUID.toString()));
        }
        nbt.method_10566("JoinedPlayers", (class_2520)playerList);
        class_2487 piiData = new class_2487();
        for (Map.Entry<UUID, Boolean> entry : this.playerPII.entrySet()) {
            piiData.method_10556(entry.getKey().toString(), entry.getValue().booleanValue());
        }
        nbt.method_10566("PIIData", (class_2520)piiData);
        class_2487 class_24872 = new class_2487();
        for (Map.Entry<UUID, Boolean> entry : this.playerReadWarning.entrySet()) {
            class_24872.method_10556(entry.getKey().toString(), entry.getValue().booleanValue());
        }
        nbt.method_10566("ReadWarningData", (class_2520)class_24872);
        class_2487 class_24873 = new class_2487();
        for (Map.Entry<UUID, Integer> entry : this.playerSleepStage.entrySet()) {
            class_24873.method_10569(entry.getKey().toString(), entry.getValue().intValue());
        }
        nbt.method_10566("SleepStageData", (class_2520)class_24873);
        return nbt;
    }

    public boolean hasJoinedBefore(UUID playerUuid) {
        return this.joinedPlayers.contains(playerUuid);
    }

    public void markAsJoined(UUID playerUuid) {
        this.joinedPlayers.add(playerUuid);
        this.method_80();
    }

    public boolean getPlayerPII(UUID playerUuid) {
        return this.playerPII.getOrDefault(playerUuid, false);
    }

    public void setPlayerPII(UUID playerUuid, boolean pii) {
        this.playerPII.put(playerUuid, pii);
        this.method_80();
    }

    public Integer getPlayerSleepStage(UUID playerUuid) {
        return this.playerSleepStage.getOrDefault(playerUuid, 0);
    }

    public void setPlayerSleepStage(UUID playerUuid, Integer sleepStage) {
        this.playerSleepStage.put(playerUuid, sleepStage);
        this.method_80();
    }

    public boolean getPlayerReadWarning(UUID playerUuid) {
        return this.playerReadWarning.getOrDefault(playerUuid, false);
    }

    public void setPlayerReadWarning(UUID playerUuid, boolean readWarning) {
        this.playerReadWarning.put(playerUuid, readWarning);
        this.method_80();
    }

    public static DataTracker getServerState(MinecraftServer server) {
        class_26 persistentStateManager = server.method_3847(class_1937.field_25179).method_17983();
        return (DataTracker)persistentStateManager.method_17924(new class_18.class_8645(DataTracker::new, DataTracker::new, null), "first_join_tracker");
    }
}

