/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import melonslise.locks.client.gui.sprite.SpringSprite;
import melonslise.locks.client.gui.sprite.Sprite;
import melonslise.locks.client.gui.sprite.TextureInfo;
import melonslise.locks.client.gui.sprite.action.AccelerateAction;
import melonslise.locks.client.gui.sprite.action.FadeAction;
import melonslise.locks.client.gui.sprite.action.IAction;
import melonslise.locks.client.gui.sprite.action.MoveAction;
import melonslise.locks.client.gui.sprite.action.WaitAction;
import melonslise.locks.container.LockPickingContainer;
import melonslise.locks.network.LocksNetwork;
import melonslise.locks.network.server.TryPin;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class LockPickingScreen
extends class_465<LockPickingContainer> {
    public static final class_2561 HINT = class_2561.method_43471((String)"locks.gui.lockpicking.open");
    public final TextureInfo FRONT_WALL_TEX;
    public final TextureInfo COLUMN_TEX;
    public final TextureInfo INNER_WALL_TEX;
    public final TextureInfo BACK_WALL_TEX;
    public final TextureInfo HANDLE_TEX;
    public final TextureInfo UPPER_PIN_TEX;
    public final TextureInfo LOCK_PICK_TEX;
    public final TextureInfo[] PIN_TUMBLER_TEX;
    public final TextureInfo[] SPRING_TEX;
    protected class_2960 lockTex;
    protected class_2960 pickTex;
    protected Collection<Sprite> sprites;
    protected Sprite lockPick;
    protected Sprite leftPickPart;
    protected Sprite rightPickPart;
    protected Sprite[] pinTumblers;
    protected Sprite[] upperPins;
    protected Sprite[] springs;
    public final BiConsumer<IAction<Sprite>, Sprite> unfreezeCb;
    public final BiConsumer<IAction<Sprite>, Sprite> resetPickCb;
    public final int length;
    public final boolean[] pins;
    public final class_1268 hand;
    protected int currPin;
    protected boolean frozen;

    public LockPickingScreen(LockPickingContainer cont, class_1661 inv, class_2561 title) {
        super((class_1703)cont, inv, title);
        this.FRONT_WALL_TEX = new TextureInfo(6, 0, 4, 60, 48, 80, this.lockTex);
        this.COLUMN_TEX = new TextureInfo(10, 0, 8, 60, 48, 80, this.lockTex);
        this.INNER_WALL_TEX = new TextureInfo(18, 0, 4, 60, 48, 80, this.lockTex);
        this.BACK_WALL_TEX = new TextureInfo(22, 0, 4, 60, 48, 80, this.lockTex);
        this.HANDLE_TEX = new TextureInfo(26, 0, 19, 73, 48, 80, this.lockTex);
        this.UPPER_PIN_TEX = new TextureInfo(0, 0, 6, 8, 48, 80, this.lockTex);
        this.LOCK_PICK_TEX = new TextureInfo(0, 0, 190, 12, 190, 16, this.pickTex);
        this.PIN_TUMBLER_TEX = new TextureInfo[]{new TextureInfo(0, 8, 6, 11, 48, 80, this.lockTex), new TextureInfo(0, 19, 6, 13, 48, 80, this.lockTex), new TextureInfo(0, 32, 6, 15, 48, 80, this.lockTex)};
        this.SPRING_TEX = new TextureInfo[]{new TextureInfo(0, 57, 6, 23, 48, 80, this.lockTex), new TextureInfo(6, 60, 6, 20, 48, 80, this.lockTex), new TextureInfo(12, 64, 6, 16, 48, 80, this.lockTex), new TextureInfo(18, 69, 6, 11, 48, 80, this.lockTex), new TextureInfo(24, 73, 6, 7, 48, 80, this.lockTex)};
        this.unfreezeCb = (action, sprite) -> {
            this.frozen = false;
        };
        this.resetPickCb = (action, sprite) -> this.resetPick();
        this.frozen = true;
        this.length = cont.getLength();
        this.pins = new boolean[this.length];
        this.hand = cont.hand;
        this.lockTex = LockPickingScreen.getTextureFor(cont.lock.getLock());
        this.field_2792 = (this.FRONT_WALL_TEX.width + this.length * (this.COLUMN_TEX.width + this.INNER_WALL_TEX.width)) * 2;
        this.field_2779 = this.HANDLE_TEX.height * 2;
        this.sprites = new ArrayDeque<Sprite>(this.length * 3 + 4);
        this.pinTumblers = new Sprite[this.length];
        this.upperPins = new Sprite[this.length];
        this.springs = new Sprite[this.length];
        for (int a = 0; a < this.pinTumblers.length; ++a) {
            int r = ThreadLocalRandom.current().nextInt(3);
            this.pinTumblers[a] = this.addSprite(new Sprite(this.PIN_TUMBLER_TEX[r]).position(this.FRONT_WALL_TEX.width + 1 + a * (this.COLUMN_TEX.width + this.INNER_WALL_TEX.width), 43 - this.PIN_TUMBLER_TEX[r].height));
            this.upperPins[a] = new Sprite(this.UPPER_PIN_TEX).position(this.FRONT_WALL_TEX.width + 1 + a * (this.COLUMN_TEX.width + this.INNER_WALL_TEX.width), 43 - this.PIN_TUMBLER_TEX[r].height - this.UPPER_PIN_TEX.height);
            this.springs[a] = this.addSprite(new SpringSprite(this.SPRING_TEX, this.upperPins[a]).position(this.FRONT_WALL_TEX.width + 1 + a * (this.COLUMN_TEX.width + this.INNER_WALL_TEX.width), 3.0f));
            this.addSprite(this.upperPins[a]);
        }
        this.lockPick = this.addSprite(new Sprite(this.LOCK_PICK_TEX).position(0.0f, -4 + this.COLUMN_TEX.height - this.LOCK_PICK_TEX.height));
        this.resetPick();
        this.rightPickPart = this.addSprite(new Sprite(new TextureInfo(0, 0, 0, 12, 193, 16, this.pickTex)).position(-10.0f, this.lockPick.posY).alpha(0.0f));
        this.leftPickPart = this.addSprite(new Sprite(new TextureInfo(0, 0, 0, 12, 195, 16, this.pickTex)).position(0.0f, this.lockPick.posY).rotation(-24.5f, -10.0f, this.lockPick.posY + 13.0f).alpha(0.0f));
    }

    public static class_2960 getTextureFor(class_1799 stack) {
        return new class_2960("locks", "textures/gui/" + class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832() + ".png");
    }

    public Sprite addSprite(Sprite sprite) {
        this.sprites.add(sprite);
        return sprite;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.method_25420(pGuiGraphics);
        super.method_25394(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    protected void method_25426() {
        super.method_25426();
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        float pt = this.field_22787.method_1488();
        int cornerX = (this.field_22789 - this.field_2792) / 2;
        int cornerY = (this.field_22790 - this.field_2779) / 2;
        class_4587 mtx = guiGraphics.method_51448();
        mtx.method_22903();
        mtx.method_46416((float)cornerX, (float)cornerY, 0.0f);
        mtx.method_22905(2.0f, 2.0f, 2.0f);
        this.FRONT_WALL_TEX.draw(guiGraphics, 0.0f, 0.0f, 1.0f, this.lockTex);
        for (int a = 0; a < this.length; ++a) {
            this.COLUMN_TEX.draw(guiGraphics, this.FRONT_WALL_TEX.width + a * (this.COLUMN_TEX.width + this.INNER_WALL_TEX.width), 0.0f, 1.0f, this.lockTex);
            if (a == this.length - 1) continue;
            this.INNER_WALL_TEX.draw(guiGraphics, this.FRONT_WALL_TEX.width + this.COLUMN_TEX.width + a * (this.COLUMN_TEX.width + this.INNER_WALL_TEX.width), 0.0f, 1.0f, this.lockTex);
        }
        this.BACK_WALL_TEX.draw(guiGraphics, this.length * (this.COLUMN_TEX.width + this.INNER_WALL_TEX.width), 0.0f, 1.0f, this.lockTex);
        this.HANDLE_TEX.draw(guiGraphics, this.BACK_WALL_TEX.width + this.length * (this.COLUMN_TEX.width + this.INNER_WALL_TEX.width), 2.0f, 1.0f, this.lockTex);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        for (Sprite sprite : this.sprites) {
            if (sprite == this.lockPick || sprite == this.rightPickPart || sprite == this.leftPickPart) {
                sprite.draw(guiGraphics, pt, this.pickTex);
                continue;
            }
            sprite.draw(guiGraphics, pt, this.lockTex);
        }
        mtx.method_22909();
    }

    protected void method_2388(class_332 guiGraphics, int pMouseX, int pMouseY) {
        Objects.requireNonNull(this.field_22793);
        guiGraphics.method_27535(this.field_22793, this.field_22785, 0, -9, 0xFFFFFF);
        if (((LockPickingContainer)this.method_17577()).isOpen()) {
            guiGraphics.method_27535(this.field_22793, HINT, (this.field_2792 - this.field_22793.method_27525((class_5348)HINT)) / 2, this.field_2779 + 10, 0xFFFFFF);
        }
    }

    public void method_37432() {
        super.method_37432();
        for (Sprite sprite : this.sprites) {
            sprite.update();
        }
        if (!this.frozen) {
            this.boundLockPick();
        }
        this.updatePickParts();
    }

    protected void updatePickParts() {
        this.rightPickPart.posY = this.lockPick.posY;
        this.rightPickPart.tex.width = 10 + (int)this.lockPick.posX + this.lockPick.tex.width;
        this.rightPickPart.tex.startX = this.rightPickPart.tex.canvasWidth - this.rightPickPart.tex.width;
        this.leftPickPart.posY = this.lockPick.posY;
        this.leftPickPart.tex.width = this.rightPickPart.tex.startX;
        this.leftPickPart.posX = -10 - this.leftPickPart.tex.width;
    }

    protected void boundLockPick() {
        this.lockPick.posX = (float)(10 - this.LOCK_PICK_TEX.width) + class_3532.method_15363((float)(this.lockPick.posX - 10.0f + (float)this.LOCK_PICK_TEX.width), (float)0.0f, (float)((this.length - 1) * (this.COLUMN_TEX.width + this.INNER_WALL_TEX.width)));
    }

    public boolean method_25404(int key, int scan, int modifier) {
        if (this.frozen) {
            return super.method_25404(key, scan, modifier);
        }
        if (key == this.field_22787.field_1690.field_1913.field_1655.method_1444()) {
            this.lockPick.speedX = -4.0f;
        } else if (key == this.field_22787.field_1690.field_1849.field_1655.method_1444()) {
            this.lockPick.speedX = 4.0f;
        } else if (key == this.field_22787.field_1690.field_1894.field_1655.method_1444() && !this.lockPick.isExecuting() && this.pullPin(this.getSelectedPin())) {
            this.lockPick.execute(MoveAction.at(0.0f, -2.5f).time(3), MoveAction.at(0.0f, 2.5f).time(3));
        }
        return super.method_25404(key, scan, modifier);
    }

    public boolean method_16803(int key, int scan, int modifier) {
        if (this.frozen) {
            return super.method_16803(key, scan, modifier);
        }
        if (key == this.field_22787.field_1690.field_1913.field_1655.method_1444() || key == this.field_22787.field_1690.field_1849.field_1655.method_1444()) {
            this.lockPick.speedX = 0.0f;
        }
        return super.method_16803(key, scan, modifier);
    }

    protected int getSelectedPin() {
        return (int)((this.lockPick.posX - 10.0f + (float)this.LOCK_PICK_TEX.width) / (float)(this.COLUMN_TEX.width + this.INNER_WALL_TEX.width) + 0.5f);
    }

    protected boolean pullPin(int pin) {
        if (this.pins[pin]) {
            return false;
        }
        this.currPin = pin;
        LocksNetwork.CHANNEL.clientHandle().send((Record)new TryPin(pin));
        return true;
    }

    public void handlePin(boolean correct, boolean reset) {
        this.pinTumblers[this.currPin].execute(MoveAction.at(0.0f, -6.0f).time(2), MoveAction.at(0.0f, 6.0f).time(2));
        this.upperPins[this.currPin].execute(MoveAction.at(0.0f, -6.0f).time(2));
        if (correct) {
            this.pins[this.currPin] = true;
            this.upperPins[this.currPin].execute(MoveAction.to(this.upperPins[this.currPin], this.upperPins[this.currPin].posX, 29.0f, 2));
        } else {
            this.upperPins[this.currPin].execute(MoveAction.at(0.0f, 6.0f).time(2));
        }
        if (reset) {
            this.resetSpeed();
            this.reset();
        }
    }

    public void reset() {
        for (int a = 0; a < this.pins.length; ++a) {
            if (!this.pins[a]) continue;
            this.pins[a] = false;
            this.upperPins[a].execute(MoveAction.to(this.upperPins[a], this.upperPins[a].posX, this.pinTumblers[a].posY - (float)this.UPPER_PIN_TEX.height, 2));
        }
        this.lockPick.alpha(0.0f);
        this.rightPickPart.alpha(1.0f).execute(WaitAction.ticks(10), FadeAction.to(this.rightPickPart, 0.0f, 4));
        this.leftPickPart.alpha(1.0f).execute(WaitAction.ticks(10), FadeAction.to(this.rightPickPart, 0.0f, 4).then(this.resetPickCb));
        this.frozen = true;
    }

    public void resetPick() {
        this.pickTex = LockPickingScreen.getTextureFor(class_310.method_1551().field_1724.method_5998(this.hand));
        this.lockPick.position(-22 - this.LOCK_PICK_TEX.width, this.lockPick.posY).alpha(1.0f).execute(AccelerateAction.to(32.0f, 0.0f, 4, false).then(this.unfreezeCb));
    }

    public void resetSpeed() {
        for (Sprite sprite : this.sprites) {
            sprite.speedX = 0.0f;
            sprite.speedY = 0.0f;
            sprite.rotSpeed = 0.0f;
        }
    }
}

