/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.compat.jade;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import melonslise.locks.compat.jade.ILockPickHandler;
import melonslise.locks.compat.jade.LocksWailaPlugin;
import melonslise.locks.compat.jade.SimpleLockPickHandler;
import melonslise.locks.components.AbstractLocked;
import melonslise.locks.init.LocksBlockTags;
import melonslise.locks.init.LocksItems;
import melonslise.locks.item.LockPickItem;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_5250;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.SubTextElement;
import snownee.jade.util.CommonProxy;

public enum LockPickingToolProvider implements IBlockComponentProvider,
class_4013
{
    INSTANCE;

    public static final Cache<class_1799, ImmutableList<class_1799>> resultCache;
    public static final Map<String, ILockPickHandler> PICK_HANDLERS;
    private static final class_2561 CHECK;
    private static final class_2561 X;
    private static final class_241 ITEM_SIZE;

    public static ImmutableList<class_1799> getPick(class_1937 world, class_2338 pos) {
        ImmutableList.Builder tools = ImmutableList.builder();
        for (ILockPickHandler handler : PICK_HANDLERS.values()) {
            class_1799 tool = handler.test(world, pos);
            if (tool.method_7960()) continue;
            tools.add((Object)tool);
        }
        return tools.build();
    }

    public static synchronized void registerHandler(ILockPickHandler handler) {
        PICK_HANDLERS.put(handler.getName(), handler);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        class_1657 player = accessor.getPlayer();
        if (!config.get(LocksWailaPlugin.LOCK_PICKING_TOOL_CREATIVE) && (player.method_7337() || player.method_7325())) {
            return;
        }
        boolean newLine = config.get(Identifiers.MC_HARVEST_TOOL_NEW_LINE);
        List<IElement> elements = this.getText(accessor, config);
        if (elements.isEmpty()) {
            return;
        }
        elements.forEach(e -> e.message(null));
        if (newLine) {
            tooltip.add(elements);
        } else {
            elements.forEach(e -> e.align(IElement.Align.RIGHT));
            tooltip.append(0, elements);
        }
    }

    public List<IElement> getText(BlockAccessor accessor, IPluginConfig config) {
        AbstractLocked locked = AbstractLocked.getFrom(accessor.getLevel(), accessor.getPosition());
        if (locked == null) {
            return List.of();
        }
        if (locked.getLock().method_7960()) {
            return List.of();
        }
        List tools = List.of();
        try {
            tools = (List)resultCache.get((Object)locked.getLock(), () -> LockPickingToolProvider.getPick(accessor.getLevel(), accessor.getPosition()));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        if (tools.isEmpty()) {
            return List.of();
        }
        int offsetY = -3;
        boolean newLine = config.get(Identifiers.MC_HARVEST_TOOL_NEW_LINE);
        ArrayList elements = Lists.newArrayList();
        for (class_1799 tool : tools) {
            elements.add(IElementHelper.get().item(tool, 0.75f).translate(new class_241(-1.0f, (float)offsetY)).size(ITEM_SIZE).message((String)null));
        }
        if (elements.isEmpty()) {
            return elements;
        }
        elements.add(0, IElementHelper.get().spacer(newLine ? -2 : 5, newLine ? 10 : 0));
        class_1799 held = accessor.getPlayer().method_6047();
        if (!(held.method_7909() instanceof LockPickItem)) {
            return elements;
        }
        boolean canLockPick = LockPickItem.canPick(held, locked.getLock());
        IThemeHelper t = IThemeHelper.get();
        class_5250 text = canLockPick ? t.success((Object)CHECK) : t.danger((Object)X);
        elements.add(new SubTextElement((class_2561)text).translate(new class_241(-3.0f, (float)(7 + offsetY))));
        return elements;
    }

    public void method_14491(class_3300 resourceManager) {
        resultCache.invalidateAll();
    }

    public class_2960 getUid() {
        return LocksWailaPlugin.LOCK_PICKING_TOOL;
    }

    public int getDefaultPriority() {
        return -8000;
    }

    static {
        resultCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
        PICK_HANDLERS = Maps.newLinkedHashMap();
        CHECK = class_2561.method_43470((String)"\u2714");
        X = class_2561.method_43470((String)"\u2715");
        ITEM_SIZE = new class_241(10.0f, 0.0f);
        if (CommonProxy.isPhysicallyClient()) {
            LockPickingToolProvider.registerHandler(new SimpleLockPickHandler("lock_pick", LocksBlockTags.LOCKABLE, LocksItems.COPPER_LOCK_PICK, LocksItems.IRON_LOCK_PICK, LocksItems.GOLD_LOCK_PICK, LocksItems.STEEL_LOCK_PICK, LocksItems.DIAMOND_LOCK_PICK, LocksItems.NETHERITE_LOCK_PICK));
        }
    }
}

