/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.components;

import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ClientTickingComponent;
import java.util.HashMap;
import java.util.Map;
import melonslise.locks.Locks;
import melonslise.locks.components.AbstractLocked;
import melonslise.locks.init.LocksComponents;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2791;

public class ChunkLocked
implements Component,
AutoSyncedComponent,
ClientTickingComponent {
    private final Map<class_2338, AbstractLocked> locks = new HashMap<class_2338, AbstractLocked>();
    private final class_2791 provider;

    public static AbstractLocked getFrom(class_1937 level, class_2338 pos) {
        if (!Locks.CONFIG.nonBlockEntityLocking()) {
            throw new RuntimeException("Attempt to get ChunkLocked when disabled!");
        }
        class_2791 chunk = level.method_22350(pos);
        ChunkLocked chunkLocked = (ChunkLocked)chunk.getComponent(LocksComponents.CHUNK_LOCKED);
        return chunkLocked.getOrCreateLocked(pos);
    }

    public ChunkLocked(class_2791 chunk) {
        this.provider = chunk;
    }

    public void sync() {
        this.provider.method_12008(true);
        LocksComponents.CHUNK_LOCKED.sync((Object)this.provider);
    }

    public void clientTick() {
        for (Map.Entry<class_2338, AbstractLocked> entry : this.locks.entrySet()) {
            entry.getValue().clientTick();
        }
    }

    public AbstractLocked getOrCreateLocked(class_2338 pos) {
        return this.locks.computeIfAbsent(pos.method_10062(), p -> new AbstractLocked(){

            @Override
            public void sync() {
                ChunkLocked.this.sync();
            }
        });
    }

    public void readFromNbt(class_2487 tag) {
        if (!Locks.CONFIG.nonBlockEntityLocking()) {
            return;
        }
        this.locks.clear();
        class_2499 list = tag.method_10554("locks", 10);
        for (class_2520 t : list) {
            class_2487 entry = (class_2487)t;
            class_2338 pos = new class_2338(entry.method_10550("x"), entry.method_10550("y"), entry.method_10550("z"));
            AbstractLocked locked = this.getOrCreateLocked(pos);
            locked.readFromNbt(entry.method_10562("data"));
        }
    }

    public void writeToNbt(class_2487 tag) {
        if (!Locks.CONFIG.nonBlockEntityLocking()) {
            return;
        }
        class_2499 list = new class_2499();
        for (Map.Entry<class_2338, AbstractLocked> e : this.locks.entrySet()) {
            class_2338 pos = e.getKey();
            AbstractLocked locked = e.getValue();
            if (locked.getLock().method_7960()) continue;
            class_2487 entry = new class_2487();
            entry.method_10569("x", pos.method_10263());
            entry.method_10569("y", pos.method_10264());
            entry.method_10569("z", pos.method_10260());
            class_2487 data = new class_2487();
            locked.writeToNbt(data);
            entry.method_10566("data", (class_2520)data);
            list.add((Object)entry);
        }
        tag.method_10566("locks", (class_2520)list);
    }

    public Map<class_2338, AbstractLocked> getAll() {
        return this.locks;
    }
}

