/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.container;

import java.util.Random;
import melonslise.locks.client.gui.LockPickingScreen;
import melonslise.locks.components.AbstractLocked;
import melonslise.locks.init.LocksContainerTypes;
import melonslise.locks.init.LocksDamageSources;
import melonslise.locks.init.LocksEnchantments;
import melonslise.locks.init.LocksItemTags;
import melonslise.locks.init.LocksSoundEvents;
import melonslise.locks.item.LockItem;
import melonslise.locks.item.LockPickItem;
import melonslise.locks.network.LocksNetwork;
import melonslise.locks.network.client.TryPinResult;
import melonslise.locks.util.LocksUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_437;

public class LockPickingContainer
extends class_1703 {
    public static final class_2561 TITLE = class_2561.method_43471((String)"locks.gui.lockpicking.title");
    public final class_1657 player;
    public final class_1268 hand;
    public final AbstractLocked lock;
    public final class_2338 pos;
    public final int shocking;
    public final int sturdy;
    public final int complexity;
    protected int currIndex = 0;
    protected final byte[] combo;
    protected boolean locked;
    public final Random rng;
    public static final ExtendedScreenHandlerType.ExtendedFactory<LockPickingContainer> FACTORY = (id, inv, buf) -> new LockPickingContainer(id, inv.field_7546, (class_1268)buf.method_10818(class_1268.class), buf.method_10811());

    public LockPickingContainer(int id, class_1657 player, class_1268 hand, class_2338 pos) {
        super(LocksContainerTypes.LOCK_PICKING, id);
        class_1937 level = player.method_37908();
        class_2586 be = level.method_8321(pos);
        this.lock = AbstractLocked.getFrom(level, pos);
        if (this.lock == null) {
            throw new NullPointerException("Attempt to open a lockpicking container on non-blockentity");
        }
        this.player = player;
        this.hand = hand;
        this.pos = pos;
        this.rng = new Random(LockItem.getOrSetId(this.lock.getLock()));
        this.combo = this.shuffle(LockItem.getOrSetLength(this.lock.getLock()));
        this.shocking = class_1890.method_8225((class_1887)LocksEnchantments.SHOCKING, (class_1799)this.lock.getLock());
        this.sturdy = class_1890.method_8225((class_1887)LocksEnchantments.STURDY, (class_1799)this.lock.getLock());
        this.complexity = class_1890.method_8225((class_1887)LocksEnchantments.COMPLEXITY, (class_1799)this.lock.getLock());
    }

    public byte[] shuffle(int length) {
        byte[] combo = new byte[length];
        for (int a = 0; a < length; a = (int)((byte)(a + 1))) {
            combo[a] = a;
        }
        LocksUtil.shuffle(combo, this.rng);
        return combo;
    }

    public int getLength() {
        return this.combo.length;
    }

    public boolean isLockItemOpen() {
        return LockItem.isOpen(this.lock.getLock());
    }

    public void setLockItemOpen(boolean open) {
        LockItem.setOpen(this.lock.getLock(), open);
    }

    public int getPin(int index) {
        return this.combo[index];
    }

    public boolean checkPin(int index, int pin) {
        return this.getPin(index) == pin;
    }

    public boolean isValidPick(class_1799 stack) {
        return stack.method_31573(LocksItemTags.LOCK_PICKS) && LockPickItem.canPick(stack, this.complexity);
    }

    public boolean method_7597(class_1657 player) {
        return !this.isLockItemOpen() && this.isValidPick(player.method_5998(this.hand));
    }

    public boolean isOpen() {
        return this.currIndex == LockItem.getOrSetLength(this.lock.getLock());
    }

    protected void reset() {
        this.currIndex = 0;
    }

    public void tryPin(int currPin) {
        if (this.isOpen()) {
            return;
        }
        boolean correct = false;
        boolean reset = false;
        if (this.checkPin(this.currIndex, currPin)) {
            ++this.currIndex;
            correct = true;
            this.player.method_37908().method_43128(null, (double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260(), LocksSoundEvents.PIN_MATCH, class_3419.field_15245, 1.0f, 1.0f);
        } else if (this.tryBreakPick(this.player, currPin)) {
            reset = true;
            this.reset();
            if (this.shocking > 0) {
                this.player.method_5643(LocksDamageSources.getDamageSource(this.player.method_37908(), LocksDamageSources.SHOCK), (float)this.shocking * 1.5f);
                this.player.method_37908().method_43128(null, this.player.method_19538().field_1352, this.player.method_19538().field_1351, this.player.method_19538().field_1350, LocksSoundEvents.SHOCK, class_3419.field_15245, 1.0f, 1.0f);
            }
        } else {
            this.player.method_37908().method_43128(null, (double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260(), LocksSoundEvents.PIN_FAIL, class_3419.field_15245, 1.0f, 1.0f);
        }
        LocksNetwork.CHANNEL.serverHandle(this.player).send((Record)new TryPinResult(correct, reset));
    }

    @Environment(value=EnvType.CLIENT)
    public void handlePin(boolean correct, boolean reset) {
        class_437 screen = class_310.method_1551().field_1755;
        if (screen instanceof LockPickingScreen) {
            LockPickingScreen lockPickingScreen = (LockPickingScreen)screen;
            lockPickingScreen.handlePin(correct, reset);
            if (correct) {
                ++this.currIndex;
            }
            if (reset) {
                this.reset();
            }
        }
    }

    protected boolean tryBreakPick(class_1657 player, int pin) {
        class_1799 pickStack = player.method_5998(this.hand);
        float sturdyModifier = this.sturdy == 0 ? 1.0f : 0.75f + (float)this.sturdy * 0.5f;
        float ch = LockPickItem.getOrSetStrength(pickStack) / sturdyModifier;
        float ex = (1.0f - ch) * (1.0f - this.getBreakChanceMultiplier(pin));
        if (!pickStack.method_31573(LocksItemTags.LOCK_PICKS) || player.method_6051().method_43057() < ex + ch) {
            return false;
        }
        this.player.method_20236(this.hand);
        pickStack.method_7934(1);
        if (pickStack.method_7960()) {
            for (int a = 0; a < player.method_31548().method_5439(); ++a) {
                class_1799 stack = player.method_31548().method_5438(a);
                if (!this.isValidPick(stack)) continue;
                player.method_6122(this.hand, stack);
                player.method_31548().method_5441(a);
                break;
            }
        }
        return true;
    }

    protected float getBreakChanceMultiplier(int pin) {
        return Math.abs(this.getPin(this.currIndex) - pin) == 1 ? 0.33f : 1.0f;
    }

    public class_1799 method_7601(class_1657 player, int index) {
        return class_1799.field_8037;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (!this.isOpen() || this.isLockItemOpen()) {
            return;
        }
        this.player.method_37908().method_43128(player, (double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260(), LocksSoundEvents.LOCK_OPEN, class_3419.field_15245, 1.0f, 1.0f);
        this.setLockItemOpen(this.isOpen());
        this.lock.sync();
    }

    public static class Provider
    implements ExtendedScreenHandlerFactory {
        public final class_1799 lockItem;
        public final class_1268 hand;
        public final class_2338 pos;

        public Provider(class_1268 hand, class_1799 lock, class_2338 pos) {
            this.hand = hand;
            this.lockItem = lock;
            this.pos = pos;
        }

        public class_1703 createMenu(int id, class_1661 inv, class_1657 player) {
            return new LockPickingContainer(id, player, this.hand, this.pos);
        }

        public class_2561 method_5476() {
            return TITLE;
        }

        public void writeScreenOpeningData(class_3222 serverPlayer, class_2540 buf) {
            buf.method_10817((Enum)this.hand);
            buf.method_10807(this.pos);
        }
    }

    public static class HiddenSlot
    extends class_1735 {
        public HiddenSlot(class_1661 inventoryIn, int index, int xPosition, int yPosition) {
            super((class_1263)inventoryIn, index, xPosition, yPosition);
        }

        @Environment(value=EnvType.CLIENT)
        public boolean method_7682() {
            return false;
        }
    }
}

