/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.events;

import java.util.Optional;
import melonslise.locks.Locks;
import melonslise.locks.components.AbstractLocked;
import melonslise.locks.components.Locked;
import melonslise.locks.init.LocksComponents;
import melonslise.locks.init.LocksItemTags;
import melonslise.locks.init.LocksSoundEvents;
import melonslise.locks.item.LockItem;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.loot.v2.LootTableSource;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4732;
import net.minecraft.class_52;
import net.minecraft.class_60;
import org.jetbrains.annotations.Nullable;

public final class LocksEvents {
    public static final class_2561 LOCKED_MESSAGE = class_2561.method_43471((String)"locks.status.locked");
    public static final class_4732.class_3923<class_2586, Optional<AbstractLocked>> LOCK_COMBINER = new class_4732.class_3923<class_2586, Optional<AbstractLocked>>(){

        public Optional<AbstractLocked> acceptDouble(class_2586 blockEntity, class_2586 blockEntity2) {
            Locked locked = (Locked)blockEntity.getComponent(LocksComponents.LOCKED);
            if (locked.getLock().method_7960()) {
                return Optional.of((AbstractLocked)blockEntity2.getComponent(LocksComponents.LOCKED));
            }
            return Optional.of(locked);
        }

        public Optional<AbstractLocked> acceptSingle(class_2586 blockEntity) {
            return Optional.of((AbstractLocked)blockEntity.getComponent(LocksComponents.LOCKED));
        }

        public Optional<AbstractLocked> acceptNone() {
            return Optional.empty();
        }
    };

    private LocksEvents() {
    }

    public static void onLootTableLoad(class_3300 resourceManager, class_60 lootManager, class_2960 id, class_52.class_53 tableBuilder, LootTableSource source) {
    }

    public static class_1269 onRightClick(class_1657 player, class_1937 world, class_1268 hand, class_3965 result) {
        class_1838 ctx;
        class_1269 result1;
        class_2338 pos = result.method_17777();
        AbstractLocked lock = AbstractLocked.getFrom(world, pos);
        if (lock == null) {
            return class_1269.field_5811;
        }
        class_1799 itemInHand = player.method_5998(hand);
        class_1799 itemLock = lock.getLock();
        if (itemLock.method_7960()) {
            return class_1269.field_5811;
        }
        if (LockItem.isOpen(itemLock)) {
            if (Locks.CONFIG.allowRemovingLocks() && player.method_21823() && itemInHand.method_7960()) {
                world.method_8396(player, pos, class_3417.field_14567, class_3419.field_15245, 0.8f, 0.8f + player.method_6051().method_43057() * 0.4f);
                player.method_6104(hand);
                if (player instanceof class_3222) {
                    Locks.LOGGER.info("Removing lockable");
                    class_1542 itemEntity = new class_1542(world, result.method_17784().field_1352, result.method_17784().field_1351, result.method_17784().field_1350, lock.getLock());
                    itemEntity.method_6988();
                    world.method_8649((class_1297)itemEntity);
                    lock.removeLock();
                    lock.sync();
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_5811;
        }
        if ((itemInHand.method_31573(LocksItemTags.KEYS) || itemInHand.method_31573(LocksItemTags.LOCK_PICKS)) && (result1 = itemInHand.method_7981(ctx = new class_1838(world, player, hand, itemInHand, result))).method_23665()) {
            return result1;
        }
        player.method_6104(hand);
        lock.swing(20);
        world.method_8396(player, result.method_17777(), LocksSoundEvents.LOCK_RATTLE, class_3419.field_15245, 1.0f, 1.0f);
        if (Locks.CONFIG.deafMode()) {
            player.method_7353(LOCKED_MESSAGE, true);
        }
        return class_1269.field_5814;
    }

    public static boolean canBreakLockable(class_1657 player, class_1937 world, class_2338 pos, @Nullable class_2586 entity) {
        if (entity == null) {
            return true;
        }
        if (!Locks.CONFIG.protectLockables()) {
            return true;
        }
        AbstractLocked locked = AbstractLocked.getFrom(world, pos);
        if (locked == null) {
            return true;
        }
        if (player.method_7337()) {
            return true;
        }
        return locked.isOpen() != false;
    }

    public static boolean onBlockBreaking(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 entity) {
        return LocksEvents.canBreakLockable(player, world, pos, entity);
    }

    private static class_1269 onAttackBlock(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction) {
        if (player.method_7325()) {
            return class_1269.field_5811;
        }
        if (!LocksEvents.canBreakLockable(player, world, pos, world.method_8321(pos))) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static void register() {
        PlayerBlockBreakEvents.BEFORE.register(LocksEvents::onBlockBreaking);
        AttackBlockCallback.EVENT.register(LocksEvents::onAttackBlock);
        UseBlockCallback.EVENT.register(LocksEvents::onRightClick);
    }
}

