/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.item;

import java.util.List;
import melonslise.locks.components.AbstractLocked;
import melonslise.locks.init.LocksSoundEvents;
import melonslise.locks.item.LockingItem;
import melonslise.locks.util.LocksUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3419;

public class LockItem
extends LockingItem {
    public final int length;
    public final int enchantmentValue;
    public final int resistance;
    public static final String KEY_OPEN = "Open";
    public static final String KEY_LENGTH = "Length";

    public LockItem(int length, int enchVal, int resist, class_1792.class_1793 props) {
        super(props);
        this.length = length;
        this.enchantmentValue = enchVal;
        this.resistance = resist;
    }

    public static boolean isOpen(class_1799 stack) {
        return stack.method_7948().method_10577(KEY_OPEN);
    }

    public static void setOpen(class_1799 stack, boolean open) {
        stack.method_7948().method_10556(KEY_OPEN, open);
    }

    public static void toggleOpen(class_1799 stack) {
        LockItem.setOpen(stack, !LockItem.isOpen(stack));
    }

    public static byte getOrSetLength(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545(KEY_LENGTH)) {
            nbt.method_10567(KEY_LENGTH, (byte)((LockItem)stack.method_7909()).length);
        }
        return nbt.method_10571(KEY_LENGTH);
    }

    public static int getResistance(class_1799 stack) {
        return ((LockItem)stack.method_7909()).resistance;
    }

    public class_1269 method_7884(class_1838 ctx) {
        class_2338 pos;
        class_1937 world = ctx.method_8045();
        if (!LocksUtil.canLock(world, pos = ctx.method_8037())) {
            return class_1269.field_5811;
        }
        AbstractLocked lock = AbstractLocked.getFrom(world, pos);
        if (lock == null) {
            return class_1269.field_5814;
        }
        lock.setLock(ctx.method_8041());
        lock.setDirection(ctx.method_8038());
        ctx.method_8036().method_31548().method_7378(ctx.method_8041());
        lock.sync();
        return class_1269.field_5812;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!LockItem.isOpen(stack)) {
            return super.method_7836(world, player, hand);
        }
        LockItem.setOpen(stack, false);
        world.method_43128(player, player.method_23317(), player.method_23318(), player.method_23321(), LocksSoundEvents.LOCK_CLOSE, class_3419.field_15248, 1.0f, 1.0f);
        return super.method_7836(world, player, hand);
    }

    public boolean method_7870(class_1799 p_77616_1_) {
        return true;
    }

    public int method_7837() {
        return this.enchantmentValue;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> lines, class_1836 flag) {
        super.method_7851(stack, world, lines, flag);
        lines.add((class_2561)class_2561.method_43469((String)"locks.tooltip.length", (Object[])new Object[]{class_1799.field_8029.format(stack.method_7985() && stack.method_7969().method_10545(KEY_LENGTH) ? (long)stack.method_7969().method_10571(KEY_LENGTH) : (long)this.length)}).method_27692(class_124.field_1063));
    }
}

