/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sln.procedures;

import java.util.Comparator;
import java.util.List;
import net.mcreator.sln.init.SlnModGameRules;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class BansheeScreamingProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        boolean canBlockShoot = false;
        Vec3 center = new Vec3(entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_());
        List<Entity> found = world.m_6443_(Entity.class, new AABB(center, center).m_82400_(living.m_21051_(Attributes.f_22277_).m_22115_() / 2.0), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.m_20238_(center))).toList();
        for (Entity e2 : found) {
            LivingEntity livingEntity;
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                livingEntity = mob.m_5448_();
            } else {
                livingEntity = null;
            }
            if (e2 != livingEntity) continue;
            canBlockShoot = true;
            break;
        }
        if (!canBlockShoot) {
            return;
        }
        Vec3 screamCenter = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        double range = living.m_21051_(Attributes.f_22277_).m_22115_() / 2.0;
        List<Entity> targets = world.m_6443_(Entity.class, new AABB(screamCenter, screamCenter).m_82400_(range), e -> e instanceof LivingEntity && e != entity).stream().sorted(Comparator.comparingDouble(e -> e.m_20238_(screamCenter))).toList();
        for (Entity target : targets) {
            LivingEntity targetLiving;
            if (!(target instanceof LivingEntity) || (targetLiving = (LivingEntity)target).m_6336_() == MobType.f_21641_ || target.getPersistentData().m_128471_("forge:is_undead")) continue;
            Vec3 from = living.m_20299_(1.0f);
            Vec3 to = targetLiving.m_20299_(1.0f);
            BlockHitResult hit = living.m_9236_().m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)living));
            boolean blockedBySilver = false;
            if (hit.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos pos = hit.m_82425_();
                BlockState state = living.m_9236_().m_8055_(pos);
                if (state.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("sln:silver_blocks")))) {
                    boolean open = false;
                    Property property = state.m_60734_().m_49965_().m_61081_("open");
                    if (property instanceof BooleanProperty) {
                        BooleanProperty openProp = (BooleanProperty)property;
                        open = (Boolean)state.m_61143_((Property)openProp);
                    }
                    if (!open) {
                        blockedBySilver = true;
                    }
                }
            }
            if (blockedBySilver) continue;
            if (Math.random() <= 0.1) {
                targetLiving.m_6469_(new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268679_)), 2.0f);
            }
            if (!targetLiving.m_9236_().m_5776_()) {
                targetLiving.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60, 0, true, false));
                targetLiving.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 0, true, false));
                targetLiving.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 60, 0, true, false));
            }
            if (!(target instanceof ServerPlayer) || !(entity.getPersistentData().m_128459_("screaming") >= 25.0) || !(world instanceof ServerLevel)) continue;
            ServerLevel level = (ServerLevel)world;
            String sound = world.m_6106_().m_5470_().m_46207_(SlnModGameRules.LOVE_FOR_PAIN) ? "sln:banshee_scream" : "sln:banshee_mush";
            level.m_7654_().m_129892_().m_230957_(new CommandSourceStack(CommandSource.f_80164_, new Vec3(x, y, z), Vec2.f_82462_, level, 4, "", (Component)Component.m_237113_((String)""), level.m_7654_(), null).m_81324_(), "/playsound " + sound + " hostile @p ~ ~ ~ 10 1");
        }
        if (entity.getPersistentData().m_128459_("screaming") >= 25.0) {
            entity.getPersistentData().m_128347_("screaming", 0.0);
        } else {
            entity.getPersistentData().m_128347_("screaming", entity.getPersistentData().m_128459_("screaming") + 1.0);
        }
    }
}

