/*
 * Decompiled with CFR 0.152.
 */
package com.hom.even_better_burning;

import com.hom.even_better_burning.config.MyConfig;
import com.hom.even_better_burning.effects.BurningEffect;
import com.hom.even_better_burning.events.ModClientEvents;
import com.hom.even_better_burning.events.ModTooltipEvents;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.TridentItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="even_better_burning")
public class EvenBetterBurning {
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"even_better_burning");
    public static final RegistryObject<MobEffect> BURNING_EFFECT = EFFECTS.register("burning", BurningEffect::new);

    public EvenBetterBurning() {
        EFFECTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.addListener(this::OnLivingTick);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityJoinWorld);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingAttack);
        MinecraftForge.EVENT_BUS.addListener(this::onProjectileHurt);
        MinecraftForge.EVENT_BUS.register(ModClientEvents.class);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MyConfig.COMMON_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)MyConfig.CLIENT_CONFIG);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(ModTooltipEvents.class);
    }

    @SubscribeEvent
    public void OnLivingTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (player.isOnFire()) {
                if (player.hasEffect(MobEffects.FIRE_RESISTANCE) && ((Boolean)MyConfig.betterFireResistance.get()).booleanValue()) {
                    player.clearFire();
                }
                if (player.getRemainingFireTicks() > 1 && ((Boolean)MyConfig.burningIsEffect.get()).booleanValue()) {
                    player.removeEffect((Holder)BURNING_EFFECT.getHolder().get());
                    player.addEffect(new MobEffectInstance((Holder)BURNING_EFFECT.getHolder().get(), player.getRemainingFireTicks(), 0, ((Boolean)MyConfig.burningEffectAmbient.get()).booleanValue(), ((Boolean)MyConfig.burningEffectParticles.get()).booleanValue()));
                }
            } else {
                player.removeEffect((Holder)BURNING_EFFECT.getHolder().get());
            }
        }
    }

    private void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getEntity().getCommandSenderWorld().isClientSide) {
            return;
        }
        if (event.getEntity().getTags().contains("ebb_spawned")) {
            return;
        }
        event.getEntity().addTag("ebb_spawned");
        if (event.getEntity() instanceof AbstractArrow || event.getEntity() instanceof ThrownTrident || event.getEntity() instanceof ThrowableItemProjectile || event.getEntity() instanceof ThrownPotion || event.getEntity() instanceof EvokerFangs) {
            Entity shooter;
            Entity projectile = event.getEntity();
            if (((Boolean)MyConfig.arrowSpread.get()).booleanValue() && projectile instanceof AbstractArrow) {
                shooter = ((AbstractArrow)projectile).getOwner();
            } else if (((Boolean)MyConfig.tridentSpread.get()).booleanValue() && projectile instanceof ThrownTrident) {
                shooter = ((ThrownTrident)projectile).getOwner();
            } else if (((Boolean)MyConfig.snowballSpread.get()).booleanValue() && projectile instanceof ThrowableItemProjectile) {
                shooter = ((ThrowableItemProjectile)projectile).getOwner();
            } else if (((Boolean)MyConfig.potionSpread.get()).booleanValue() && projectile instanceof ThrownPotion) {
                shooter = ((ThrownPotion)projectile).getOwner();
            } else if (((Boolean)MyConfig.evokerSpread.get()).booleanValue() && projectile instanceof EvokerFangs) {
                shooter = ((EvokerFangs)projectile).getOwner();
            } else {
                return;
            }
            if (!((Boolean)MyConfig.playerSpread.get()).booleanValue() && shooter instanceof Player) {
                return;
            }
            if (shooter instanceof LivingEntity && shooter.isOnFire()) {
                if (((Boolean)MyConfig.useRegionalDifficulty.get()).booleanValue()) {
                    float regionalDifficulty = shooter.getCommandSenderWorld().getCurrentDifficultyAt(new BlockPos((Vec3i)shooter.blockPosition())).getEffectiveDifficulty();
                    Random random = new Random();
                    if (random.nextFloat() < regionalDifficulty * 0.3f) {
                        projectile.setRemainingFireTicks(20 * (int)(2.0f * regionalDifficulty));
                    }
                } else {
                    Random random = new Random();
                    if (random.nextFloat() < ((Float)MyConfig.spreadChance.get()).floatValue()) {
                        projectile.setRemainingFireTicks(20 * (Integer)MyConfig.spreadDuration.get());
                    }
                }
            }
        }
    }

    private void onProjectileHurt(LivingHurtEvent event) {
        if (event.getEntity() == null || event.getEntity().getCommandSenderWorld() == null) {
            return;
        }
        if (event.getSource().getDirectEntity() == null || event.getSource().getDirectEntity().getCommandSenderWorld() == null) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (!target.getCommandSenderWorld().isLoaded(new BlockPos((Vec3i)target.blockPosition()))) {
            return;
        }
        if (event.getSource().getDirectEntity().isOnFire()) {
            if (((Boolean)MyConfig.useRegionalDifficulty.get()).booleanValue()) {
                float regionalDifficulty = target.getCommandSenderWorld().getCurrentDifficultyAt(new BlockPos((Vec3i)target.blockPosition())).getEffectiveDifficulty();
                target.setRemainingFireTicks(20 * (int)(2.0f * regionalDifficulty));
            } else {
                target.setRemainingFireTicks(20 * (Integer)MyConfig.spreadDuration.get());
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingHurtEvent event) {
        if (event.getEntity().getCommandSenderWorld().isClientSide) {
            return;
        }
        Entity sourceEntity = event.getSource().getDirectEntity();
        if (sourceEntity == null || sourceEntity.getCommandSenderWorld() == null) {
            return;
        }
        if (!sourceEntity.getCommandSenderWorld().isLoaded(new BlockPos((Vec3i)sourceEntity.blockPosition()))) {
            return;
        }
        float regionalDifficulty = sourceEntity.getCommandSenderWorld().getCurrentDifficultyAt(new BlockPos((Vec3i)sourceEntity.blockPosition())).getEffectiveDifficulty();
        if (sourceEntity instanceof LivingEntity && sourceEntity.isOnFire()) {
            LivingEntity livingEntity = (LivingEntity)sourceEntity;
            if (((Boolean)MyConfig.unarmedOnlySpread.get()).booleanValue() && !livingEntity.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                event.setCanceled(true);
            } else if (!((Boolean)MyConfig.playerSpread.get()).booleanValue() && livingEntity instanceof Player) {
                event.setCanceled(true);
            } else if (livingEntity instanceof Zombie && livingEntity.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                event.setCanceled(true);
            } else if (livingEntity.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof BowItem || livingEntity.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof CrossbowItem) {
                event.setCanceled(true);
            } else if (livingEntity.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof BowItem || livingEntity.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof CrossbowItem) {
                event.setCanceled(true);
            } else if (livingEntity instanceof Drowned && livingEntity.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof TridentItem) {
                event.setCanceled(true);
            } else if (livingEntity instanceof Drowned && livingEntity.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof TridentItem) {
                event.setCanceled(true);
            } else if (livingEntity instanceof SnowGolem) {
                event.setCanceled(true);
            } else if (livingEntity instanceof Witch) {
                event.setCanceled(true);
            } else if (((Boolean)MyConfig.useRegionalDifficulty.get()).booleanValue()) {
                Random random = new Random();
                if (random.nextFloat() < regionalDifficulty * 0.3f) {
                    livingEntity.setRemainingFireTicks(20 * (int)(2.0f * regionalDifficulty));
                }
            } else {
                Random random = new Random();
                if (random.nextFloat() < ((Float)MyConfig.spreadChance.get()).floatValue()) {
                    livingEntity.setRemainingFireTicks(20 * (Integer)MyConfig.spreadDuration.get());
                }
            }
        }
    }
}

