/*
 * Decompiled with CFR 0.152.
 */
package com.hom.even_better_burning.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class MyConfig {
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static final ForgeConfigSpec CLIENT_CONFIG;
    public static ForgeConfigSpec.IntValue flintAndSteelDuration;
    public static ForgeConfigSpec.IntValue flintAndSteelDurability;
    public static ForgeConfigSpec.IntValue flintAndSteelCooldown;
    public static ForgeConfigSpec.BooleanValue betterFireResistance;
    public static ForgeConfigSpec.BooleanValue burningIsEffect;
    public static ForgeConfigSpec.BooleanValue burningEffectParticles;
    public static ForgeConfigSpec.BooleanValue burningEffectAmbient;
    public static ForgeConfigSpec.BooleanValue useRegionalDifficulty;
    public static ForgeConfigSpec.FloatValue spreadChance;
    public static ForgeConfigSpec.IntValue spreadDuration;
    public static ForgeConfigSpec.BooleanValue arrowSpread;
    public static ForgeConfigSpec.BooleanValue tridentSpread;
    public static ForgeConfigSpec.BooleanValue snowballSpread;
    public static ForgeConfigSpec.BooleanValue potionSpread;
    public static ForgeConfigSpec.BooleanValue evokerSpread;
    public static ForgeConfigSpec.BooleanValue playerSpread;
    public static ForgeConfigSpec.BooleanValue unarmedOnlySpread;
    public static ForgeConfigSpec.BooleanValue flintAndSteelTooltip;

    static {
        ForgeConfigSpec.Builder commonBuilder = new ForgeConfigSpec.Builder();
        commonBuilder.comment("Better Flint and Steel").push("Set values to 0 to disable them");
        flintAndSteelDuration = commonBuilder.comment(" How long does Flint and Steel ignite mobs for? (default: 7)").defineInRange("flintAndSteelDuration", 7, 0, Integer.MAX_VALUE);
        flintAndSteelDurability = commonBuilder.comment(" How much durability does igniting a mob cost? (default: 2)").defineInRange("flintAndSteelDurability", 2, 0, Integer.MAX_VALUE);
        flintAndSteelCooldown = commonBuilder.comment(" How long is the cooldown for igniting a mob? (default: 20)").defineInRange("flintAndSteelCooldown", 20, 0, Integer.MAX_VALUE);
        commonBuilder.pop();
        commonBuilder.comment("Better Burning").push("Burning status effect is purely cosmetic");
        betterFireResistance = commonBuilder.comment(" Does Fire Resistance remove burning effect? (default: true)").define("betterFireResistance", true);
        burningIsEffect = commonBuilder.comment(" Is 'Burning' displayed as a status effect? (default: true)").define("burningIsEffect", true);
        burningEffectParticles = commonBuilder.comment(" Does 'Burning' status effect have particles? (default: true)").define("burningIsEffect", true);
        burningEffectAmbient = commonBuilder.comment(" Is 'Burning' status effect ambient? (default: false)").define("burningEffectAmbient", false);
        commonBuilder.pop();
        commonBuilder.comment("Better Burning Spread").push("Burning mobs may ignite their target");
        useRegionalDifficulty = commonBuilder.comment(" Ignore 'spreadChance' and 'spreadDuration' and use regional difficulty instead? (default: true)").define("useRegionalDifficulty", true);
        spreadChance = commonBuilder.comment(" How likely are ignited mobs to inflict burning? (default: 0.3f)").defineInRange("spreadChance", 0.3f, 0.0f, 1.0f);
        spreadDuration = commonBuilder.comment(" How long burning inflicted by ignited mobs lasts? (default: 5)").defineInRange("spreadDuration", 5, 0, Integer.MAX_VALUE);
        arrowSpread = commonBuilder.comment(" Burning mobs can shoot flaming arrows? (default: true)").define("arrowSpread", true);
        tridentSpread = commonBuilder.comment(" Burning mobs can throw flaming tridents? (default: true)").define("tridentSpread", true);
        snowballSpread = commonBuilder.comment(" Burning mobs can throw flaming snowballs? (default: true)").define("snowballSpread", true);
        potionSpread = commonBuilder.comment(" Burning mobs can throw flaming potions? (default: true)").define("potionSpread", true);
        evokerSpread = commonBuilder.comment(" Burning mobs can summon flaming evoker fangs? (default: true)").define("evokerSpread", true);
        playerSpread = commonBuilder.comment(" Players can spread fire on attack? (default: false)").define("playerSpread", false);
        unarmedOnlySpread = commonBuilder.comment(" Only unarmed mobs can spread fire on attack? (default: false)").define("unarmedOnlySpread", false);
        commonBuilder.pop();
        COMMON_CONFIG = commonBuilder.build();
        ForgeConfigSpec.Builder clientBuilder = new ForgeConfigSpec.Builder();
        clientBuilder.comment("Even Better Burning").push("even_better_burning");
        flintAndSteelTooltip = clientBuilder.comment(" Does Flint and Steel have tooltip? (default: true)").define("flintAndSteelTooltip", true);
        clientBuilder.pop();
        CLIENT_CONFIG = clientBuilder.build();
    }
}

