/*
 * Decompiled with CFR 0.152.
 */
package com.hom.even_better_burning.events;

import com.hom.even_better_burning.config.MyConfig;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ModClientEvents {
    @SubscribeEvent
    public static void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        if ((Integer)MyConfig.flintAndSteelDuration.get() == 0) {
            return;
        }
        Player player = event.getEntity();
        for (InteractionHand hand : InteractionHand.values()) {
            if (player.getItemInHand(hand).getItem() != Items.FLINT_AND_STEEL) continue;
            if (player.isCrouching() || event.getTarget() instanceof Creeper) {
                return;
            }
            if (player.getCooldowns().isOnCooldown(Items.FLINT_AND_STEEL)) {
                return;
            }
            event.getTarget().setRemainingFireTicks(20 * (Integer)MyConfig.flintAndSteelDuration.get());
            if (event.getTarget() instanceof Mob) {
                ((Mob)event.getTarget()).setTarget((LivingEntity)player);
            }
            if (event.getEntity().getCommandSenderWorld().isClientSide()) {
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
                continue;
            }
            EquipmentSlot slot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            player.getItemInHand(hand).hurtAndBreak(((Integer)MyConfig.flintAndSteelDurability.get()).intValue(), (LivingEntity)player, slot);
            player.getCooldowns().addCooldown(Items.FLINT_AND_STEEL, ((Integer)MyConfig.flintAndSteelCooldown.get()).intValue());
        }
    }
}

