/*
 * Decompiled with CFR 0.152.
 */
package com.hom.even_better_burning;

import com.hom.even_better_burning.config.MyConfig;
import com.hom.even_better_burning.effects.BurningEffect;
import com.hom.even_better_burning.events.ModClientEvents;
import com.hom.even_better_burning.events.ModTooltipEvents;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.TridentItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="even_better_burning")
public class EvenBetterBurning {
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"even_better_burning");
    public static final RegistryObject<MobEffect> BURNING_EFFECT = EFFECTS.register("burning", BurningEffect::new);

    public EvenBetterBurning() {
        EFFECTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.addListener(this::OnLivingTick);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityJoinWorld);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingAttack);
        MinecraftForge.EVENT_BUS.addListener(this::onProjectileHurt);
        MinecraftForge.EVENT_BUS.register(ModClientEvents.class);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MyConfig.COMMON_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)MyConfig.CLIENT_CONFIG);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(ModTooltipEvents.class);
    }

    @SubscribeEvent
    public void OnLivingTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof Player) {
            Player player = (Player)event.getEntityLiving();
            if (player.m_6060_()) {
                if (player.m_21023_(MobEffects.f_19607_) && ((Boolean)MyConfig.betterFireResistance.get()).booleanValue()) {
                    player.m_20095_();
                }
                if (player.m_20094_() > 1 && ((Boolean)MyConfig.burningIsEffect.get()).booleanValue()) {
                    player.m_21195_((MobEffect)BURNING_EFFECT.get());
                    player.m_7292_(new MobEffectInstance((MobEffect)BURNING_EFFECT.get(), player.m_20094_(), 0, ((Boolean)MyConfig.burningEffectAmbient.get()).booleanValue(), ((Boolean)MyConfig.burningEffectParticles.get()).booleanValue()));
                }
            } else {
                player.m_21195_((MobEffect)BURNING_EFFECT.get());
            }
        }
    }

    private void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity().m_20193_().f_46443_) {
            return;
        }
        if (event.getEntity().m_19880_().contains("ebb_spawned")) {
            return;
        }
        event.getEntity().m_20049_("ebb_spawned");
        if (event.getEntity() instanceof AbstractArrow || event.getEntity() instanceof ThrownTrident || event.getEntity() instanceof ThrowableItemProjectile || event.getEntity() instanceof ThrownPotion || event.getEntity() instanceof EvokerFangs) {
            Entity shooter;
            Entity projectile = event.getEntity();
            if (((Boolean)MyConfig.arrowSpread.get()).booleanValue() && projectile instanceof AbstractArrow) {
                shooter = ((AbstractArrow)projectile).m_37282_();
            } else if (((Boolean)MyConfig.tridentSpread.get()).booleanValue() && projectile instanceof ThrownTrident) {
                shooter = ((ThrownTrident)projectile).m_37282_();
            } else if (((Boolean)MyConfig.snowballSpread.get()).booleanValue() && projectile instanceof ThrowableItemProjectile) {
                shooter = ((ThrowableItemProjectile)projectile).m_37282_();
            } else if (((Boolean)MyConfig.potionSpread.get()).booleanValue() && projectile instanceof ThrownPotion) {
                shooter = ((ThrownPotion)projectile).m_37282_();
            } else if (((Boolean)MyConfig.evokerSpread.get()).booleanValue() && projectile instanceof EvokerFangs) {
                shooter = ((EvokerFangs)projectile).m_36947_();
            } else {
                return;
            }
            if (!((Boolean)MyConfig.playerSpread.get()).booleanValue() && shooter instanceof Player) {
                return;
            }
            if (shooter instanceof LivingEntity && shooter.m_6060_()) {
                if (((Boolean)MyConfig.useRegionalDifficulty.get()).booleanValue()) {
                    float regionalDifficulty = shooter.m_20193_().m_6436_(new BlockPos((Vec3i)shooter.m_142538_())).m_19056_();
                    Random random = new Random();
                    if (random.nextFloat() < regionalDifficulty * 0.3f) {
                        projectile.m_20254_((int)(2.0f * regionalDifficulty));
                    }
                } else {
                    Random random = new Random();
                    if ((double)random.nextFloat() < (Double)MyConfig.spreadChance.get()) {
                        projectile.m_20254_(((Integer)MyConfig.spreadDuration.get()).intValue());
                    }
                }
            }
        }
    }

    private void onProjectileHurt(LivingHurtEvent event) {
        if (event.getEntityLiving() == null || event.getEntityLiving().m_20193_() == null) {
            return;
        }
        if (event.getSource().m_7640_() == null || event.getSource().m_7640_().f_19853_ == null) {
            return;
        }
        LivingEntity target = event.getEntityLiving();
        if (!target.m_20193_().m_46749_(new BlockPos((Vec3i)target.m_142538_()))) {
            return;
        }
        if (event.getSource().m_7640_().m_6060_()) {
            if (((Boolean)MyConfig.useRegionalDifficulty.get()).booleanValue()) {
                float regionalDifficulty = target.m_20193_().m_6436_(new BlockPos((Vec3i)target.m_142538_())).m_19056_();
                target.m_20254_((int)(2.0f * regionalDifficulty));
            } else {
                target.m_20254_(((Integer)MyConfig.spreadDuration.get()).intValue());
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingHurtEvent event) {
        if (event.getEntity().m_20193_().f_46443_) {
            return;
        }
        Entity sourceEntity = event.getSource().m_7640_();
        if (sourceEntity == null || sourceEntity.m_20193_() == null) {
            return;
        }
        if (!sourceEntity.m_20193_().m_46749_(new BlockPos((Vec3i)sourceEntity.m_142538_()))) {
            return;
        }
        float regionalDifficulty = sourceEntity.m_20193_().m_6436_(new BlockPos((Vec3i)sourceEntity.m_142538_())).m_19056_();
        if (sourceEntity instanceof LivingEntity && sourceEntity.m_6060_()) {
            LivingEntity livingEntity = (LivingEntity)sourceEntity;
            if (((Boolean)MyConfig.unarmedOnlySpread.get()).booleanValue() && !livingEntity.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                event.setCanceled(true);
            } else if (!((Boolean)MyConfig.playerSpread.get()).booleanValue() && livingEntity instanceof Player) {
                event.setCanceled(true);
            } else if (livingEntity instanceof Zombie && livingEntity.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                event.setCanceled(true);
            } else if (livingEntity.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof BowItem || livingEntity.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof CrossbowItem) {
                event.setCanceled(true);
            } else if (livingEntity.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof BowItem || livingEntity.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof CrossbowItem) {
                event.setCanceled(true);
            } else if (livingEntity instanceof Drowned && livingEntity.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof TridentItem) {
                event.setCanceled(true);
            } else if (livingEntity instanceof Drowned && livingEntity.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof TridentItem) {
                event.setCanceled(true);
            } else if (livingEntity instanceof SnowGolem) {
                event.setCanceled(true);
            } else if (livingEntity instanceof Witch) {
                event.setCanceled(true);
            } else if (((Boolean)MyConfig.useRegionalDifficulty.get()).booleanValue()) {
                Random random = new Random();
                if (random.nextFloat() < regionalDifficulty * 0.3f) {
                    event.getEntityLiving().m_20254_((int)(2.0f * regionalDifficulty));
                }
            } else {
                Random random = new Random();
                if ((double)random.nextFloat() < (Double)MyConfig.spreadChance.get()) {
                    event.getEntityLiving().m_20254_(((Integer)MyConfig.spreadDuration.get()).intValue());
                }
            }
        }
    }
}

