/*
 * Decompiled with CFR 0.152.
 */
package com.hom.even_better_burning;

import com.hom.even_better_burning.config.MyConfig;
import com.hom.even_better_burning.effects.BurningEffect;
import com.hom.even_better_burning.events.ModClientEvents;
import com.hom.even_better_burning.events.ModTooltipEvents;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.EvokerFangsEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.TridentItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="even_better_burning")
public class EvenBetterBurning {
    public static final DeferredRegister<Effect> EFFECTS = new DeferredRegister(ForgeRegistries.POTIONS, "even_better_burning");
    public static final RegistryObject<Effect> BURNING_EFFECT = EFFECTS.register("burning", BurningEffect::new);

    public EvenBetterBurning() {
        EFFECTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.addListener(this::OnLivingTick);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityJoinWorld);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingAttack);
        MinecraftForge.EVENT_BUS.addListener(this::onProjectileHurt);
        MinecraftForge.EVENT_BUS.register(ModClientEvents.class);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, MyConfig.COMMON_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, MyConfig.CLIENT_CONFIG);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(ModTooltipEvents.class);
    }

    @SubscribeEvent
    public void OnLivingTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (player.func_70027_ad()) {
                if (player.func_70644_a(Effects.field_76426_n) && ((Boolean)MyConfig.betterFireResistance.get()).booleanValue()) {
                    player.func_70066_B();
                }
                try {
                    Field FIRE_FIELD = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_190534_ay");
                    if (FIRE_FIELD.getInt(player) > 1 && ((Boolean)MyConfig.burningIsEffect.get()).booleanValue()) {
                        player.func_195063_d((Effect)BURNING_EFFECT.get());
                        player.func_195064_c(new EffectInstance((Effect)BURNING_EFFECT.get(), FIRE_FIELD.getInt(player), 0, ((Boolean)MyConfig.burningEffectAmbient.get()).booleanValue(), ((Boolean)MyConfig.burningEffectParticles.get()).booleanValue()));
                    }
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
            } else {
                player.func_195063_d((Effect)BURNING_EFFECT.get());
            }
        }
    }

    private void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntity().func_184216_O().contains("ebb_spawned")) {
            return;
        }
        event.getEntity().func_184211_a("ebb_spawned");
        if (event.getEntity() instanceof AbstractArrowEntity || event.getEntity() instanceof TridentEntity || event.getEntity() instanceof ProjectileItemEntity || event.getEntity() instanceof PotionEntity || event.getEntity() instanceof EvokerFangsEntity) {
            Entity shooter;
            Entity projectile = event.getEntity();
            if (((Boolean)MyConfig.arrowSpread.get()).booleanValue() && projectile instanceof AbstractArrowEntity) {
                shooter = ((AbstractArrowEntity)projectile).func_212360_k();
            } else if (((Boolean)MyConfig.tridentSpread.get()).booleanValue() && projectile instanceof TridentEntity) {
                shooter = ((TridentEntity)projectile).func_212360_k();
            } else if (((Boolean)MyConfig.snowballSpread.get()).booleanValue() && projectile instanceof ProjectileItemEntity) {
                shooter = ((ProjectileItemEntity)projectile).func_85052_h();
            } else if (((Boolean)MyConfig.potionSpread.get()).booleanValue() && projectile instanceof PotionEntity) {
                shooter = ((PotionEntity)projectile).func_85052_h();
            } else if (((Boolean)MyConfig.evokerSpread.get()).booleanValue() && projectile instanceof EvokerFangsEntity) {
                shooter = ((EvokerFangsEntity)projectile).func_190552_j();
            } else {
                return;
            }
            if (!((Boolean)MyConfig.playerSpread.get()).booleanValue() && shooter instanceof PlayerEntity) {
                return;
            }
            if (shooter instanceof LivingEntity && shooter.func_70027_ad()) {
                if (((Boolean)MyConfig.useRegionalDifficulty.get()).booleanValue()) {
                    float regionalDifficulty = shooter.field_70170_p.func_175649_E(new BlockPos(shooter)).func_180168_b();
                    Random random = new Random();
                    if (random.nextFloat() < regionalDifficulty * 0.3f) {
                        projectile.func_70015_d((int)(2.0f * regionalDifficulty));
                    }
                } else {
                    Random random = new Random();
                    if ((double)random.nextFloat() < (Double)MyConfig.spreadChance.get()) {
                        projectile.func_70015_d(((Integer)MyConfig.spreadDuration.get()).intValue());
                    }
                }
            }
        }
    }

    private void onProjectileHurt(LivingHurtEvent event) {
        if (event.getEntityLiving() == null || event.getEntityLiving().field_70170_p == null) {
            return;
        }
        if (event.getSource().func_76364_f() == null || event.getSource().func_76364_f().field_70170_p == null) {
            return;
        }
        LivingEntity target = event.getEntityLiving();
        if (!target.field_70170_p.func_175667_e(new BlockPos((Entity)target))) {
            return;
        }
        if (event.getSource().func_76364_f().func_70027_ad()) {
            if (((Boolean)MyConfig.useRegionalDifficulty.get()).booleanValue()) {
                float regionalDifficulty = target.field_70170_p.func_175649_E(new BlockPos((Entity)target)).func_180168_b();
                target.func_70015_d((int)(2.0f * regionalDifficulty));
            } else {
                target.func_70015_d(((Integer)MyConfig.spreadDuration.get()).intValue());
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingHurtEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        Entity sourceEntity = event.getSource().func_76346_g();
        if (sourceEntity == null || sourceEntity.field_70170_p == null) {
            return;
        }
        if (!sourceEntity.field_70170_p.func_175667_e(new BlockPos(sourceEntity))) {
            return;
        }
        float regionalDifficulty = sourceEntity.field_70170_p.func_175649_E(new BlockPos(sourceEntity)).func_180168_b();
        if (sourceEntity instanceof LivingEntity && sourceEntity.func_70027_ad()) {
            LivingEntity livingEntity = (LivingEntity)sourceEntity;
            if (((Boolean)MyConfig.unarmedOnlySpread.get()).booleanValue() && !livingEntity.func_184614_ca().func_190926_b()) {
                event.setCanceled(true);
            } else if (!((Boolean)MyConfig.playerSpread.get()).booleanValue() && livingEntity instanceof PlayerEntity) {
                event.setCanceled(true);
            } else if (livingEntity instanceof ZombieEntity && livingEntity.func_184614_ca().func_190926_b()) {
                event.setCanceled(true);
            } else if (livingEntity.func_184614_ca().func_77973_b() instanceof BowItem || livingEntity.func_184614_ca().func_77973_b() instanceof CrossbowItem) {
                event.setCanceled(true);
            } else if (livingEntity.func_184592_cb().func_77973_b() instanceof BowItem || livingEntity.func_184592_cb().func_77973_b() instanceof CrossbowItem) {
                event.setCanceled(true);
            } else if (livingEntity instanceof DrownedEntity && livingEntity.func_184614_ca().func_77973_b() instanceof TridentItem) {
                event.setCanceled(true);
            } else if (livingEntity instanceof DrownedEntity && livingEntity.func_184592_cb().func_77973_b() instanceof TridentItem) {
                event.setCanceled(true);
            } else if (livingEntity instanceof SnowGolemEntity) {
                event.setCanceled(true);
            } else if (livingEntity instanceof WitchEntity) {
                event.setCanceled(true);
            } else if (((Boolean)MyConfig.useRegionalDifficulty.get()).booleanValue()) {
                Random random = new Random();
                if (random.nextFloat() < regionalDifficulty * 0.3f) {
                    event.getEntityLiving().func_70015_d((int)(2.0f * regionalDifficulty));
                }
            } else {
                Random random = new Random();
                if ((double)random.nextFloat() < (Double)MyConfig.spreadChance.get()) {
                    event.getEntityLiving().func_70015_d(((Integer)MyConfig.spreadDuration.get()).intValue());
                }
            }
        }
    }
}

