/*
 * Decompiled with CFR 0.152.
 */
package com.hom.even_better_burning;

import com.hom.even_better_burning.config.MyConfig;
import com.hom.even_better_burning.effects.BurningEffect;
import com.hom.even_better_burning.events.ModClientEvents;
import com.hom.even_better_burning.events.ModTooltipEvents;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityDrowned;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.entity.projectile.EntityTrident;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemTrident;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="even_better_burning")
public class EvenBetterBurning {
    public static Potion BURNING_EFFECT;

    public EvenBetterBurning() {
        MinecraftForge.EVENT_BUS.addListener(this::OnLivingTick);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityJoinWorld);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingAttack);
        MinecraftForge.EVENT_BUS.addListener(this::onProjectileHurt);
        MinecraftForge.EVENT_BUS.register(ModClientEvents.class);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, MyConfig.COMMON_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, MyConfig.CLIENT_CONFIG);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(ModTooltipEvents.class);
    }

    @SubscribeEvent
    public void OnLivingTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (player.func_70027_ad()) {
                int fireTicks;
                if (player.func_70644_a(MobEffects.field_76426_n) && ((Boolean)MyConfig.betterFireResistance.get()).booleanValue()) {
                    player.func_70066_B();
                }
                if ((fireTicks = ((Integer)ObfuscationReflectionHelper.getPrivateValue(Entity.class, (Object)player, (String)"field_190534_ay")).intValue()) > 1 && ((Boolean)MyConfig.burningIsEffect.get()).booleanValue()) {
                    player.func_195063_d(BURNING_EFFECT);
                    player.func_195064_c(new PotionEffect(BURNING_EFFECT, fireTicks, 0, ((Boolean)MyConfig.burningEffectAmbient.get()).booleanValue(), ((Boolean)MyConfig.burningEffectParticles.get()).booleanValue()));
                }
            } else {
                player.func_195063_d(BURNING_EFFECT);
            }
        }
    }

    private void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntity().func_184216_O().contains("ebb_spawned")) {
            return;
        }
        event.getEntity().func_184211_a("ebb_spawned");
        if (event.getEntity() instanceof EntityArrow || event.getEntity() instanceof EntityTrident || event.getEntity() instanceof EntityThrowable || event.getEntity() instanceof EntityPotion || event.getEntity() instanceof EntityEvokerFangs) {
            Entity shooter;
            Entity projectile = event.getEntity();
            if (((Boolean)MyConfig.arrowSpread.get()).booleanValue() && projectile instanceof EntityArrow) {
                shooter = EvenBetterBurning.getEntityByUUID(projectile.field_70170_p, ((EntityArrow)projectile).field_70250_c);
            } else if (((Boolean)MyConfig.tridentSpread.get()).booleanValue() && projectile instanceof EntityTrident) {
                shooter = EvenBetterBurning.getEntityByUUID(projectile.field_70170_p, ((EntityTrident)projectile).field_70250_c);
            } else if (((Boolean)MyConfig.snowballSpread.get()).booleanValue() && projectile instanceof EntityThrowable) {
                shooter = ((EntityThrowable)projectile).func_85052_h();
            } else if (((Boolean)MyConfig.potionSpread.get()).booleanValue() && projectile instanceof EntityPotion) {
                shooter = ((EntityPotion)projectile).func_85052_h();
            } else if (((Boolean)MyConfig.evokerSpread.get()).booleanValue() && projectile instanceof EntityEvokerFangs) {
                shooter = ((EntityEvokerFangs)projectile).func_190552_j();
            } else {
                return;
            }
            if (shooter == null) {
                return;
            }
            if (!((Boolean)MyConfig.playerSpread.get()).booleanValue() && shooter instanceof EntityPlayer) {
                return;
            }
            if (shooter instanceof EntityLiving && shooter.func_70027_ad()) {
                if (((Boolean)MyConfig.useRegionalDifficulty.get()).booleanValue()) {
                    float regionalDifficulty = shooter.field_70170_p.func_175649_E(new BlockPos(shooter)).func_180168_b();
                    Random random = new Random();
                    if (random.nextFloat() < regionalDifficulty * 0.3f) {
                        projectile.func_70015_d((int)(2.0f * regionalDifficulty));
                    }
                } else {
                    Random random = new Random();
                    if ((double)random.nextFloat() < (Double)MyConfig.spreadChance.get()) {
                        projectile.func_70015_d(((Integer)MyConfig.spreadDuration.get()).intValue());
                    }
                }
            }
        }
    }

    @Nullable
    private static Entity getEntityByUUID(World world, UUID uuid) {
        if (uuid == null) {
            return null;
        }
        for (Entity entity : world.field_72996_f) {
            if (!uuid.equals(entity.func_110124_au())) continue;
            return entity;
        }
        return null;
    }

    private void onProjectileHurt(LivingHurtEvent event) {
        if (event.getEntityLiving() == null || event.getEntityLiving().field_70170_p == null) {
            return;
        }
        if (event.getSource().func_76364_f() == null || event.getSource().func_76364_f().field_70170_p == null) {
            return;
        }
        EntityLivingBase target = event.getEntityLiving();
        if (!target.field_70170_p.func_175667_e(new BlockPos((Entity)target))) {
            return;
        }
        if (event.getSource().func_76364_f().func_70027_ad()) {
            if (((Boolean)MyConfig.useRegionalDifficulty.get()).booleanValue()) {
                float regionalDifficulty = target.field_70170_p.func_175649_E(new BlockPos((Entity)target)).func_180168_b();
                target.func_70015_d((int)(2.0f * regionalDifficulty));
            } else {
                target.func_70015_d(((Integer)MyConfig.spreadDuration.get()).intValue());
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingHurtEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        Entity sourceEntity = event.getSource().func_76346_g();
        if (sourceEntity == null || sourceEntity.field_70170_p == null) {
            return;
        }
        if (!sourceEntity.field_70170_p.func_175667_e(new BlockPos(sourceEntity))) {
            return;
        }
        float regionalDifficulty = sourceEntity.field_70170_p.func_175649_E(new BlockPos(sourceEntity)).func_180168_b();
        if (sourceEntity instanceof EntityLivingBase && sourceEntity.func_70027_ad()) {
            EntityLivingBase livingEntity = (EntityLivingBase)sourceEntity;
            if (((Boolean)MyConfig.unarmedOnlySpread.get()).booleanValue() && !livingEntity.func_184614_ca().func_190926_b()) {
                event.setCanceled(true);
            } else if (!((Boolean)MyConfig.playerSpread.get()).booleanValue() && livingEntity instanceof EntityPlayer) {
                event.setCanceled(true);
            } else if (livingEntity instanceof EntityZombie && livingEntity.func_184614_ca().func_190926_b()) {
                event.setCanceled(true);
            } else if (livingEntity.func_184614_ca().func_77973_b() instanceof ItemBow) {
                event.setCanceled(true);
            } else if (livingEntity.func_184592_cb().func_77973_b() instanceof ItemBow) {
                event.setCanceled(true);
            } else if (livingEntity instanceof EntityDrowned && livingEntity.func_184614_ca().func_77973_b() instanceof ItemTrident) {
                event.setCanceled(true);
            } else if (livingEntity instanceof EntityDrowned && livingEntity.func_184592_cb().func_77973_b() instanceof ItemTrident) {
                event.setCanceled(true);
            } else if (livingEntity instanceof EntitySnowman) {
                event.setCanceled(true);
            } else if (livingEntity instanceof EntityWitch) {
                event.setCanceled(true);
            } else if (((Boolean)MyConfig.useRegionalDifficulty.get()).booleanValue()) {
                Random random = new Random();
                if (random.nextFloat() < regionalDifficulty * 0.3f) {
                    event.getEntityLiving().func_70015_d((int)(2.0f * regionalDifficulty));
                }
            } else {
                Random random = new Random();
                if ((double)random.nextFloat() < (Double)MyConfig.spreadChance.get()) {
                    event.getEntityLiving().func_70015_d(((Integer)MyConfig.spreadDuration.get()).intValue());
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="even_better_burning", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModRegistries {
        @SubscribeEvent
        public static void registerPotions(RegistryEvent.Register<Potion> event) {
            BURNING_EFFECT = (Potion)new BurningEffect().setRegistryName("even_better_burning", "burning");
            event.getRegistry().register((IForgeRegistryEntry)BURNING_EFFECT);
        }
    }
}

