/*
 * Decompiled with CFR 0.152.
 */
package com.hom.even_better_burning;

import com.hom.even_better_burning.config.MyConfig;
import com.hom.even_better_burning.effects.BurningEffect;
import com.hom.even_better_burning.events.ModClientEvents;
import com.hom.even_better_burning.events.ModTooltipEvents;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemBow;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="even_better_burning", name="Even Better Burning", version="1.0")
public class EvenBetterBurning {
    public static Potion BURNING_POTION;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(ModClientEvents.class);
        MinecraftForge.EVENT_BUS.register(ModTooltipEvents.class);
        MyConfig.flintAndSteel.cooldown += 0;
    }

    @SubscribeEvent
    public void registerEffects(RegistryEvent.Register<Potion> event) {
        BURNING_POTION = ((Potion)new BurningEffect().setRegistryName("even_better_burning", "burning")).func_76390_b("effect.burning");
        event.getRegistry().register((IForgeRegistryEntry)BURNING_POTION);
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (player.func_70027_ad()) {
            if (player.func_70644_a(MobEffects.field_76426_n) && MyConfig.burning.betterFireResistance) {
                player.func_70066_B();
            }
            try {
                Field FIRE_FIELD = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_190534_ay");
                if (FIRE_FIELD.getInt(player) > 1 && MyConfig.burning.burningIsEffect) {
                    player.func_184589_d(BURNING_POTION);
                    player.func_70690_d(new PotionEffect(BURNING_POTION, FIRE_FIELD.getInt(player), 0, MyConfig.burning.burningEffectAmbient, MyConfig.burning.burningEffectParticles));
                }
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        } else {
            player.func_184589_d(BURNING_POTION);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntity().func_184216_O().contains("ebb_spawned")) {
            return;
        }
        event.getEntity().func_184211_a("ebb_spawned");
        if (event.getEntity() instanceof EntityArrow || event.getEntity() instanceof EntityThrowable || event.getEntity() instanceof EntityPotion || event.getEntity() instanceof EntityEvokerFangs) {
            Entity shooter;
            Entity projectile = event.getEntity();
            if (MyConfig.spread.arrowSpread && projectile instanceof EntityArrow) {
                shooter = ((EntityArrow)projectile).field_70250_c;
            } else if (MyConfig.spread.snowballSpread && projectile instanceof EntityThrowable) {
                shooter = ((EntityThrowable)projectile).func_85052_h();
            } else if (MyConfig.spread.potionSpread && projectile instanceof EntityPotion) {
                shooter = ((EntityPotion)projectile).func_85052_h();
            } else if (MyConfig.spread.evokerSpread && projectile instanceof EntityEvokerFangs) {
                shooter = ((EntityEvokerFangs)projectile).func_190552_j();
            } else {
                return;
            }
            if (!MyConfig.spread.playerSpread && shooter instanceof EntityPlayer) {
                return;
            }
            if (shooter instanceof EntityLiving && shooter.func_70027_ad()) {
                if (MyConfig.spread.useRegionalDifficulty) {
                    float regionalDifficulty = shooter.field_70170_p.func_175649_E(new BlockPos(shooter)).func_180168_b();
                    Random random = new Random();
                    if (random.nextFloat() < regionalDifficulty * 0.3f) {
                        projectile.func_70015_d((int)(2.0f * regionalDifficulty));
                    }
                } else {
                    Random random = new Random();
                    if (random.nextFloat() < MyConfig.spread.spreadChance) {
                        projectile.func_70015_d(MyConfig.spread.spreadDuration);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onProjectileHurt(LivingHurtEvent event) {
        if (event.getEntityLiving() == null || event.getEntityLiving().field_70170_p == null) {
            return;
        }
        if (event.getSource().func_76364_f() == null || event.getSource().func_76364_f().field_70170_p == null) {
            return;
        }
        EntityLivingBase target = event.getEntityLiving();
        if (!target.field_70170_p.func_175667_e(new BlockPos((Entity)target))) {
            return;
        }
        if (event.getSource().func_76364_f().func_70027_ad()) {
            if (MyConfig.spread.useRegionalDifficulty) {
                float regionalDifficulty = target.field_70170_p.func_175649_E(new BlockPos((Entity)target)).func_180168_b();
                target.func_70015_d((int)(2.0f * regionalDifficulty));
            } else {
                target.func_70015_d(MyConfig.spread.spreadDuration);
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingHurtEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        Entity sourceEntity = event.getSource().func_76346_g();
        if (sourceEntity == null || sourceEntity.field_70170_p == null) {
            return;
        }
        if (!sourceEntity.field_70170_p.func_175667_e(new BlockPos(sourceEntity))) {
            return;
        }
        float regionalDifficulty = sourceEntity.field_70170_p.func_175649_E(new BlockPos(sourceEntity)).func_180168_b();
        if (sourceEntity instanceof EntityLivingBase && sourceEntity.func_70027_ad()) {
            EntityLivingBase livingEntity = (EntityLivingBase)sourceEntity;
            if (MyConfig.spread.unarmedOnlySpread && !livingEntity.func_184614_ca().func_190926_b()) {
                event.setCanceled(true);
            } else if (!MyConfig.spread.playerSpread && livingEntity instanceof EntityPlayer) {
                event.setCanceled(true);
            } else if (livingEntity instanceof EntityZombie && livingEntity.func_184614_ca().func_190926_b()) {
                event.setCanceled(true);
            } else if (livingEntity.func_184614_ca().func_77973_b() instanceof ItemBow) {
                event.setCanceled(true);
            } else if (livingEntity.func_184592_cb().func_77973_b() instanceof ItemBow) {
                event.setCanceled(true);
            } else if (livingEntity instanceof EntitySnowman) {
                event.setCanceled(true);
            } else if (livingEntity instanceof EntityWitch) {
                event.setCanceled(true);
            } else if (MyConfig.spread.useRegionalDifficulty) {
                Random random = new Random();
                if (random.nextFloat() < regionalDifficulty * 0.3f) {
                    event.getEntityLiving().func_70015_d((int)(2.0f * regionalDifficulty));
                }
            } else {
                Random random = new Random();
                if (random.nextFloat() < MyConfig.spread.spreadChance) {
                    event.getEntityLiving().func_70015_d(MyConfig.spread.spreadDuration);
                }
            }
        }
    }
}

