/*
 * Decompiled with CFR 0.152.
 */
package com.warma.betterrenderdistance.compat.sodium;

import com.warma.betterrenderdistance.ClientHooks;
import com.warma.betterrenderdistance.config.BRDConfig;
import net.caffeinemc.mods.sodium.api.config.ConfigEntryPoint;
import net.caffeinemc.mods.sodium.api.config.structure.ConfigBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.ModOptionsBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.OptionBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.OptionGroupBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.OptionPageBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.PageBuilder;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlValueFormatterImpls;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public final class BetterRenderDistanceSodiumConfigEntryPoint
implements ConfigEntryPoint {
    private static final String MOD_ID = "betterrenderdistance";

    private static class_2960 key(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public void registerConfigEarly(ConfigBuilder builder) {
    }

    public void registerConfigLate(ConfigBuilder builder) {
        class_2960 autoKey = BetterRenderDistanceSodiumConfigEntryPoint.key("vertical_scale_auto");
        ModOptionsBuilder mod = builder.registerModOptions(MOD_ID).setName("BetterRenderDistance").setNonTintedIcon(class_2960.method_60655((String)MOD_ID, (String)"textures/gui/sprites/brd_logo.png"));
        OptionPageBuilder page = builder.createOptionPage().setName((class_2561)class_2561.method_43470((String)"BetterRenderDistance"));
        OptionGroupBuilder group = builder.createOptionGroup().setName((class_2561)class_2561.method_43470((String)"General"));
        group.addOption((OptionBuilder)builder.createBooleanOption(BetterRenderDistanceSodiumConfigEntryPoint.key("enabled")).setName((class_2561)class_2561.method_43470((String)"Enabled")).setTooltip((class_2561)class_2561.method_43470((String)"Enable/Disable BetterRenderDistance.")).setDefaultValue(Boolean.TRUE).setBinding(v -> {
            BRDConfig.enabled = v;
        }, () -> BRDConfig.enabled).setStorageHandler(BRDConfig::save).setApplyHook(state -> ClientHooks.onConfigApplied()));
        group.addOption((OptionBuilder)builder.createBooleanOption(autoKey).setName((class_2561)class_2561.method_43470((String)"Auto Vertical Scale")).setTooltip((class_2561)class_2561.method_43470((String)"Enables an auto preset based on render distance.")).setDefaultValue(Boolean.TRUE).setBinding(v -> {
            BRDConfig.verticalScaleAuto = v;
            if (v.booleanValue()) {
                int rd = class_310.method_1551().field_1690.method_38521();
                BRDConfig.verticalScale = BRDConfig.computeAutoVerticalScale(rd);
            } else {
                BRDConfig.verticalScale = BRDConfig.verticalScaleManual;
            }
        }, () -> BRDConfig.verticalScaleAuto).setStorageHandler(BRDConfig::save).setApplyHook(state -> ClientHooks.onConfigApplied()));
        group.addOption((OptionBuilder)builder.createEnumOption(BetterRenderDistanceSodiumConfigEntryPoint.key("vertical_scale_preset"), BRDConfig.VerticalScalePreset.class).setName((class_2561)class_2561.method_43470((String)"Preset")).setTooltip((class_2561)class_2561.method_43470((String)"Only used when Auto vertical scale is enabled.")).setDefaultValue((Enum)BRDConfig.VerticalScalePreset.BALANCED).setElementNameProvider(preset -> switch (preset) {
            default -> throw new MatchException(null, null);
            case BRDConfig.VerticalScalePreset.PERFORMANCE -> class_2561.method_43470((String)"Performance").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067});
            case BRDConfig.VerticalScalePreset.BALANCED -> class_2561.method_43470((String)"Balanced").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067});
            case BRDConfig.VerticalScalePreset.QUALITY -> class_2561.method_43470((String)"Quality").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067});
        }).setBinding(v -> {
            BRDConfig.verticalScalePreset = v;
            if (BRDConfig.verticalScaleAuto) {
                int rd = class_310.method_1551().field_1690.method_38521();
                BRDConfig.verticalScale = BRDConfig.computeAutoVerticalScale(rd);
            }
        }, () -> BRDConfig.verticalScalePreset).setEnabledProvider(state -> state.readBooleanOption(autoKey), new class_2960[]{autoKey}).setStorageHandler(BRDConfig::save).setApplyHook(state -> ClientHooks.onConfigApplied()));
        group.addOption((OptionBuilder)builder.createIntegerOption(BetterRenderDistanceSodiumConfigEntryPoint.key("vertical_scale_percent")).setName((class_2561)class_2561.method_43470((String)"Vertical scale")).setTooltip((class_2561)class_2561.method_43470((String)"Disabled when Auto vertical scale is enabled.")).setDefaultValue(Integer.valueOf(50)).setRange(5, 200, 1).setValueFormatter(ControlValueFormatterImpls.percentage()).setBinding(pct -> {
            if (BRDConfig.verticalScaleAuto) {
                return;
            }
            int p = pct;
            if (p < 5) {
                p = 5;
            }
            if (p > 200) {
                p = 200;
            }
            BRDConfig.verticalScale = BRDConfig.verticalScaleManual = (float)p / 100.0f;
        }, () -> {
            int p;
            if (BRDConfig.verticalScaleAuto) {
                int rd = class_310.method_1551().field_1690.method_38521();
                p = Math.round(BRDConfig.computeAutoVerticalScale(rd) * 100.0f);
            } else {
                p = Math.round(BRDConfig.verticalScaleManual * 100.0f);
            }
            if (p < 5) {
                p = 5;
            }
            if (p > 200) {
                p = 200;
            }
            return p;
        }).setEnabledProvider(state -> !state.readBooleanOption(autoKey), new class_2960[]{autoKey}).setStorageHandler(BRDConfig::save).setApplyHook(state -> ClientHooks.onConfigApplied()));
        page.addOptionGroup(group);
        mod.addPage((PageBuilder)page);
    }
}

