/*
 * Decompiled with CFR 0.152.
 */
package com.warma.betterrenderdistance.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;

public final class BRDConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path FILE = FabricLoader.getInstance().getConfigDir().resolve("betterrenderdistance.json");
    public static boolean enabled = true;
    public static float verticalScale = 0.5f;
    public static float verticalScaleManual = 0.5f;
    public static boolean verticalScaleAuto = true;
    public static VerticalScalePreset verticalScalePreset = VerticalScalePreset.BALANCED;
    public static float cornerShrinkHorizontal = 0.25f;
    private static boolean tickRegistered;
    private static int lastRenderDistance;
    private static VerticalScalePreset lastPreset;

    private BRDConfig() {
    }

    public static void load() {
        if (!Files.exists(FILE, new LinkOption[0])) {
            BRDConfig.save();
            BRDConfig.registerTick();
            return;
        }
        try (BufferedReader r = Files.newBufferedReader(FILE);){
            Data d = (Data)GSON.fromJson((Reader)r, Data.class);
            if (d != null) {
                float manual;
                enabled = d.enabled;
                float f = manual = Float.isFinite(d.verticalScaleManual) ? d.verticalScaleManual : d.verticalScale;
                if (!Float.isFinite(manual)) {
                    manual = 0.5f;
                }
                if (manual < 0.05f) {
                    manual = 0.05f;
                }
                if (manual > 4.0f) {
                    manual = 4.0f;
                }
                verticalScaleManual = manual;
                verticalScaleAuto = d.verticalScaleAuto;
                verticalScalePreset = d.verticalScalePreset != null ? d.verticalScalePreset : VerticalScalePreset.BALANCED;
                verticalScale = verticalScaleManual;
                float f2 = cornerShrinkHorizontal = Float.isFinite(d.cornerShrinkHorizontal) ? d.cornerShrinkHorizontal : 0.25f;
                if (cornerShrinkHorizontal < 0.0f) {
                    cornerShrinkHorizontal = 0.0f;
                }
                if (cornerShrinkHorizontal > 0.49f) {
                    cornerShrinkHorizontal = 0.49f;
                }
            }
        }
        catch (Exception ignored) {
            enabled = true;
            verticalScale = 0.5f;
            verticalScaleManual = 0.5f;
            verticalScaleAuto = false;
            verticalScalePreset = VerticalScalePreset.BALANCED;
            cornerShrinkHorizontal = 0.25f;
            BRDConfig.save();
        }
        BRDConfig.registerTick();
    }

    public static void save() {
        try {
            Files.createDirectories(FILE.getParent(), new FileAttribute[0]);
            Data d = new Data();
            d.enabled = enabled;
            d.verticalScaleManual = verticalScaleManual;
            d.verticalScale = verticalScaleManual;
            d.verticalScaleAuto = verticalScaleAuto;
            d.verticalScalePreset = verticalScalePreset;
            d.cornerShrinkHorizontal = cornerShrinkHorizontal;
            try (BufferedWriter w = Files.newBufferedWriter(FILE, new OpenOption[0]);){
                GSON.toJson((Object)d, (Appendable)w);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static float computeAutoVerticalScale(int renderDistance) {
        float v32;
        float v8;
        float vs = BRDConfig.piecewise3(renderDistance, 8, v8, 32, v32, 64, switch (verticalScalePreset.ordinal()) {
            case 0 -> {
                v8 = 0.7f;
                v32 = 0.3f;
                yield 0.2f;
            }
            case 1 -> {
                v8 = 0.8f;
                v32 = 0.5f;
                yield 0.35f;
            }
            case 2 -> {
                v8 = 1.0f;
                v32 = 0.7f;
                yield 0.5f;
            }
            default -> {
                v8 = 0.75f;
                v32 = 0.5f;
                yield 0.35f;
            }
        });
        if (vs < 0.05f) {
            vs = 0.05f;
        }
        if (vs > 4.0f) {
            vs = 4.0f;
        }
        return vs;
    }

    private static float piecewise3(int x, int x0, float y0, int x1, float y1, int x2, float y2) {
        if (x <= x0) {
            return y0;
        }
        if (x >= x2) {
            return y2;
        }
        if (x <= x1) {
            float t = (float)(x - x0) / (float)(x1 - x0);
            return BRDConfig.lerp(y0, y1, t);
        }
        float t = (float)(x - x1) / (float)(x2 - x1);
        return BRDConfig.lerp(y1, y2, t);
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private static void registerTick() {
        if (tickRegistered) {
            return;
        }
        tickRegistered = true;
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!verticalScaleAuto) {
                lastRenderDistance = Integer.MIN_VALUE;
                lastPreset = null;
                verticalScale = verticalScaleManual;
                return;
            }
            int rd = client.field_1690.method_38521();
            VerticalScalePreset p = verticalScalePreset;
            if (rd != lastRenderDistance || p != lastPreset) {
                lastRenderDistance = rd;
                lastPreset = p;
                verticalScale = BRDConfig.computeAutoVerticalScale(rd);
            }
        });
    }

    static {
        lastRenderDistance = Integer.MIN_VALUE;
        lastPreset = null;
    }

    private static final class Data {
        boolean enabled = true;
        float verticalScale = 0.5f;
        float verticalScaleManual = Float.NaN;
        boolean verticalScaleAuto = true;
        VerticalScalePreset verticalScalePreset = VerticalScalePreset.BALANCED;
        float cornerShrinkHorizontal = 0.25f;

        private Data() {
        }
    }

    public static enum VerticalScalePreset {
        PERFORMANCE,
        BALANCED,
        QUALITY;

    }
}

