/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.block;

import com.piglinmine.fastpipes.block.PipeBlock;
import com.piglinmine.fastpipes.blockentity.EnergyPipeBlockEntity;
import com.piglinmine.fastpipes.network.pipe.energy.EnergyPipeEnergyStorage;
import com.piglinmine.fastpipes.network.pipe.energy.EnergyPipeType;
import com.piglinmine.fastpipes.network.pipe.shape.PipeShapeCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyPipeBlock
extends PipeBlock
implements EntityBlock {
    private final EnergyPipeType type;

    public EnergyPipeBlock(PipeShapeCache shapeCache, EnergyPipeType type) {
        super(shapeCache);
        this.type = type;
    }

    public EnergyPipeType getType() {
        return this.type;
    }

    @Override
    protected boolean hasConnection(LevelAccessor level, BlockPos pos, Direction direction) {
        BlockEntity currentBlockEntity = level.getBlockEntity(pos);
        if (currentBlockEntity instanceof EnergyPipeBlockEntity && ((EnergyPipeBlockEntity)currentBlockEntity).getAttachmentManager().hasAttachment(direction)) {
            return false;
        }
        BlockState facingState = level.getBlockState(pos.relative(direction));
        BlockEntity facingBlockEntity = level.getBlockEntity(pos.relative(direction));
        if (facingBlockEntity instanceof EnergyPipeBlockEntity && ((EnergyPipeBlockEntity)facingBlockEntity).getAttachmentManager().hasAttachment(direction.getOpposite())) {
            return false;
        }
        return facingState.getBlock() instanceof EnergyPipeBlock && ((EnergyPipeBlock)facingState.getBlock()).getType() == this.type;
    }

    @Override
    protected boolean hasInvConnection(LevelAccessor world, BlockPos pos, Direction direction) {
        if (world instanceof Level) {
            Level level = (Level)world;
            IEnergyStorage energyStorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, pos.relative(direction), (Object)direction.getOpposite());
            if (energyStorage == null) {
                return false;
            }
            return !(energyStorage instanceof EnergyPipeEnergyStorage);
        }
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnergyPipeBlockEntity(pos, state);
    }
}

