/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.block;

import com.piglinmine.fastpipes.block.PipeBlock;
import com.piglinmine.fastpipes.blockentity.FluidPipeBlockEntity;
import com.piglinmine.fastpipes.network.pipe.fluid.FluidPipeType;
import com.piglinmine.fastpipes.network.pipe.shape.PipeShapeCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;

public class FluidPipeBlock
extends PipeBlock
implements EntityBlock {
    private final FluidPipeType type;

    public FluidPipeBlock(PipeShapeCache shapeCache, FluidPipeType type) {
        super(shapeCache);
        this.type = type;
    }

    public FluidPipeType getType() {
        return this.type;
    }

    @Override
    protected boolean hasConnection(LevelAccessor level, BlockPos pos, Direction direction) {
        BlockEntity currentBlockEntity = level.getBlockEntity(pos);
        if (currentBlockEntity instanceof FluidPipeBlockEntity && ((FluidPipeBlockEntity)currentBlockEntity).getAttachmentManager().hasAttachment(direction)) {
            return false;
        }
        BlockState facingState = level.getBlockState(pos.relative(direction));
        BlockEntity facingBlockEntity = level.getBlockEntity(pos.relative(direction));
        if (facingBlockEntity instanceof FluidPipeBlockEntity && ((FluidPipeBlockEntity)facingBlockEntity).getAttachmentManager().hasAttachment(direction.getOpposite())) {
            return false;
        }
        return facingState.getBlock() instanceof FluidPipeBlock && ((FluidPipeBlock)facingState.getBlock()).getType() == this.type;
    }

    @Override
    protected boolean hasInvConnection(LevelAccessor world, BlockPos pos, Direction direction) {
        if (world instanceof Level) {
            Level level = (Level)world;
            return level.getCapability(Capabilities.FluidHandler.BLOCK, pos.relative(direction), (Object)direction.getOpposite()) != null;
        }
        return false;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FluidPipeBlockEntity(pos, state);
    }
}

