/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.block;

import com.piglinmine.fastpipes.block.PipeBlock;
import com.piglinmine.fastpipes.blockentity.ItemPipeBlockEntity;
import com.piglinmine.fastpipes.network.pipe.item.ItemPipeType;
import com.piglinmine.fastpipes.network.pipe.shape.PipeShapeCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.jetbrains.annotations.Nullable;

public class ItemPipeBlock
extends PipeBlock
implements EntityBlock {
    private final ItemPipeType type;

    public ItemPipeBlock(PipeShapeCache shapeCache, ItemPipeType type) {
        super(shapeCache);
        this.type = type;
    }

    public ItemPipeType getType() {
        return this.type;
    }

    @Override
    protected boolean hasConnection(LevelAccessor world, BlockPos pos, Direction direction) {
        BlockEntity currentBlockEntity = world.getBlockEntity(pos);
        if (currentBlockEntity instanceof ItemPipeBlockEntity && ((ItemPipeBlockEntity)currentBlockEntity).getAttachmentManager().hasAttachment(direction)) {
            return false;
        }
        BlockState facingState = world.getBlockState(pos.relative(direction));
        BlockEntity facingBlockEntity = world.getBlockEntity(pos.relative(direction));
        if (facingBlockEntity instanceof ItemPipeBlockEntity && ((ItemPipeBlockEntity)facingBlockEntity).getAttachmentManager().hasAttachment(direction.getOpposite())) {
            return false;
        }
        return facingState.getBlock() instanceof ItemPipeBlock;
    }

    @Override
    protected boolean hasInvConnection(LevelAccessor world, BlockPos pos, Direction direction) {
        if (world instanceof Level) {
            Level level = (Level)world;
            return level.getCapability(Capabilities.ItemHandler.BLOCK, pos.relative(direction), (Object)direction.getOpposite()) != null;
        }
        return false;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ItemPipeBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? (levelTicker, pos, stateTicker, blockEntity) -> ItemPipeBlockEntity.tick((ItemPipeBlockEntity)blockEntity) : null;
    }
}

