/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.block;

import com.piglinmine.fastpipes.blockentity.PipeBlockEntity;
import com.piglinmine.fastpipes.item.AttachmentItem;
import com.piglinmine.fastpipes.network.NetworkManager;
import com.piglinmine.fastpipes.network.pipe.Pipe;
import com.piglinmine.fastpipes.network.pipe.attachment.Attachment;
import com.piglinmine.fastpipes.network.pipe.attachment.AttachmentFactory;
import com.piglinmine.fastpipes.network.pipe.attachment.AttachmentManager;
import com.piglinmine.fastpipes.network.pipe.shape.PipeShapeCache;
import com.piglinmine.fastpipes.network.pipe.shape.PipeShapeProps;
import com.piglinmine.fastpipes.util.Raytracer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class PipeBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");
    public static final BooleanProperty INV_NORTH = BooleanProperty.create((String)"inv_north");
    public static final BooleanProperty INV_EAST = BooleanProperty.create((String)"inv_east");
    public static final BooleanProperty INV_SOUTH = BooleanProperty.create((String)"inv_south");
    public static final BooleanProperty INV_WEST = BooleanProperty.create((String)"inv_west");
    public static final BooleanProperty INV_UP = BooleanProperty.create((String)"inv_up");
    public static final BooleanProperty INV_DOWN = BooleanProperty.create((String)"inv_down");
    private final PipeShapeCache shapeCache;

    public PipeBlock(PipeShapeCache shapeCache) {
        super(BlockBehaviour.Properties.of().destroyTime(0.35f).explosionResistance(0.35f));
        this.shapeCache = shapeCache;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)INV_NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)INV_EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)INV_SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)INV_WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)INV_UP, (Comparable)Boolean.valueOf(false))).setValue((Property)INV_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, INV_NORTH, INV_EAST, INV_SOUTH, INV_WEST, INV_UP, INV_DOWN});
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        Pipe pipe;
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        if (!level.isClientSide && (pipe = NetworkManager.get(level).getPipe(pos)) != null && pipe.getNetwork() != null) {
            pipe.getNetwork().scanGraph(level, pos);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        Direction dirClicked = this.getAttachmentDirectionClicked(pos, hit.getLocation());
        if (dirClicked != null) {
            PipeBlockEntity pipeBlockEntity;
            ItemStack held = player.getMainHandItem();
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (held.isEmpty() && player.isCrouching()) {
                return this.removeAttachment(level, pos, dirClicked);
            }
            if (blockEntity instanceof PipeBlockEntity && (pipeBlockEntity = (PipeBlockEntity)blockEntity).getAttachmentManager().hasAttachment(dirClicked)) {
                return this.openAttachmentContainer(player, pos, pipeBlockEntity.getAttachmentManager(), dirClicked);
            }
            if (held.getItem() instanceof AttachmentItem) {
                return this.addAttachment(player, level, pos, held, dirClicked);
            }
        }
        return InteractionResult.PASS;
    }

    private InteractionResult addAttachment(Player player, Level level, BlockPos pos, ItemStack attachment, Direction dir) {
        Pipe pipe;
        if (!level.isClientSide && (pipe = NetworkManager.get(level).getPipe(pos)) != null && !pipe.getAttachmentManager().hasAttachment(dir)) {
            AttachmentFactory type = ((AttachmentItem)attachment.getItem()).getFactory();
            if (!type.canPlaceOnPipe(this)) {
                return InteractionResult.SUCCESS;
            }
            pipe.getAttachmentManager().setAttachmentAndScanGraph(dir, type.create(pipe, dir));
            NetworkManager.get(level).setDirty();
            pipe.sendBlockUpdate();
            level.setBlockAndUpdate(pos, this.getState(level.getBlockState(pos), (LevelAccessor)level, pos));
            if (!player.isCreative()) {
                attachment.shrink(1);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult removeAttachment(Level level, BlockPos pos, Direction dir) {
        if (!level.isClientSide) {
            Pipe pipe = NetworkManager.get(level).getPipe(pos);
            if (pipe != null && pipe.getAttachmentManager().hasAttachment(dir)) {
                Attachment attachment = pipe.getAttachmentManager().getAttachment(dir);
                pipe.getAttachmentManager().removeAttachmentAndScanGraph(dir);
                NetworkManager.get(level).setDirty();
                pipe.sendBlockUpdate();
                level.setBlockAndUpdate(pos, this.getState(level.getBlockState(pos), (LevelAccessor)level, pos));
                Block.popResource((Level)level, (BlockPos)pos.relative(dir), (ItemStack)attachment.getDrop());
            }
            return InteractionResult.SUCCESS;
        }
        return ((PipeBlockEntity)level.getBlockEntity(pos)).getAttachmentManager().hasAttachment(dir) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    private InteractionResult openAttachmentContainer(Player player, BlockPos pos, AttachmentManager attachmentManager, Direction dir) {
        if (player instanceof ServerPlayer) {
            attachmentManager.openAttachmentContainer(dir, (ServerPlayer)player);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return this.getState(this.defaultBlockState(), (LevelAccessor)ctx.getLevel(), ctx.getClickedPos());
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return this.getState(state, world, pos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return this.shapeCache.getShape(state, world, pos, ctx);
    }

    private BlockState getState(BlockState currentState, LevelAccessor world, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)currentState.setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.hasConnection(world, pos, Direction.NORTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.hasConnection(world, pos, Direction.EAST)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.hasConnection(world, pos, Direction.SOUTH)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.hasConnection(world, pos, Direction.WEST)))).setValue((Property)UP, (Comparable)Boolean.valueOf(this.hasConnection(world, pos, Direction.UP)))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(this.hasConnection(world, pos, Direction.DOWN)))).setValue((Property)INV_NORTH, (Comparable)Boolean.valueOf(this.hasInvConnection(world, pos, Direction.NORTH)))).setValue((Property)INV_EAST, (Comparable)Boolean.valueOf(this.hasInvConnection(world, pos, Direction.EAST)))).setValue((Property)INV_SOUTH, (Comparable)Boolean.valueOf(this.hasInvConnection(world, pos, Direction.SOUTH)))).setValue((Property)INV_WEST, (Comparable)Boolean.valueOf(this.hasInvConnection(world, pos, Direction.WEST)))).setValue((Property)INV_UP, (Comparable)Boolean.valueOf(this.hasInvConnection(world, pos, Direction.UP)))).setValue((Property)INV_DOWN, (Comparable)Boolean.valueOf(this.hasInvConnection(world, pos, Direction.DOWN)));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        Direction dirClicked = this.getAttachmentDirectionClicked(pos, target.getLocation());
        if (dirClicked != null && (blockEntity = world.getBlockEntity(pos)) instanceof PipeBlockEntity) {
            PipeBlockEntity pipeBlockEntity = (PipeBlockEntity)blockEntity;
            return pipeBlockEntity.getAttachmentManager().getPickBlock(dirClicked);
        }
        return new ItemStack((ItemLike)this);
    }

    @Nullable
    public Direction getAttachmentDirectionClicked(BlockPos pos, Vec3 hit) {
        if (Raytracer.inclusiveContains(PipeShapeProps.NORTH_ATTACHMENT_SHAPE.bounds().move(pos), hit)) {
            return Direction.NORTH;
        }
        if (Raytracer.inclusiveContains(PipeShapeProps.EAST_ATTACHMENT_SHAPE.bounds().move(pos), hit)) {
            return Direction.EAST;
        }
        if (Raytracer.inclusiveContains(PipeShapeProps.SOUTH_ATTACHMENT_SHAPE.bounds().move(pos), hit)) {
            return Direction.SOUTH;
        }
        if (Raytracer.inclusiveContains(PipeShapeProps.WEST_ATTACHMENT_SHAPE.bounds().move(pos), hit)) {
            return Direction.WEST;
        }
        if (Raytracer.inclusiveContains(PipeShapeProps.UP_ATTACHMENT_SHAPE.bounds().move(pos), hit)) {
            return Direction.UP;
        }
        if (Raytracer.inclusiveContains(PipeShapeProps.DOWN_ATTACHMENT_SHAPE.bounds().move(pos), hit)) {
            return Direction.DOWN;
        }
        return null;
    }

    protected abstract boolean hasConnection(LevelAccessor var1, BlockPos var2, Direction var3);

    protected abstract boolean hasInvConnection(LevelAccessor var1, BlockPos var2, Direction var3);
}

