/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.blockentity;

import com.piglinmine.fastpipes.FPipesBlockEntities;
import com.piglinmine.fastpipes.FPipesBlocks;
import com.piglinmine.fastpipes.blockentity.PipeBlockEntity;
import com.piglinmine.fastpipes.network.NetworkManager;
import com.piglinmine.fastpipes.network.pipe.Pipe;
import com.piglinmine.fastpipes.network.pipe.energy.ClientEnergyPipeEnergyStorage;
import com.piglinmine.fastpipes.network.pipe.energy.EnergyPipe;
import com.piglinmine.fastpipes.network.pipe.energy.EnergyPipeType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyPipeBlockEntity
extends PipeBlockEntity {
    private final EnergyPipeType type;
    private final ClientEnergyPipeEnergyStorage clientEnergyStorage;

    public EnergyPipeBlockEntity(BlockPos pos, BlockState state) {
        super(EnergyPipeBlockEntity.getBlockEntityType(state), pos, state);
        this.type = EnergyPipeBlockEntity.getEnergyPipeType(state);
        this.clientEnergyStorage = new ClientEnergyPipeEnergyStorage(this.type);
    }

    private static BlockEntityType<?> getBlockEntityType(BlockState state) {
        if (state.getBlock() == FPipesBlocks.BASIC_ENERGY_PIPE.get()) {
            return (BlockEntityType)FPipesBlockEntities.BASIC_ENERGY_PIPE.get();
        }
        if (state.getBlock() == FPipesBlocks.IMPROVED_ENERGY_PIPE.get()) {
            return (BlockEntityType)FPipesBlockEntities.IMPROVED_ENERGY_PIPE.get();
        }
        if (state.getBlock() == FPipesBlocks.ADVANCED_ENERGY_PIPE.get()) {
            return (BlockEntityType)FPipesBlockEntities.ADVANCED_ENERGY_PIPE.get();
        }
        if (state.getBlock() == FPipesBlocks.ELITE_ENERGY_PIPE.get()) {
            return (BlockEntityType)FPipesBlockEntities.ELITE_ENERGY_PIPE.get();
        }
        if (state.getBlock() == FPipesBlocks.ULTIMATE_ENERGY_PIPE.get()) {
            return (BlockEntityType)FPipesBlockEntities.ULTIMATE_ENERGY_PIPE.get();
        }
        return (BlockEntityType)FPipesBlockEntities.BASIC_ENERGY_PIPE.get();
    }

    private static EnergyPipeType getEnergyPipeType(BlockState state) {
        if (state.getBlock() == FPipesBlocks.BASIC_ENERGY_PIPE.get()) {
            return EnergyPipeType.BASIC;
        }
        if (state.getBlock() == FPipesBlocks.IMPROVED_ENERGY_PIPE.get()) {
            return EnergyPipeType.IMPROVED;
        }
        if (state.getBlock() == FPipesBlocks.ADVANCED_ENERGY_PIPE.get()) {
            return EnergyPipeType.ADVANCED;
        }
        if (state.getBlock() == FPipesBlocks.ELITE_ENERGY_PIPE.get()) {
            return EnergyPipeType.ELITE;
        }
        if (state.getBlock() == FPipesBlocks.ULTIMATE_ENERGY_PIPE.get()) {
            return EnergyPipeType.ULTIMATE;
        }
        return EnergyPipeType.BASIC;
    }

    public static void tick(EnergyPipeBlockEntity blockEntity) {
    }

    public EnergyPipeType getEnergyPipeType() {
        return this.type;
    }

    @Nullable
    public IEnergyStorage getEnergyStorage(@Nullable Direction side) {
        NetworkManager mgr;
        Pipe pipe;
        if (!this.level.isClientSide && (pipe = (mgr = NetworkManager.get(this.level)).getPipe(this.worldPosition)) instanceof EnergyPipe) {
            EnergyPipe energyPipe = (EnergyPipe)pipe;
            return energyPipe.getEnergyStorage();
        }
        return this.clientEnergyStorage;
    }

    @Override
    protected Pipe createPipe(Level level, BlockPos pos) {
        return new EnergyPipe(level, pos, this.type);
    }
}

