/*
 * Decompiled with CFR 0.152.
 */
package com.piglinmine.fastpipes.blockentity;

import com.piglinmine.fastpipes.FPipesBlockEntities;
import com.piglinmine.fastpipes.FPipesBlocks;
import com.piglinmine.fastpipes.blockentity.PipeBlockEntity;
import com.piglinmine.fastpipes.network.pipe.Pipe;
import com.piglinmine.fastpipes.network.pipe.fluid.FluidPipe;
import com.piglinmine.fastpipes.network.pipe.fluid.FluidPipeType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidPipeBlockEntity
extends PipeBlockEntity {
    private FluidPipeType type;
    private FluidStack fluid = FluidStack.EMPTY;
    private float fullness = 0.0f;
    private float renderFullness = 0.0f;

    public FluidPipeBlockEntity(BlockPos pos, BlockState state) {
        super(FluidPipeBlockEntity.getBlockEntityType(state), pos, state);
        this.type = FluidPipeBlockEntity.getFluidPipeType(state);
    }

    private static BlockEntityType<?> getBlockEntityType(BlockState state) {
        if (state.getBlock() == FPipesBlocks.BASIC_FLUID_PIPE.get()) {
            return (BlockEntityType)FPipesBlockEntities.BASIC_FLUID_PIPE.get();
        }
        if (state.getBlock() == FPipesBlocks.IMPROVED_FLUID_PIPE.get()) {
            return (BlockEntityType)FPipesBlockEntities.IMPROVED_FLUID_PIPE.get();
        }
        if (state.getBlock() == FPipesBlocks.ADVANCED_FLUID_PIPE.get()) {
            return (BlockEntityType)FPipesBlockEntities.ADVANCED_FLUID_PIPE.get();
        }
        if (state.getBlock() == FPipesBlocks.ELITE_FLUID_PIPE.get()) {
            return (BlockEntityType)FPipesBlockEntities.ELITE_FLUID_PIPE.get();
        }
        if (state.getBlock() == FPipesBlocks.ULTIMATE_FLUID_PIPE.get()) {
            return (BlockEntityType)FPipesBlockEntities.ULTIMATE_FLUID_PIPE.get();
        }
        return (BlockEntityType)FPipesBlockEntities.BASIC_FLUID_PIPE.get();
    }

    private static FluidPipeType getFluidPipeType(BlockState state) {
        if (state.getBlock() == FPipesBlocks.BASIC_FLUID_PIPE.get()) {
            return FluidPipeType.BASIC;
        }
        if (state.getBlock() == FPipesBlocks.IMPROVED_FLUID_PIPE.get()) {
            return FluidPipeType.IMPROVED;
        }
        if (state.getBlock() == FPipesBlocks.ADVANCED_FLUID_PIPE.get()) {
            return FluidPipeType.ADVANCED;
        }
        if (state.getBlock() == FPipesBlocks.ELITE_FLUID_PIPE.get()) {
            return FluidPipeType.ELITE;
        }
        if (state.getBlock() == FPipesBlocks.ULTIMATE_FLUID_PIPE.get()) {
            return FluidPipeType.ULTIMATE;
        }
        return FluidPipeType.BASIC;
    }

    public static void tick(FluidPipeBlockEntity blockEntity) {
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public float updateAndGetRenderFullness(float partialTicks) {
        float step = partialTicks * 0.05f;
        if (this.renderFullness > this.fullness) {
            this.renderFullness -= step;
            if (this.renderFullness < this.fullness) {
                this.renderFullness = this.fullness;
            }
        } else if (this.renderFullness < this.fullness) {
            this.renderFullness += step;
            if (this.renderFullness > this.fullness) {
                this.renderFullness = this.fullness;
            }
        }
        return this.renderFullness;
    }

    @Override
    public CompoundTag writeUpdate(CompoundTag tag, HolderLookup.Provider registries) {
        return super.writeUpdate(tag, registries);
    }

    @Override
    public void readUpdate(@Nullable CompoundTag tag, HolderLookup.Provider registries) {
        this.fluid = tag != null && tag.contains("fluid") ? FluidStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("fluid")) : FluidStack.EMPTY;
        if (tag != null && tag.contains("fullness")) {
            this.renderFullness = this.fullness = tag.getFloat("fullness");
        } else {
            this.fullness = 0.0f;
            this.renderFullness = 0.0f;
        }
        super.readUpdate(tag, registries);
    }

    public float getFullness() {
        return this.fullness;
    }

    public void setFullness(float fullness) {
        this.fullness = fullness;
    }

    public IFluidHandler getFluidHandler(Direction side) {
        return null;
    }

    @Override
    protected Pipe createPipe(Level level, BlockPos pos) {
        return new FluidPipe(level, pos, this.type);
    }
}

